/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.redshift;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.redshift.RedshiftExecutionFactory;

public class TestRedshiftTranslator {
    private static RedshiftExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new RedshiftExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.setDatabaseVersion(RedshiftExecutionFactory.NINE_3);
        TRANSLATOR.start();
    }

    @Test
    public void testLocate() throws Exception {
        String input = "SELECT INTKEY, STRINGKEY FROM bqt1.SmallA WHERE LOCATE('1', STRINGKEY, 2) IN (1, 2)";
        String output = "SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA WHERE (position('1' in substring(SmallA.StringKey from 2)) + 1) IN (1, 2)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testParseDate() throws Exception {
        String input = "SELECT INTKEY FROM bqt1.SmallA WHERE parsedate(stringkey, 'yyyy-MM dd') = {d '1999-12-01'}";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE cast(TO_DATE(SmallA.StringKey, 'YYYY-MM DD') AS date) = DATE '1999-12-01'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimezoneFormat() throws Exception {
        Assert.assertFalse((boolean)TRANSLATOR.supportsFormatLiteral("hh:MM:ss Z", ExecutionFactory.Format.DATE));
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"create temporary  table foo (COL1 int4, COL2 varchar(100)) ", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, true));
        Assert.assertEquals((Object)"create temporary  table foo (COL1 int4, COL2 varchar(100)) ", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, false));
    }
}

