/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.hsql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Select;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.hsql.AddDiffModifier;
import org.teiid.util.Version;

@Translator(name="hsql", description="A translator for open source HSQL Database")
public class HsqlExecutionFactory
extends JDBCExecutionFactory {
    public static Version TWO_0 = Version.getVersion((String)"2.0");

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("timestampadd", new AddDiffModifier(true, this.getLanguageFactory()));
        this.registerFunctionModifier("timestampdiff", new AddDiffModifier(false, this.getLanguageFactory()));
        ConvertModifier convert = new ConvertModifier();
        convert.addTypeMapping("boolean", 2);
        convert.addTypeMapping("tinyint", 3);
        convert.addTypeMapping("smallint", 4);
        convert.addTypeMapping("int", 5);
        convert.addTypeMapping("bigint", 6);
        convert.addTypeMapping("real", 8);
        convert.addTypeMapping("double", 9);
        convert.addTypeMapping("decimal", 10);
        convert.addTypeMapping("decimal(38,0)", 7);
        convert.addTypeMapping("date", 11);
        convert.addTypeMapping("time", 12);
        convert.addTypeMapping("timestamp", 13);
        convert.addTypeMapping("char(1)", 1);
        convert.addTypeMapping("varchar(4000)", 0);
        this.registerFunctionModifier("convert", convert);
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(dateValue) + "'";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME '" + this.formatDateValue(timeValue) + "'";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP '" + this.formatDateValue(timestampValue) + "'";
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitor");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("degrees");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("radians");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("insert");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("dayname");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("timestampadd");
        supportedFunctions.add("timestampdiff");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("convert");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("coalesce");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        return "org.hibernate.dialect.HSQLDialect";
    }

    @Override
    public boolean supportsDependentJoins() {
        return this.getVersion().compareTo(TWO_0) >= 0;
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        Select select;
        if (command instanceof Select && ((select = (Select)command).getFrom() == null || select.getFrom().isEmpty())) {
            ArrayList<String> result = new ArrayList<String>();
            result.add("VALUES(");
            for (int i = 0; i < select.getDerivedColumns().size(); ++i) {
                DerivedColumn dc = (DerivedColumn)select.getDerivedColumns().get(i);
                if (i != 0) {
                    result.add(", ");
                }
                result.add((String)dc.getExpression());
            }
            result.add(")");
            return result;
        }
        return super.translateCommand(command, context);
    }

    @Override
    public boolean useParensForJoins() {
        return true;
    }

    @Override
    public boolean isSourceRequiredForCapabilities() {
        return true;
    }
}

