/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.pi;

import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedTable;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Join;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedProcedureCall;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.SetQuery;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.TableReference;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Procedure;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.pi.PIExecutionFactory;

public class PISQLConversionVisitor
extends SQLConversionVisitor {
    private static final String APPLY = "APPLY";
    PIExecutionFactory executionFactory;

    public PISQLConversionVisitor(PIExecutionFactory hef) {
        super(hef);
        this.executionFactory = hef;
    }

    public void visit(SetQuery obj) {
        Limit limit = obj.getLimit();
        if (limit != null) {
            this.buffer.append("SELECT");
            this.buffer.append(" ");
            this.append((LanguageObject)limit);
            this.buffer.append(" ");
            this.buffer.append("*");
            this.buffer.append(" ");
            this.buffer.append("FROM");
            this.buffer.append(" ");
            this.buffer.append("(");
        }
        if (obj.getWith() != null) {
            this.append((LanguageObject)obj.getWith());
        }
        this.appendSetQuery(obj, obj.getLeftQuery(), false);
        this.buffer.append(" ");
        this.appendSetOperation(obj.getOperation());
        if (obj.isAll()) {
            this.buffer.append(" ");
            this.buffer.append("ALL");
        }
        this.buffer.append(" ");
        this.appendSetQuery(obj, obj.getRightQuery(), true);
        OrderBy orderBy = obj.getOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)orderBy);
        }
        if (limit != null) {
            this.buffer.append(")");
            this.buffer.append(" ");
            this.buffer.append("_X_");
        }
    }

    public void visit(Join obj) {
        TableReference leftItem = obj.getLeftItem();
        TableReference rightItem = obj.getRightItem();
        Join.JoinType joinType = obj.getJoinType();
        boolean ignoreOnClause = false;
        Condition condition = obj.getCondition();
        if (this.useParensForJoins() && leftItem instanceof Join) {
            this.buffer.append("(");
            this.append((LanguageObject)leftItem);
            this.buffer.append(")");
        } else {
            this.append((LanguageObject)leftItem);
        }
        this.buffer.append(" ");
        switch (joinType) {
            case CROSS_JOIN: {
                if (this.hasLateralJoin(rightItem)) {
                    if (!this.isTVF(rightItem)) {
                        throw new TeiidRuntimeException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11025, new Object[]{rightItem}));
                    }
                    this.buffer.append("CROSS").append(" ").append(APPLY).append(" ");
                    ignoreOnClause = true;
                    break;
                }
                this.buffer.append("INNER").append(" ").append("JOIN").append(" ");
                Literal e1 = LanguageFactory.INSTANCE.createLiteral((Object)new Integer(1), Integer.class);
                Comparison criteria = new Comparison((Expression)e1, (Expression)e1, Comparison.Operator.EQ);
                condition = criteria;
                break;
            }
            case FULL_OUTER_JOIN: {
                throw new TeiidRuntimeException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11024, new Object[]{"FULL OUTER"}));
            }
            case INNER_JOIN: {
                this.buffer.append("INNER").append(" ").append("JOIN").append(" ");
                break;
            }
            case LEFT_OUTER_JOIN: {
                if (!this.hasLateralJoin(leftItem) && !this.hasLateralJoin(rightItem)) {
                    this.buffer.append("LEFT").append(" ").append("OUTER").append(" ").append("JOIN").append(" ");
                    break;
                }
                if (this.hasLateralJoin(leftItem)) {
                    throw new TeiidRuntimeException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11024, new Object[]{"RIGHT OUTER APPLY"}));
                }
                if (!this.hasLateralJoin(rightItem)) break;
                if (!this.isTVF(rightItem)) {
                    throw new TeiidRuntimeException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11025, new Object[]{rightItem}));
                }
                this.buffer.append("OUTER").append(" ").append(APPLY).append(" ");
                ignoreOnClause = true;
                break;
            }
            case RIGHT_OUTER_JOIN: {
                throw new TeiidRuntimeException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11024, new Object[]{"RIGHT OUTER"}));
            }
            default: {
                this.buffer.append("<undefined>");
            }
        }
        if (rightItem instanceof Join && (this.useParensForJoins() || obj.getJoinType() == Join.JoinType.CROSS_JOIN)) {
            this.buffer.append("(");
            this.append((LanguageObject)(this.hasLateralJoin(rightItem) ? this.unwrap(rightItem) : rightItem));
            this.buffer.append(")");
        } else {
            this.append((LanguageObject)(this.hasLateralJoin(rightItem) ? this.unwrap(rightItem) : rightItem));
        }
        if (condition != null && !ignoreOnClause) {
            this.buffer.append(" ").append("ON").append(" ");
            this.append((LanguageObject)condition);
        }
    }

    private TableReference unwrap(TableReference table) {
        if (table instanceof DerivedTable) {
            return table;
        }
        if (table instanceof NamedProcedureCall) {
            NamedProcedureCall npc = (NamedProcedureCall)table;
            return npc.getCall();
        }
        return null;
    }

    protected void appendCallStart(Call call) {
        if (!this.isTVF(call.getMetadataObject())) {
            this.buffer.append("EXEC").append(" ");
        }
    }

    public void visit(ColumnReference obj) {
        if (obj.getMetadataObject() != null) {
            ColumnSet cs = obj.getMetadataObject().getParent();
            if (cs.getParent() instanceof Procedure && this.isTVF((Procedure)cs.getParent())) {
                this.shortNameOnly = true;
                super.visit(obj);
                this.shortNameOnly = false;
            } else {
                super.visit(obj);
            }
        } else {
            super.visit(obj);
        }
    }

    public void visit(DerivedTable obj) {
        this.buffer.append("(");
        this.append((LanguageObject)obj.getQuery());
        this.buffer.append(")");
        this.buffer.append(" ");
        if (this.useAsInGroupAlias()) {
            this.buffer.append("AS");
            this.buffer.append(" ");
        }
        this.buffer.append(obj.getCorrelationName());
    }

    @Override
    protected void appendLateralKeyword() {
        this.buffer.append("LATERAL");
    }

    public void visit(NamedProcedureCall obj) {
        this.buffer.append("(");
        this.append((LanguageObject)obj.getCall());
        this.buffer.append(")");
        this.buffer.append(" ");
        if (this.useAsInGroupAlias()) {
            this.buffer.append("AS");
            this.buffer.append(" ");
        }
        this.buffer.append(obj.getCorrelationName());
    }

    private boolean hasLateralJoin(TableReference table) {
        if (table instanceof DerivedTable) {
            return ((DerivedTable)table).isLateral();
        }
        if (table instanceof NamedProcedureCall) {
            return ((NamedProcedureCall)table).isLateral();
        }
        return false;
    }

    private boolean isTVF(TableReference table) {
        if (table instanceof NamedTable) {
            String value = ((NamedTable)table).getMetadataObject().getProperty("{http://www.teiid.org/translator/pi/2016}TVF", false);
            return Boolean.parseBoolean(value);
        }
        if (table instanceof NamedProcedureCall) {
            String value = ((NamedProcedureCall)table).getCall().getMetadataObject().getProperty("{http://www.teiid.org/translator/pi/2016}TVF", false);
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private boolean isTVF(Procedure proc) {
        String value = proc.getProperty("{http://www.teiid.org/translator/pi/2016}TVF", false);
        return Boolean.parseBoolean(value);
    }

    protected void appendQuantifier(SubqueryComparison obj) {
        if (obj.getQuantifier() == SubqueryComparison.Quantifier.SOME) {
            this.buffer.append("ANY");
        } else {
            super.appendQuantifier(obj);
        }
    }

    @Override
    public void visit(Comparison obj) {
        if (this.allowImplictConversion(obj)) {
            Function left = (Function)obj.getLeftExpression();
            obj.setLeftExpression((Expression)left.getParameters().get(0));
            Function right = (Function)obj.getRightExpression();
            obj.setRightExpression((Expression)right.getParameters().get(0));
        }
        super.visit(obj);
    }

    private boolean isConvertFunctionWithSimpleExpression(Expression expr) {
        if (expr instanceof Function && ((Function)expr).getName().equals("convert")) {
            Function f = (Function)expr;
            Expression param = (Expression)f.getParameters().get(0);
            if (param instanceof ColumnReference) {
                return true;
            }
            if (param instanceof Literal) {
                return true;
            }
        }
        return false;
    }

    private boolean allowImplictConversion(Comparison obj) {
        if (this.isConvertFunctionWithSimpleExpression(obj.getLeftExpression()) && this.isConvertFunctionWithSimpleExpression(obj.getRightExpression())) {
            String left = this.getParameterDataType(obj.getLeftExpression());
            String right = this.getParameterDataType(obj.getRightExpression());
            if (left.equals("integer") && right.equals("float")) {
                return true;
            }
            if (left.equals("float") && right.equals("integer")) {
                return true;
            }
        }
        return false;
    }

    private String getParameterDataType(Expression expr) {
        Function f = (Function)expr;
        Expression param = (Expression)f.getParameters().get(0);
        if (param instanceof ColumnReference) {
            return ((ColumnReference)param).getMetadataObject().getRuntimeType();
        }
        if (param instanceof Literal) {
            return DataTypeManager.getDataTypeName((Class)((Literal)param).getType());
        }
        return null;
    }
}

