/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.cdk.CommandBuilder;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;

public class TestEscapeSyntaxModifier
extends TestCase {
    public TestEscapeSyntaxModifier(String name) {
        super(name);
    }

    public void testEscape() {
        Literal arg1 = CommandBuilder.getLanuageFactory().createLiteral((Object)"arg1", String.class);
        Literal arg2 = CommandBuilder.getLanuageFactory().createLiteral((Object)"arg2", String.class);
        Function func = CommandBuilder.getLanuageFactory().createFunction("concat", Arrays.asList(arg1, arg2), Integer.class);
        this.helpTest(func, "{fn concat('arg1', 'arg2')}");
    }

    public void testTimestampAdd() {
        Literal arg1 = CommandBuilder.getLanuageFactory().createLiteral((Object)"SQL_TSI_HOUR", String.class);
        Literal arg2 = CommandBuilder.getLanuageFactory().createLiteral((Object)1, Integer.class);
        Literal arg3 = CommandBuilder.getLanuageFactory().createLiteral((Object)TimestampUtil.createTimestamp((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0), Timestamp.class);
        Function func = CommandBuilder.getLanuageFactory().createFunction("timestampadd", Arrays.asList(arg1, arg2, arg3), Timestamp.class);
        this.helpTest(func, "{fn timestampadd(SQL_TSI_HOUR, 1, {ts '1899-12-31 00:00:00.0'})}");
    }

    private void helpTest(Function func, String expected) {
        EscapeSyntaxModifier mod = new EscapeSyntaxModifier();
        List parts = mod.translate(func);
        StringBuffer sb = new StringBuffer();
        for (Object object : parts) {
            sb.append(object);
        }
        TestEscapeSyntaxModifier.assertEquals((String)expected, (String)sb.toString());
    }
}

