/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class TestModFunctionModifier
extends TestCase {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public TestModFunctionModifier(String name) {
        super(name);
    }

    public void helpTestMod(Expression[] args, String expectedStr) throws Exception {
        this.helpTestMod("MOD", args, expectedStr);
    }

    public void helpTestMod(final String modFunctionName, Expression[] args, String expectedStr) throws Exception {
        Expression param1 = args[0];
        Expression param2 = args[1];
        Function func = LANG_FACTORY.createFunction(modFunctionName, Arrays.asList(param1, param2), param1.getType());
        JDBCExecutionFactory trans = new JDBCExecutionFactory(){

            public void start() throws TranslatorException {
                super.start();
                this.registerFunctionModifier("mod", (FunctionModifier)new ModFunctionModifier(modFunctionName, this.getLanguageFactory()));
            }
        };
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        TestModFunctionModifier.assertEquals((String)"Modified function does not match", (String)expectedStr, (String)sqlVisitor.toString());
    }

    public void testTwoIntConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Integer(10), Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(6), Integer.class)};
        this.helpTestMod(args, "MOD(10, 6)");
    }

    public void testTwoIntConst2() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Integer(10), Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(6), Integer.class)};
        this.helpTestMod("MOD", args, "MOD(10, 6)");
    }

    public void testTwoIntConst5() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Integer(10), Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(6), Integer.class)};
        this.helpTestMod("%", args, "(10 % 6)");
    }

    public void testTwoLongConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(10L), Long.class), LANG_FACTORY.createLiteral((Object)new Long(6L), Long.class)};
        this.helpTestMod(args, "MOD(10, 6)");
    }

    public void testTwoLongConst2() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(10L), Long.class), LANG_FACTORY.createLiteral((Object)new Long(6L), Long.class)};
        this.helpTestMod("MOD", args, "MOD(10, 6)");
    }

    public void testTwoLongConst5() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Long(10L), Long.class), LANG_FACTORY.createLiteral((Object)new Long(6L), Long.class)};
        this.helpTestMod("%", args, "(10 % 6)");
    }

    public void testTwoFloatConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new Float(10.0f), Float.class), LANG_FACTORY.createLiteral((Object)new Float(6.0f), Float.class)};
        this.helpTestMod(args, "(10.0 - (sign(10.0) * floor(abs((10.0 / 6.0))) * abs(6.0)))");
    }

    public void testTwoBigIntConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new BigInteger("10"), BigInteger.class), LANG_FACTORY.createLiteral((Object)new BigInteger("6"), BigInteger.class)};
        this.helpTestMod(args, "(10 - (sign(10) * floor(abs((10 / 6))) * abs(6)))");
    }

    public void testTwoBigDecConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)new BigDecimal("10"), BigDecimal.class), LANG_FACTORY.createLiteral((Object)new BigDecimal("6"), BigDecimal.class)};
        this.helpTestMod(args, "(10 - (sign(10) * floor(abs((10 / 6))) * abs(6)))");
    }

    public void testOneIntElemOneIntConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createColumnReference("e1", null, null, Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(6), Integer.class)};
        this.helpTestMod(args, "MOD(e1, 6)");
    }

    public void testOneIntElemOneIntConst2() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createColumnReference("e1", null, null, Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(6), Integer.class)};
        this.helpTestMod("MOD", args, "MOD(e1, 6)");
    }

    public void testOneIntElemOneIntConst5() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createColumnReference("e1", null, null, Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(6), Integer.class)};
        this.helpTestMod("%", args, "(e1 % 6)");
    }

    public void testOneBigDecElemOneBigDecConst() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createColumnReference("e1", null, null, BigDecimal.class), LANG_FACTORY.createLiteral((Object)new BigDecimal(6), BigDecimal.class)};
        this.helpTestMod(args, "(e1 - (sign(e1) * floor(abs((e1 / 6))) * abs(6)))");
    }
}

