/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sybase;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.OrderBy;
import org.teiid.language.SetQuery;
import org.teiid.language.With;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.db2.DB2ExecutionFactory;

public class BaseSybaseExecutionFactory
extends JDBCExecutionFactory {
    @Override
    public boolean useAsInGroupAlias() {
        return false;
    }

    @Override
    public boolean hasTimeType() {
        return false;
    }

    @Override
    public int getTimestampNanoPrecision() {
        return 3;
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        if (!(command instanceof SetQuery)) {
            return null;
        }
        SetQuery queryCommand = (SetQuery)command;
        if (queryCommand.getLimit() == null) {
            return null;
        }
        Limit limit = queryCommand.getLimit();
        OrderBy orderBy = queryCommand.getOrderBy();
        queryCommand.setLimit(null);
        queryCommand.setOrderBy(null);
        ArrayList<Object> parts = new ArrayList<Object>(6);
        if (queryCommand.getWith() != null) {
            With with = queryCommand.getWith();
            queryCommand.setWith(null);
            parts.add(with);
        }
        parts.add("SELECT ");
        parts.addAll(this.translateLimit(limit, context));
        parts.add(" * FROM (");
        parts.add(queryCommand);
        parts.add(") AS X");
        if (orderBy != null) {
            parts.add(" ");
            parts.add(orderBy);
        }
        return parts;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (!this.supportsCrossJoin()) {
            DB2ExecutionFactory.convertCrossJoinToInner(obj, this.getLanguageFactory());
        }
        return super.translate(obj, context);
    }

    protected boolean supportsCrossJoin() {
        return false;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return Arrays.asList("TOP ", limit.getRowLimit());
    }

    @Override
    public boolean useSelectLimit() {
        return true;
    }

    @Override
    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        if (expectedType == TypeFacility.RUNTIME_TYPES.BYTE) {
            expectedType = TypeFacility.RUNTIME_TYPES.SHORT;
        }
        return super.retrieveValue(results, columnIndex, expectedType);
    }

    @Override
    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        if (expectedType == TypeFacility.RUNTIME_TYPES.BYTE) {
            expectedType = TypeFacility.RUNTIME_TYPES.SHORT;
        }
        return super.retrieveValue(results, parameterIndex, expectedType);
    }

    @Override
    public void bindValue(PreparedStatement stmt, Object param, Class<?> paramType, int i) throws SQLException {
        if (paramType == TypeFacility.RUNTIME_TYPES.BYTE) {
            paramType = TypeFacility.RUNTIME_TYPES.SHORT;
            param = ((Byte)param).shortValue();
        }
        super.bindValue(stmt, param, paramType, i);
    }

    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    public boolean booleanNullable() {
        return false;
    }

    @Override
    public String getTemporaryTableName(String prefix) {
        return "#" + super.getTemporaryTableName(prefix);
    }

    @Override
    protected boolean supportsBooleanExpressions() {
        return false;
    }
}

