/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.intersystemscache;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.intersyscache.InterSystemsCacheExecutionFactory;

public class TestInterSystemsCacheTranslation {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();
    private static InterSystemsCacheExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new InterSystemsCacheExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.start();
    }

    public String helpGetString(Expression expr) throws Exception {
        SQLConversionVisitor sqlVisitor = TRANSLATOR.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testStringToChar() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "char", "cast('5' AS character)");
    }

    @Test
    public void testBooleanToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "bigdecimal", "cast(1 AS decimal(38,19))");
    }

    @Test
    public void testByteToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testByteToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testBigIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "double", "1");
    }

    @Test
    public void testBigIntegerDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "biginteger", "cast(1 AS decimal(19,0))");
    }

    @Test
    public void testFloatToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "long", "cast(1.2 AS bigint)");
    }

    @Test
    public void testDoubleToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "short", "cast(1.2 AS smallint)");
    }

    @Test
    public void testBigDecimalToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "byte", "cast(1.0 AS tinyint)");
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)103, (int)10, (int)1), Date.class), "timestamp", "cast(to_date('2003-11-01', 'yyyy-mm-dd') AS timestamp)");
    }

    @Test
    public void testTimeToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)23, (int)59, (int)59), Time.class), "string", "cast(to_date('23:59:59', 'hh:mi:ss') AS varchar(4000))");
    }

    @Test
    public void testTimestampToString() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)0);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "string", "cast(to_timestamp('2003-11-01 12:05:02.0', 'yyyy-mm-dd hh:mi:ss.fffffffff') AS varchar(4000))");
    }

    @Test
    public void testLongToBigInt() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)5, Long.class), "long", "cast(5 AS bigint)");
    }

    @Test
    public void testSubstring1() throws Exception {
        String input = "SELECT intnum/intkey FROM BQT1.SMALLA";
        String output = "SELECT cast((SmallA.IntNum / SmallA.IntKey) AS integer) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

