/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.modeshape;

import java.util.Collection;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.language.Command;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.modeshape.ModeShapeExecutionFactory;

public class TestModeShapeSqlTranslator {
    private static ModeShapeExecutionFactory TRANSLATOR;
    private static TranslationUtility UTIL;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new ModeShapeExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.start();
        UTIL = new TranslationUtility((QueryMetadataInterface)TestModeShapeSqlTranslator.getMetadata());
        UTIL.addUDF("SYS", (Collection)TRANSLATOR.getPushDownFunctions());
    }

    public static TransformationMetadata getMetadata() {
        MetadataStore store = new MetadataStore();
        Schema modeshape = RealMetadataFactory.createPhysicalModel((String)"modeshape", (MetadataStore)store);
        Table nt_base = RealMetadataFactory.createPhysicalGroup((String)"nt_base", (Schema)modeshape);
        nt_base.setNameInSource("\"nt:base\"");
        List cols = RealMetadataFactory.createElements((ColumnSet)nt_base, (String[])new String[]{"jcr_path", "mode_properties", "jcr_primaryType", "prop"}, (String[])new String[]{"string", "string", "string", "string"});
        ((Column)cols.get(0)).setNameInSource("\"jcr:path\"");
        ((Column)cols.get(1)).setNameInSource("\"mode:properties\"");
        ((Column)cols.get(2)).setNameInSource("\"jcr:primaryType\"");
        Table nt_version = RealMetadataFactory.createPhysicalGroup((String)"nt_version", (Schema)modeshape);
        nt_version.setNameInSource("\"nt:version\"");
        List cols2 = RealMetadataFactory.createElements((ColumnSet)nt_version, (String[])new String[]{"jcr_path", "mode_properties", "jcr_primaryType", "prop"}, (String[])new String[]{"string", "string", "string", "string"});
        ((Column)cols2.get(0)).setNameInSource("\"jcr:path\"");
        ((Column)cols2.get(1)).setNameInSource("\"mode:properties\"");
        ((Column)cols2.get(2)).setNameInSource("\"jcr:primaryType\"");
        return RealMetadataFactory.createTransformationMetadata((MetadataStore)store, (String)"modeshape", (FunctionTree[])new FunctionTree[0]);
    }

    public void helpTestVisitor(String input, String expectedOutput) throws TranslatorException {
        Command obj = UTIL.parseCommand(input, true, true);
        TranslationHelper.helpTestVisitor(expectedOutput, (JDBCExecutionFactory)TRANSLATOR, obj);
    }

    @Test
    public void testSelectAllFromBase() throws Exception {
        String input = "select * from nt_base";
        String output = "SELECT g_0.\"jcr:path\", g_0.\"mode:properties\", g_0.\"jcr:primaryType\", g_0.prop FROM \"nt:base\" AS g_0";
        this.helpTestVisitor(input, output);
    }

    @Test
    public void testPredicate() throws Exception {
        String input = "SELECT x.jcr_primaryType from nt_base inner join nt_base as x on jcr_issamenode(nt_base.jcr_path, x.jcr_path) = true where jcr_isdescendantnode(nt_base.jcr_path, 'x/y/z') = true and jcr_reference(nt_base.mode_properties) = 'x'";
        String output = "SELECT g_1.\"jcr:primaryType\" FROM \"nt:base\" AS g_0 INNER JOIN \"nt:base\" AS g_1 ON ISSAMENODE(g_0, g_1) WHERE ISDESCENDANTNODE(g_0, 'x/y/z') AND REFERENCE(g_0.*) = 'x'";
        this.helpTestVisitor(input, output);
    }

    @Test
    public void testOrderBy() throws Exception {
        String input = "SELECT jcr_primaryType from nt_base ORDER BY jcr_primaryType";
        String output = "SELECT g_0.\"jcr:primaryType\" AS c_0 FROM \"nt:base\" AS g_0 ORDER BY c_0";
        this.helpTestVisitor(input, output);
    }

    @Test
    public void testUsingLike() throws Exception {
        String input = "SELECT jcr_primaryType from nt_base WHERE jcr_primaryType LIKE '%relational%'";
        String output = "SELECT g_0.\"jcr:primaryType\" FROM \"nt:base\" AS g_0 WHERE g_0.\"jcr:primaryType\" LIKE '%relational%'";
        this.helpTestVisitor(input, output);
    }

    @Test
    public void testSelectJoin() throws Exception {
        String input = "select nt_base.jcr_path from nt_base join nt_version  ON JCR_ISCHILDNODE(nt_base.jcr_path, nt_version.jcr_path)";
        String output = "SELECT g_0.\"jcr:path\" FROM \"nt:base\" AS g_0 INNER JOIN \"nt:version\" AS g_1 ON ISCHILDNODE(g_0, g_1)";
        this.helpTestVisitor(input, output);
    }

    @Test
    public void testOnCondition() throws Exception {
        String input = "select nt_base.jcr_path from nt_base join nt_version  ON JCR_ISCHILDNODE(nt_base.jcr_path, nt_version.jcr_path) and nt_base.jcr_path = nt_version.jcr_path";
        String output = "SELECT g_0.\"jcr:path\" FROM \"nt:base\" AS g_0 INNER JOIN \"nt:version\" AS g_1 ON g_0.\"jcr:path\" = g_1.\"jcr:path\" WHERE ISCHILDNODE(g_0, g_1)";
        this.helpTestVisitor(input, output);
        input = "select nt_base.jcr_path from nt_base join nt_version  ON JCR_ISCHILDNODE(nt_base.jcr_path, nt_version.jcr_path) or nt_base.jcr_path = nt_version.jcr_path";
        output = "SELECT g_0.\"jcr:path\" FROM \"nt:base\" AS g_0 INNER JOIN \"nt:version\" AS g_1 ON ISCHILDNODE(g_0, g_1) OR g_0.\"jcr:path\" = g_1.\"jcr:path\"";
        this.helpTestVisitor(input, output);
    }
}

