/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.netezza;

import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.language.LanguageFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.netezza.NetezzaExecutionFactory;

public class TestNetezzaTranslatorSourceSystemFunctions {
    private static NetezzaExecutionFactory TRANSLATOR;
    private static final LanguageFactory LANG_FACTORY;

    @BeforeClass
    public static void oneTimeSetup() throws TranslatorException {
        TRANSLATOR = new NetezzaExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.start();
    }

    private String getTestBQTVDB() {
        return "/bqt.vdb";
    }

    @Test
    public void testLcaseUcase() throws Exception {
        String input = "select lcase(StringKey), ucase(StringKey) FROM BQT1.SmallA";
        String output = "SELECT lower(SmallA.StringKey), upper(SmallA.StringKey) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testPad() throws Exception {
        String input = "select lpad(smalla.stringkey, 18), rpad(smalla.stringkey, 12) from bqt1.smalla";
        String output = "SELECT lpad(SmallA.StringKey, 18), rpad(SmallA.StringKey, 12) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testIFNull() throws Exception {
        String input = "SELECT ifnull(StringKey, 'otherString') FROM BQT1.SmallA";
        String output = "SELECT NVL(SmallA.StringKey, 'otherString') FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSubstring1() throws Exception {
        String input = "SELECT substring(StringKey, 1) FROM BQT1.SmallA";
        String output = "SELECT substring(SmallA.StringKey, 1) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSubstring2() throws Exception {
        String input = "SELECT substring(StringKey, 1, 5) FROM BQT1.SmallA";
        String output = "SELECT substring(SmallA.StringKey, 1, 5) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConcat_withLiteral() throws Exception {
        String input = "select stringnum || '1' from BQT1.Smalla";
        String output = "SELECT (SmallA.StringNum || '1') FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate() throws Exception {
        String input = "SELECT locate(INTNUM, 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', cast(SmallA.IntNum AS varchar(4000)), 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate2() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp') FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate3() throws Exception {
        String input = "SELECT locate(INTNUM, '234567890', 1) FROM BQT1.SMALLA WHERE INTKEY = 26";
        String output = "SELECT INSTR('234567890', cast(SmallA.IntNum AS varchar(4000)), 1) FROM SmallA WHERE SmallA.IntKey = 26";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate4() throws Exception {
        String input = "SELECT locate('c', 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT 1 FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate5() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', -5) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum, 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate6() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', INTNUM) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum, CASE WHEN SmallA.IntNum < 1 THEN 1 ELSE SmallA.IntNum END) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate7() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', LOCATE(STRINGNUM, 'chimp') + 1) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum, CASE WHEN (INSTR('chimp', SmallA.StringNum) + 1) < 1 THEN 1 ELSE (INSTR('chimp', SmallA.StringNum) + 1) END) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testCeil() throws Exception {
        String input = "SELECT ceiling(sqrt(INTKEY)) FROM BQT1.SMALLA";
        String output = "SELECT ceil(sqrt(SmallA.IntKey)) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testPower() throws Exception {
        String input = "SELECT power(INTKEY, 2) FROM BQT1.SMALLA";
        String output = "SELECT pow(SmallA.IntKey, 2) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBitAnd() throws Exception {
        String input = "select bitand(intkey, intnum) from bqt1.smalla";
        String output = "SELECT int4and(SmallA.IntKey, SmallA.IntNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBitNot() throws Exception {
        String input = "select bitnot(intkey) from bqt1.smalla";
        String output = "SELECT int4not(SmallA.IntKey) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBitOr() throws Exception {
        String input = "select bitor(intkey, intnum) from bqt1.smalla";
        String output = "SELECT int4or(SmallA.IntKey, SmallA.IntNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBitXor() throws Exception {
        String input = "select bitxor(intkey, intnum) from bqt1.smalla";
        String output = "SELECT int4xor(SmallA.IntKey, SmallA.IntNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    static {
        LANG_FACTORY = new LanguageFactory();
    }
}

