/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sqlserver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.CommandBuilder;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.language.Command;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.sqlserver.SQLServerExecutionFactory;

public class TestSqlServerConversionVisitor {
    private static SQLServerExecutionFactory trans = new SQLServerExecutionFactory();

    @Before
    public void setUp() throws Exception {
        trans = new SQLServerExecutionFactory();
        trans.setDatabaseVersion("2005");
        trans.start();
    }

    public String getTestVDB() {
        return "/PartsSupplier.vdb";
    }

    public String getBQTVDB() {
        return "/bqt.vdb";
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) throws TranslatorException {
        TranslationHelper.helpTestVisitor(vdb, input, expectedOutput, (JDBCExecutionFactory)trans);
    }

    @Test
    public void testModFunction() throws Exception {
        String input = "SELECT mod(CONVERT(PART_ID, INTEGER), 13) FROM parts";
        String output = "SELECT (cast(PARTS.PART_ID AS int) % 13) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConcatFunction() throws Exception {
        String input = "SELECT concat(part_name, 'b') FROM PARTS";
        String output = "SELECT (PARTS.PART_NAME + 'b') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfMonthFunction() throws Exception {
        String input = "SELECT dayofmonth(convert(PARTS.PART_ID, date)) FROM PARTS";
        String output = "SELECT {fn dayofmonth(cast(PARTS.PART_ID AS datetime))} FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testRowLimit() throws Exception {
        String input = "select intkey from bqt1.smalla limit 100";
        String output = "SELECT TOP 100 SmallA.IntKey FROM SmallA";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testRowLimitAndCTE() throws Exception {
        String input = "with x (a) as (select intkey from bqt1.smalla) select a from x union all select a from x limit 100";
        String output = "WITH x (a) AS (SELECT SmallA.IntKey FROM SmallA) SELECT TOP 100 * FROM (SELECT x.a FROM x UNION ALL SELECT x.a FROM x) AS X";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testUnionLimitWithOrderBy() throws Exception {
        String input = "select intkey from bqt1.smalla union select intnum from bqt1.smalla order by intkey limit 100";
        String output = "SELECT TOP 100 * FROM (SELECT SmallA.IntKey FROM SmallA UNION SELECT SmallA.IntNum FROM SmallA) AS X ORDER BY intkey";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testLimitWithOrderByUnrelated() throws Exception {
        String input = "select intkey from bqt1.smalla order by intnum limit 100";
        String output = "SELECT TOP 100 SmallA.IntKey FROM SmallA ORDER BY SmallA.IntNum";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testDateFunctions() throws Exception {
        String input = "select dayName(timestampValue), dayOfWeek(timestampValue), quarter(timestampValue), week(timestampvalue) from bqt1.smalla";
        String output = "SELECT {fn dayname(SmallA.TimestampValue)}, {fn dayofweek(SmallA.TimestampValue)}, {fn quarter(SmallA.TimestampValue)}, DATEPART(ISO_WEEK, SmallA.TimestampValue) FROM SmallA";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testConvert() throws Exception {
        String input = "select convert(timestampvalue, date), convert(timestampvalue, string), convert(datevalue, string) from bqt1.smalla";
        String output = "SELECT cast(replace(convert(varchar, SmallA.TimestampValue, 102), '.', '-') AS datetime), convert(varchar, SmallA.TimestampValue, 21), replace(convert(varchar, SmallA.DateValue, 102), '.', '-') FROM SmallA";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testConvertDate() throws Exception {
        String input = "select stringkey from bqt1.smalla where BQT1.SmallA.DateValue IN (convert('2000-01-12', date), convert('2000-02-02', date))";
        String output = "SELECT SmallA.StringKey FROM SmallA WHERE SmallA.DateValue IN (CAST('2000-01-12 00:00:00.0' AS DATETIME), CAST('2000-02-02 00:00:00.0' AS DATETIME))";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testConvertTime() throws Exception {
        String input = "select cast('12:00:00' as time) from bqt1.smalla";
        String output = "SELECT CAST('1970-01-01 12:00:00.0' AS DATETIME) FROM SmallA";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testConvertDate2008() throws Exception {
        trans = new SQLServerExecutionFactory();
        trans.setDatabaseVersion("2008");
        trans.start();
        String input = "select stringkey from bqt1.smalla where BQT1.SmallA.DateValue IN (convert('2000-01-12', date), convert('2000-02-02', date))";
        String output = "SELECT SmallA.StringKey FROM SmallA WHERE SmallA.DateValue IN (CAST('2000-01-12' AS DATE), CAST('2000-02-02' AS DATE))";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testTimeLiteral2008() throws Exception {
        trans = new SQLServerExecutionFactory();
        trans.setDatabaseVersion("2008");
        trans.start();
        String input = "select stringkey from bqt1.smalla where BQT1.SmallA.TimeValue = {t '00:00:00'}";
        String output = "SELECT SmallA.StringKey FROM SmallA WHERE SmallA.TimeValue = cast('00:00:00' as time)";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testTimestampConversion2008() throws Exception {
        trans = new SQLServerExecutionFactory();
        trans.setDatabaseVersion("2008");
        trans.start();
        String input = "select stringkey from bqt1.smalla where cast(BQT1.SmallA.Timestampvalue as time) = timevalue";
        String output = "SELECT SmallA.StringKey FROM SmallA WHERE cast(SmallA.TimestampValue AS time) = SmallA.TimeValue";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testUniqueidentifier() throws Exception {
        MetadataStore metadataStore = new MetadataStore();
        Schema foo = RealMetadataFactory.createPhysicalModel((String)"foo", (MetadataStore)metadataStore);
        Table table = RealMetadataFactory.createPhysicalGroup((String)"bar", (Schema)foo);
        String[] elemNames = new String[]{"x"};
        String[] elemTypes = new String[]{"string"};
        List cols = RealMetadataFactory.createElements((ColumnSet)table, (String[])elemNames, (String[])elemTypes);
        Column obj = (Column)cols.get(0);
        obj.setNativeType("uniqueidentifier");
        CompositeMetadataStore store = new CompositeMetadataStore(metadataStore);
        TransformationMetadata metadata = new TransformationMetadata(null, store, null, RealMetadataFactory.SFM.getSystemFunctions(), null);
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command command = tu.parseCommand("select max(x) from bar");
        TranslationHelper.helpTestVisitor("SELECT MAX(bar.x) FROM bar", (JDBCExecutionFactory)trans, command);
        command = tu.parseCommand("select * from (select max(x) as max from bar) x");
        TranslationHelper.helpTestVisitor("SELECT x.max FROM (SELECT MAX(bar.x) AS max FROM bar) x", (JDBCExecutionFactory)trans, command);
        command = tu.parseCommand("insert into bar (x) values ('a')");
        TranslationHelper.helpTestVisitor("INSERT INTO bar (x) VALUES ('a')", (JDBCExecutionFactory)trans, command);
        trans = new SQLServerExecutionFactory();
        trans.setDatabaseVersion("2000");
        trans.start();
        command = tu.parseCommand("select max(x) from bar");
        TranslationHelper.helpTestVisitor("SELECT MAX(cast(bar.x as char(36))) FROM bar", (JDBCExecutionFactory)trans, command);
        command = tu.parseCommand("select * from (select max(x) as max from bar) x");
        TranslationHelper.helpTestVisitor("SELECT x.max FROM (SELECT MAX(cast(bar.x as char(36))) AS max FROM bar) x", (JDBCExecutionFactory)trans, command);
    }

    @Test
    public void testRowLimitWithInlineViewOrderBy() throws Exception {
        String input = "select intkey from (select intkey from bqt1.smalla) as x order by intkey limit 100";
        String output = "SELECT TOP 100 v_0.c_0 FROM (SELECT g_0.IntKey AS c_0 FROM SmallA g_0) v_0 ORDER BY v_0.c_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testWith() throws Exception {
        String input = "with x as /*+ no_inline */ (select intkey from bqt1.smalla) select intkey from x limit 100";
        String output = "WITH x (IntKey) AS (SELECT g_0.IntKey FROM SmallA g_0) SELECT TOP 100 g_1.intkey AS c_0 FROM x g_1";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testParseFormat() throws Exception {
        String input = "select parsetimestamp(smalla.timestampvalue, 'yyyy.MM.dd'), formattimestamp(smalla.timestampvalue, 'yy.MM.dd') from bqt1.smalla";
        String output = "SELECT CONVERT(DATETIME, convert(varchar, g_0.TimestampValue, 21), 102), CONVERT(VARCHAR, g_0.TimestampValue, 2) FROM SmallA g_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"create table foo (COL1 int, COL2 varchar(100)) ", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)trans, true));
    }

    @Test
    public void testUnicodeLiteral() throws Exception {
        String input = "select N'\u0fff'";
        String output = "SELECT N'\u0fff'";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testConvertSupport() throws Exception {
        Assert.assertTrue((boolean)trans.supportsConvert(14, 12));
        Assert.assertTrue((boolean)trans.supportsConvert(14, 5));
        Assert.assertFalse((boolean)trans.supportsConvert(14, 16));
        Assert.assertTrue((boolean)trans.supportsConvert(13, 12));
    }

    @Test
    public void testWithInsert() throws Exception {
        String input = "insert into bqt1.smalla (intkey) with a (x) as /*+ no_inline */ (select intnum from bqt1.smallb) select x from a";
        String output = "WITH a (x) AS (SELECT SmallB.IntNum FROM SmallB) INSERT INTO SmallA (IntKey) SELECT a.x FROM a";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testLocate() throws Exception {
        String input = "select locate('a', stringkey, 2) from bqt1.smalla";
        String output = "SELECT CHARINDEX('a', g_0.StringKey, 2) FROM SmallA g_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testDateFormat() throws Exception {
        trans = new SQLServerExecutionFactory();
        trans.setDatabaseVersion("2008");
        trans.start();
        Connection c = (Connection)Mockito.mock(Connection.class);
        Mockito.stub((Object)c.getMetaData()).toReturn(Mockito.mock(DatabaseMetaData.class));
        trans.initCapabilities(c);
        String input = "select cast(smalla.stringkey as date), formatdate(smalla.datevalue, 'dd/MM/yy'), parsedate(smalla.stringkey, 'dd/MM/yy') from bqt1.smalla where smalla.datevalue = {d'2000-01-01'}";
        String output = "SELECT cast(SmallA.StringKey AS date), CONVERT(VARCHAR, cast(SmallA.DateValue AS datetime2), 3), cast(CONVERT(DATETIME2, SmallA.StringKey, 3) AS DATE) FROM SmallA WHERE SmallA.DateValue = CAST('2000-01-01' AS DATE)";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testRecursiveCTEWithTypeMatching() throws Exception {
        String input = "with a (intkey, stringkey, bigintegervalue) as (select intkey, NULL as stringkey, bigintegervalue from bqt1.smalla where intkey = 1 union all  select n.intkey, n.stringkey, 1 from bqt1.smalla n inner join a rcte on n.intkey = rcte.intkey + 1) select * from a";
        String output = "WITH a (intkey, stringkey, bigintegervalue) AS (SELECT cast(g_2.IntKey AS int) AS c_0, cast(NULL AS char) AS c_1, cast(g_2.BigIntegerValue AS numeric(38, 0)) AS c_2 FROM SmallA g_2 WHERE g_2.IntKey = 1 UNION ALL SELECT cast(g_0.IntKey AS int) AS c_0, g_0.StringKey AS c_1, cast(1 AS numeric(38, 0)) AS c_2 FROM SmallA g_0 INNER JOIN a g_1 ON g_0.IntKey = (g_1.intkey + 1)) SELECT g_3.intkey, g_3.stringkey, g_3.bigintegervalue FROM a g_3";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testOffset() throws Exception {
        String input = "select intkey from bqt1.smalla limit 10, 20";
        String output = "SELECT * FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY @@version) ROWNUM_ FROM (SELECT SmallA.IntKey FROM SmallA) v) v WHERE ROWNUM_ <= 30 AND ROWNUM_ > 10";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans);
        input = "select intkey c1 from bqt1.smalla offset 20 rows";
        output = "SELECT c1 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY @@version) ROWNUM_ FROM (SELECT SmallA.IntKey AS c1 FROM SmallA) v) v WHERE ROWNUM_ > 20";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans);
        input = "select intkey c1 from bqt1.smalla order by stringkey offset 20 rows ";
        output = "SELECT c1 FROM (SELECT SmallA.IntKey AS c1, ROW_NUMBER() OVER (ORDER BY SmallA.StringKey) AS ROWNUM_ FROM SmallA) v WHERE ROWNUM_ > 20 ORDER BY ROWNUM_";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans);
        input = "select intkey c1, stringkey c2 from bqt1.smalla union all select 1, '2' from bqt1.smallb order by c2 limit 10, 20";
        output = "SELECT c1, c2 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY c2) ROWNUM_ FROM (SELECT SmallA.IntKey AS c1, SmallA.StringKey AS c2 FROM SmallA UNION ALL SELECT 1, '2' FROM SmallB) v) v WHERE ROWNUM_ <= 30 AND ROWNUM_ > 10 ORDER BY ROWNUM_";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans);
        input = "select distinct intkey c1 from bqt1.smalla order by c1 limit 10, 20";
        output = "SELECT c1 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY c1) ROWNUM_ FROM (SELECT DISTINCT SmallA.IntKey AS c1 FROM SmallA) v) v WHERE ROWNUM_ <= 30 AND ROWNUM_ > 10 ORDER BY ROWNUM_";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans);
    }

    @Test
    public void testOffset2012() throws Exception {
        String input = "select intkey from bqt1.smalla limit 10, 20";
        String output = "SELECT SmallA.IntKey FROM SmallA ORDER BY @@version OFFSET 10 ROWS FETCH NEXT 20 ROWS ONLY";
        SQLServerExecutionFactory trans1 = new SQLServerExecutionFactory();
        trans1.setDatabaseVersion("2012");
        trans1.start();
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
        input = "select intkey from bqt1.smalla order by stringkey limit 20";
        output = "SELECT SmallA.IntKey FROM SmallA ORDER BY SmallA.StringKey OFFSET 0 ROWS FETCH NEXT 20 ROWS ONLY";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
        input = "select distinct intkey c1 from bqt1.smalla limit 10, 20";
        output = "SELECT c1 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY @@version) ROWNUM_ FROM (SELECT DISTINCT SmallA.IntKey AS c1 FROM SmallA) v) v WHERE ROWNUM_ <= 30 AND ROWNUM_ > 10";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
        input = "select distinct intkey c1 from bqt1.smalla limit 20";
        output = "SELECT c1 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY @@version) ROWNUM_ FROM (SELECT DISTINCT SmallA.IntKey AS c1 FROM SmallA) v) v WHERE ROWNUM_ <= 20 AND ROWNUM_ > 0";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
        input = "select intkey c1 from bqt1.smalla union select intkey c1 from bqt1.smalla limit 10";
        output = "SELECT c1 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY @@version) ROWNUM_ FROM (SELECT SmallA.IntKey AS c1 FROM SmallA UNION SELECT SmallA.IntKey AS c1 FROM SmallA) v) v WHERE ROWNUM_ <= 10 AND ROWNUM_ > 0";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
        input = "select intkey c1 from bqt1.smalla union select intkey c1 from bqt1.smalla limit 1, 10";
        output = "SELECT c1 FROM (SELECT v.*, ROW_NUMBER() OVER (ORDER BY @@version) ROWNUM_ FROM (SELECT SmallA.IntKey AS c1 FROM SmallA UNION SELECT SmallA.IntKey AS c1 FROM SmallA) v) v WHERE ROWNUM_ <= 11 AND ROWNUM_ > 1";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
        input = "select intkey c1 from bqt1.smalla union all select intkey c1 from bqt1.smalla order by c1 limit 1, 10";
        output = "SELECT SmallA.IntKey AS c1 FROM SmallA UNION ALL SELECT SmallA.IntKey AS c1 FROM SmallA ORDER BY c1 OFFSET 1 ROWS FETCH NEXT 10 ROWS ONLY";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
    }

    @Test
    public void testHashFunctions() throws Exception {
        String input = "select md5(stringkey), sha2_256(stringkey) from bqt1.smalla";
        String output = "SELECT HASHBYTES('MD5', SmallA.StringKey), HASHBYTES('SHA2_256', SmallA.StringKey) FROM SmallA";
        SQLServerExecutionFactory trans1 = new SQLServerExecutionFactory();
        trans1.setDatabaseVersion("2012");
        trans1.start();
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
    }

    @Test
    public void testDateTime2() throws Exception {
        String input = "insert into bqt1.smalla (timestampvalue) values ('2001-01-01')";
        String output = "INSERT INTO SmallA (TimestampValue) VALUES ({ts '2001-01-01 00:00:00.0'})";
        SQLServerExecutionFactory trans1 = new SQLServerExecutionFactory();
        trans1.setDatabaseVersion("2008");
        trans1.start();
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)trans1);
    }

    @Test
    public void testBooleanExpression() throws Exception {
        String input = "select stringkey is null, case when stringkey = 'b' then 1 end, coalesce(intkey = 1, true) from bqt1.smalla";
        String output = "SELECT CASE WHEN g_0.StringKey IS NULL THEN 1 ELSE 0 END, CASE WHEN g_0.StringKey = 'b' THEN 1 END, isnull(CASE WHEN g_0.IntKey = 1 THEN 1 WHEN NOT (g_0.IntKey = 1) THEN 0 END, 1) FROM SmallA g_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)trans, obj);
    }

    @Test
    public void testUpperLower() throws Exception {
        String input = "select upper(txt), lower(ntxt), upper(str) from tbl";
        String output = "SELECT upper(cast(tbl.txt AS varchar(max))), lower(cast(tbl.ntxt AS nvarchar(max))), upper(tbl.str) FROM tbl";
        TranslationHelper.helpTestVisitor("create foreign table tbl (txt string options (native_type 'text'), ntxt string options (native_type 'ntext'), str string)", input, output, (JDBCExecutionFactory)trans);
    }

    @Test
    public void testNCharCast() throws Exception {
        String input = "select cast(txt as char) from tbl";
        String output = "SELECT cast(tbl.txt AS nchar(1)) FROM tbl";
        SQLServerExecutionFactory trans1 = new SQLServerExecutionFactory();
        trans1.setDatabaseVersion("2008");
        trans1.start();
        TranslationHelper.helpTestVisitor("create foreign table tbl (txt string options (native_type 'ntext'))", input, output, (JDBCExecutionFactory)trans);
    }

    @Test
    public void testRecursiveCTEWithStringLiteral() throws Exception {
        String input = "WITH tmp_cte(id, name, fk, fkname, lvl) AS \n    (SELECT id, name, fk, cast(NULL as string) as fkname, 0 as lvl \n            FROM cte_source WHERE fk IS NULL \n     UNION ALL \n     SELECT e.id, e.name, e.fk, ecte.name as fkname, lvl + 1 as lvl \n           FROM cte_source AS e \n           INNER JOIN tmp_cte AS ecte ON ecte.id = e.fk\n     ) \nSELECT * FROM tmp_cte order by lvl";
        String output = "WITH tmp_cte (id, name, fk, fkname, lvl) AS (SELECT cast(cte_source.id AS int), cte_source.name, cast(cte_source.fk AS int), cast(NULL AS varchar(4000)) AS fkname, cast(0 AS int) AS lvl FROM cte_source WHERE cte_source.fk IS NULL UNION ALL SELECT cast(e.id AS int), e.name, cast(e.fk AS int), cast(ecte.name AS varchar(4000)) AS fkname, cast((ecte.lvl + 1) AS int) AS lvl FROM cte_source e INNER JOIN tmp_cte ecte ON ecte.id = e.fk) SELECT tmp_cte.id, tmp_cte.name, tmp_cte.fk, tmp_cte.fkname, tmp_cte.lvl FROM tmp_cte ORDER BY tmp_cte.lvl";
        TranslationHelper.helpTestVisitor("create foreign table cte_source (id integer, name string options (native_type 'varchar(255)'), fk integer)", input, output, (JDBCExecutionFactory)trans);
    }

    @Test
    public void testVariantCast() throws Exception {
        Assert.assertTrue((boolean)trans.supportsConvert(14, 0));
    }

    @Test
    public void testPadFunctions() throws TranslatorException {
        String input = "SELECT lpad(PART_NAME,2), lpad(part_name,2,'x'), rpad(PART_NAME,2), rpad(part_name,2,'x') FROM PARTS";
        String output = "SELECT RIGHT(REPLICATE(' ', 2) + LEFT(PARTS.PART_NAME, 2), 2), RIGHT(REPLICATE('x', 2) + LEFT(PARTS.PART_NAME, 2), 2), LEFT(PARTS.PART_NAME + REPLICATE(' ', 2), 2), LEFT(PARTS.PART_NAME + REPLICATE('x', 2), 2) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }
}

