/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.ExtractFunctionModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class TestExtractFunctionModifier
extends TestCase {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public TestExtractFunctionModifier(String name) {
        super(name);
    }

    public void helpTestMod(Expression c, String expectedStr, String target) throws Exception {
        Function func = LANG_FACTORY.createFunction(target, Arrays.asList(c), Integer.class);
        ExtractFunctionModifier mod = new ExtractFunctionModifier();
        JDBCExecutionFactory trans = new JDBCExecutionFactory();
        trans.registerFunctionModifier(target, (FunctionModifier)mod);
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        TestExtractFunctionModifier.assertEquals((String)expectedStr, (String)sqlVisitor.toString());
    }

    public void test1() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)104, (int)0, (int)21), Date.class);
        this.helpTestMod((Expression)arg1, "EXTRACT(MONTH FROM {d '2004-01-21'})", "month");
    }

    public void test2() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)104, (int)0, (int)21, (int)17, (int)5, (int)0, (int)0), Timestamp.class);
        this.helpTestMod((Expression)arg1, "EXTRACT(MONTH FROM {ts '2004-01-21 17:05:00.0'})", "month");
    }

    public void test3() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)104, (int)0, (int)21), Date.class);
        this.helpTestMod((Expression)arg1, "EXTRACT(YEAR FROM {d '2004-01-21'})", "year");
    }

    public void test4() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)104, (int)0, (int)21, (int)17, (int)5, (int)0, (int)0), Timestamp.class);
        this.helpTestMod((Expression)arg1, "EXTRACT(YEAR FROM {ts '2004-01-21 17:05:00.0'})", "year");
    }

    public void test5() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)104, (int)0, (int)21), Date.class);
        this.helpTestMod((Expression)arg1, "EXTRACT(DAY FROM {d '2004-01-21'})", "dayofmonth");
    }

    public void test6() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)104, (int)0, (int)21, (int)17, (int)5, (int)0, (int)0), Timestamp.class);
        this.helpTestMod((Expression)arg1, "EXTRACT(DAY FROM {ts '2004-01-21 17:05:00.0'})", "dayofmonth");
    }

    public void test11() throws Exception {
        NamedTable group = LANG_FACTORY.createNamedTable("group", null, null);
        ColumnReference elem = LANG_FACTORY.createColumnReference("col", group, null, TypeFacility.RUNTIME_TYPES.DATE);
        this.helpTestMod((Expression)elem, "EXTRACT(DAY FROM group.col)", "dayofmonth");
    }

    public void test12() throws Exception {
        NamedTable group = LANG_FACTORY.createNamedTable("group", null, null);
        ColumnReference elem = LANG_FACTORY.createColumnReference("col", group, null, TypeFacility.RUNTIME_TYPES.DATE);
        this.helpTestMod((Expression)elem, "(EXTRACT(DOW FROM group.col) + 1)", "dayofweek");
    }
}

