/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.language.Command;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCProcedureExecution;
import org.teiid.translator.jdbc.TranslationHelper;

public class TestJDBCProcedureExecution {
    @Test
    public void testProcedureExecution() throws Exception {
        Command command = TranslationHelper.helpTranslate("/bqt.vdb", "exec pm2.spTest8a()");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CallableStatement cs = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.stub((Object)cs.getUpdateCount()).toReturn((Object)-1);
        Mockito.stub((Object)cs.getInt(1)).toReturn((Object)5);
        Mockito.stub((Object)connection.prepareCall("{call spTest8a(?)}")).toReturn((Object)cs);
        JDBCExecutionFactory ef = new JDBCExecutionFactory();
        JDBCProcedureExecution procedureExecution = new JDBCProcedureExecution(command, connection, (ExecutionContext)Mockito.mock(ExecutionContext.class), ef);
        procedureExecution.execute();
        Assert.assertEquals(Arrays.asList(5), (Object)procedureExecution.getOutputParameterValues());
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 4);
    }

    @Test
    public void testProcedureExecution1() throws Exception {
        Command command = TranslationHelper.helpTranslate("/bqt.vdb", "exec pm2.spTest8(1)");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CallableStatement cs = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.stub((Object)cs.getUpdateCount()).toReturn((Object)-1);
        Mockito.stub((Object)cs.getInt(2)).toReturn((Object)5);
        Mockito.stub((Object)connection.prepareCall("{call spTest8(?,?)}")).toReturn((Object)cs);
        JDBCExecutionFactory config = new JDBCExecutionFactory();
        JDBCProcedureExecution procedureExecution = new JDBCProcedureExecution(command, connection, (ExecutionContext)Mockito.mock(ExecutionContext.class), config);
        procedureExecution.execute();
        Assert.assertEquals(Arrays.asList(5), (Object)procedureExecution.getOutputParameterValues());
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.times((int)1))).registerOutParameter(2, 4);
    }
}

