/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;

public class ConvertModifier
extends FunctionModifier {
    private Map<Integer, String> typeMapping = new HashMap<Integer, String>();
    private Map<Integer, FunctionModifier> typeModifier = new HashMap<Integer, FunctionModifier>();
    private Map<Integer, FunctionModifier> sourceModifier = new HashMap<Integer, FunctionModifier>();
    private Map<List<Integer>, FunctionModifier> specificConverts = new HashMap<List<Integer>, FunctionModifier>();
    private boolean booleanNumeric;
    private boolean wideningNumericImplicit;
    private boolean booleanNullable = true;

    public void addTypeConversion(FunctionModifier convert, int ... targetType) {
        for (int i : targetType) {
            this.typeModifier.put(i, convert);
        }
    }

    public void addSourceConversion(FunctionModifier convert, int ... sourceType) {
        for (int i : sourceType) {
            this.sourceModifier.put(i, convert);
        }
    }

    public void addTypeMapping(String nativeType, int ... targetType) {
        for (int i : targetType) {
            this.typeMapping.put(i, nativeType);
        }
    }

    public void setWideningNumericImplicit(boolean wideningNumericImplicit) {
        this.wideningNumericImplicit = wideningNumericImplicit;
    }

    public void addConvert(int sourceType, int targetType, FunctionModifier convert) {
        this.specificConverts.put(Arrays.asList(sourceType, targetType), convert);
    }

    @Override
    public List<?> translate(Function function) {
        boolean implicit;
        function.setName("cast");
        int targetCode = ConvertModifier.getCode(function.getType());
        List args = function.getParameters();
        Class srcType = ((Expression)args.get(0)).getType();
        int sourceCode = ConvertModifier.getCode(srcType);
        List<Integer> convesionCode = Arrays.asList(sourceCode, targetCode);
        FunctionModifier convert = this.specificConverts.get(convesionCode);
        if (convert != null) {
            return convert.translate(function);
        }
        boolean bl = implicit = sourceCode == 1 && targetCode == 0;
        if (targetCode >= 3 && targetCode <= 10) {
            if (this.booleanNumeric && sourceCode == 2) {
                sourceCode = 3;
                implicit = targetCode == 3;
            }
            implicit |= this.wideningNumericImplicit && sourceCode >= 3 && sourceCode <= 10 && sourceCode < targetCode;
        }
        if (!implicit) {
            convert = this.sourceModifier.get(sourceCode);
            if (!(convert == null || convert.equals(this.sourceModifier.get(targetCode)) && sourceCode != targetCode)) {
                return convert.translate(function);
            }
            convert = this.typeModifier.get(targetCode);
            if (!(convert == null || convert.equals(this.typeModifier.get(sourceCode)) && sourceCode != targetCode)) {
                return convert.translate(function);
            }
            String type = this.typeMapping.get(targetCode);
            if (!(type == null || type.equals(this.typeMapping.get(sourceCode)) && sourceCode != targetCode)) {
                ((Literal)function.getParameters().get(1)).setValue((Object)type);
                return null;
            }
        }
        return Arrays.asList((Expression)function.getParameters().get(0));
    }

    public static Function createConvertFunction(LanguageFactory langFactory, Expression expr, String typeName) {
        Class type = TypeFacility.getDataTypeClass((String)typeName);
        return langFactory.createFunction("convert", new Expression[]{expr, langFactory.createLiteral((Object)typeName, type)}, type);
    }

    public void addNumericBooleanConversions() {
        this.booleanNumeric = true;
        this.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression stringValue = (Expression)function.getParameters().get(0);
                return Arrays.asList("CASE WHEN ", stringValue, " = 0 THEN 0 WHEN ", stringValue, " IS NOT NULL THEN 1 END");
            }
        }, 2);
        this.addConvert(2, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression booleanValue = (Expression)function.getParameters().get(0);
                if (!ConvertModifier.this.booleanNullable) {
                    return Arrays.asList("CASE WHEN ", booleanValue, " = 0 THEN 'false' ELSE 'true' END");
                }
                return Arrays.asList("CASE WHEN ", booleanValue, " = 0 THEN 'false' WHEN ", booleanValue, " IS NOT NULL THEN 'true' END");
            }
        });
        this.addConvert(0, 2, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression stringValue = (Expression)function.getParameters().get(0);
                return Arrays.asList("CASE WHEN ", stringValue, " IN ('false', '0') THEN 0 WHEN ", stringValue, " IS NOT NULL THEN 1 END");
            }
        });
    }

    public void setBooleanNullable(boolean booleanNullable) {
        this.booleanNullable = booleanNullable;
    }

    public boolean hasTypeMapping(int type) {
        return this.typeMapping.containsKey(type) || this.typeModifier.containsKey(type);
    }

    public static class FormatModifier
    extends AliasModifier {
        private String format;

        public FormatModifier(String alias) {
            super(alias);
        }

        public FormatModifier(String alias, String format) {
            super(alias);
            this.format = format;
        }

        @Override
        public List<?> translate(Function function) {
            this.modify(function);
            if (this.format == null) {
                function.getParameters().remove(1);
            } else {
                ((Literal)function.getParameters().get(1)).setValue((Object)this.format);
            }
            return null;
        }
    }
}

