/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.InsertValueSource;
import org.teiid.language.LanguageUtil;
import org.teiid.language.NamedTable;
import org.teiid.language.Parameter;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.LanguageObjectVisitor;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCBaseExecution;
import org.teiid.translator.jdbc.JDBCExecutionException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.TranslatedCommand;

public class JDBCQueryExecution
extends JDBCBaseExecution
implements ResultSetExecution {
    private static final String KEY_TABLE_PREFIX = "TEIID_DKJ";
    private static final String FULL_TABLE_PREFIX = "TEIID_DJ";
    private static final String COL_PREFIX = "COL";
    protected ResultSet results;
    protected Class<?>[] columnDataTypes;
    protected List<NamedTable> tempTables;

    public JDBCQueryExecution(Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory env) {
        super(command, connection, context, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws TranslatorException {
        QueryExpression qe = (QueryExpression)this.command;
        this.columnDataTypes = qe.getColumnTypes();
        TranslatedCommand translatedComm = null;
        boolean usingTxn = false;
        boolean success = false;
        try {
            Select select;
            if (this.command instanceof Select && (select = (Select)this.command).getDependentValues() != null) {
                usingTxn = this.createTempTables(select);
            }
            if (qe.getWith() != null) {
                usingTxn = this.createFullTempTables(qe, usingTxn);
            }
            translatedComm = this.translateCommand(this.command);
            String sql = translatedComm.getSql();
            if (!translatedComm.isPrepared()) {
                this.results = this.getStatement().executeQuery(sql);
            } else {
                PreparedStatement pstatement = this.getPreparedStatement(sql);
                this.bind(pstatement, translatedComm.getPreparedValues(), null);
                this.results = pstatement.executeQuery();
            }
            this.addStatementWarnings();
            success = true;
        }
        catch (SQLException e) {
            if (translatedComm == null) {
                throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11008, e, this.command.toString());
            }
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11008, e, translatedComm);
        }
        finally {
            if (usingTxn) {
                try {
                    try {
                        if (success) {
                            this.connection.commit();
                        } else {
                            this.connection.rollback();
                        }
                    }
                    finally {
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected boolean createFullTempTables(QueryExpression qe, boolean usingTxn) throws SQLException, TranslatorException {
        With with = qe.getWith();
        int t = 1;
        HashMap<String, String> nameMap = null;
        Iterator iter = with.getItems().iterator();
        while (iter.hasNext()) {
            WithItem item = (WithItem)iter.next();
            if (item.getDependentValues() == null) continue;
            List cols = item.getColumns();
            if (!usingTxn && this.executionFactory.tempTableRequiresTransaction() && this.connection.getAutoCommit()) {
                usingTxn = true;
                this.connection.setAutoCommit(false);
            }
            String tableName = this.executionFactory.createTempTable(FULL_TABLE_PREFIX + t++, cols, this.context, this.getConnection());
            if (nameMap == null) {
                nameMap = new HashMap<String, String>();
            }
            nameMap.put(item.getTable().getName(), tableName);
            NamedTable table = new NamedTable(tableName, null, null);
            if (this.tempTables == null) {
                this.tempTables = new ArrayList<NamedTable>();
            }
            this.tempTables.add(table);
            iter.remove();
            ArrayList<Expression> params = new ArrayList<Expression>(item.getColumns().size());
            for (int i = 0; i < cols.size(); ++i) {
                Parameter parameter = new Parameter();
                parameter.setType(((ColumnReference)cols.get(i)).getType());
                parameter.setValueIndex(i);
                params.add((Expression)parameter);
            }
            this.loadTempTable(cols, params, tableName, table, item.getDependentValues());
        }
        if (nameMap != null) {
            RenamingVisitor hv = new RenamingVisitor(nameMap);
            qe.acceptVisitor((LanguageObjectVisitor)hv);
            if (qe.getWith().getItems().isEmpty()) {
                qe.setWith(null);
            }
        }
        return usingTxn;
    }

    protected boolean createTempTables(Select select) throws SQLException, TranslatorException {
        boolean result = false;
        if (this.executionFactory.tempTableRequiresTransaction() && this.connection.getAutoCommit()) {
            result = true;
            this.connection.setAutoCommit(false);
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"creating temporary tables for key set dependent join processing");
        this.tempTables = new ArrayList<NamedTable>();
        Condition c = select.getWhere();
        List conditions = LanguageUtil.separateCriteriaByAnd((Condition)c);
        HashMap<String, ArrayList<Comparison>> tables = new HashMap<String, ArrayList<Comparison>>();
        Iterator iter = conditions.iterator();
        while (iter.hasNext()) {
            Array array;
            Comparison comp;
            Condition condition = (Condition)iter.next();
            if (!(condition instanceof Comparison) || (comp = (Comparison)condition).getOperator() != Comparison.Operator.EQ) continue;
            Parameter p = null;
            if (comp.getRightExpression() instanceof Parameter) {
                iter.remove();
                p = (Parameter)comp.getRightExpression();
            } else if (comp.getRightExpression() instanceof Array && (array = (Array)comp.getRightExpression()).getExpressions().get(0) instanceof Parameter) {
                iter.remove();
                p = (Parameter)array.getExpressions().get(0);
            }
            if (p == null) continue;
            ArrayList<Comparison> compares = (ArrayList<Comparison>)tables.get(p.getDependentValueId());
            if (compares == null) {
                compares = new ArrayList<Comparison>();
                tables.put(p.getDependentValueId(), compares);
            }
            compares.add(comp);
        }
        int t = 1;
        for (Map.Entry entry : tables.entrySet()) {
            ArrayList<ColumnReference> cols = new ArrayList<ColumnReference>();
            ArrayList<Expression> params = new ArrayList<Expression>();
            for (Comparison comp : (List)entry.getValue()) {
                Expression ex = comp.getLeftExpression();
                if (ex instanceof Array) {
                    Array array = (Array)ex;
                    params.addAll(((Array)comp.getRightExpression()).getExpressions());
                    for (Expression expr : array.getExpressions()) {
                        cols.add(this.createTempColumn(cols.size() + 1, expr));
                    }
                    continue;
                }
                params.add(comp.getRightExpression());
                cols.add(this.createTempColumn(cols.size() + 1, ex));
            }
            String tableName = this.executionFactory.createTempTable(KEY_TABLE_PREFIX + t++, cols, this.context, this.getConnection());
            NamedTable table = new NamedTable(tableName, null, null);
            this.tempTables.add(table);
            select.getFrom().add(0, table);
            int i = 1;
            for (Comparison comp : (List)entry.getValue()) {
                Expression ex = comp.getLeftExpression();
                if (ex instanceof Array) {
                    Array array = (Array)ex;
                    for (Expression expr : array.getExpressions()) {
                        conditions.add(new Comparison(expr, (Expression)new ColumnReference(table, COL_PREFIX + i++, null, expr.getType()), Comparison.Operator.EQ));
                    }
                    continue;
                }
                conditions.add(new Comparison(ex, (Expression)new ColumnReference(table, COL_PREFIX + i++, null, ex.getType()), Comparison.Operator.EQ));
            }
            List list = (List)select.getDependentValues().get(entry.getKey());
            this.loadTempTable(cols, params, tableName, table, list);
        }
        select.setDependentValues(null);
        select.setWhere(LanguageUtil.combineCriteria((List)conditions));
        return result;
    }

    private void loadTempTable(List<ColumnReference> cols, List<Expression> params, String tableName, NamedTable table, List<? extends List<?>> vals) throws TranslatorException, SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"loading temporary table", tableName, "with", vals.size(), "rows"});
        ExpressionValueSource evs = new ExpressionValueSource(params);
        for (ColumnReference col : cols) {
            col.setMetadataObject(null);
        }
        Insert insert = new Insert(table, cols, (InsertValueSource)evs);
        insert.setParameterValues(vals.iterator());
        JDBCUpdateExecution ex = this.executionFactory.createUpdateExecution((Command)insert, this.context, this.context.getRuntimeMetadata(), this.getConnection());
        int size = this.executionFactory.getMaxDependentInPredicates() * this.executionFactory.getMaxInCriteriaSize() / cols.size();
        ex.setMaxPreparedInsertBatchSize(Math.max(size, this.executionFactory.getMaxPreparedInsertBatchSize()));
        ex.setAtomic(false);
        ex.execute();
        ex.statement.close();
        this.executionFactory.loadedTemporaryTable(tableName, this.context, this.connection);
    }

    private ColumnReference createTempColumn(int i, Expression ex) {
        if (ex instanceof ColumnReference) {
            ColumnReference left = (ColumnReference)ex;
            return new ColumnReference(null, COL_PREFIX + i, left.getMetadataObject(), ex.getType());
        }
        return new ColumnReference(null, COL_PREFIX + i, null, ex.getType());
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        try {
            if (this.results.next()) {
                ArrayList<Object> vals = new ArrayList<Object>(this.columnDataTypes.length);
                for (int i = 0; i < this.columnDataTypes.length; ++i) {
                    Object value = this.executionFactory.retrieveValue(this.results, i + 1, this.columnDataTypes[i]);
                    vals.add(value);
                }
                return vals;
            }
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e, JDBCPlugin.Util.getString("JDBCTranslator.Unexpected_exception_translating_results___8", new Object[]{e.getMessage()}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        block35: {
            Statement s;
            try {
                if (this.results != null) {
                    try {
                        this.results.close();
                        this.results = null;
                    }
                    catch (SQLException e) {
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Exception closing");
                    }
                }
                if (this.tempTables == null) break block35;
                s = null;
            }
            catch (Throwable throwable) {
                if (this.tempTables != null) {
                    Statement s2 = null;
                    try {
                        s2 = this.getConnection().createStatement();
                        for (NamedTable temp : this.tempTables) {
                            try {
                                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"dropping temporary table", (Object)temp.getName());
                                s2.execute(this.executionFactory.getDialect().getDefaultMultiTableBulkIdStrategy().getIdTableSupport().getDropIdTableCommand() + " " + temp.getName());
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        this.tempTables = null;
                        if (s2 != null) {
                            try {
                                s2.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                super.close();
                throw throwable;
            }
            try {
                s = this.getConnection().createStatement();
                for (NamedTable temp : this.tempTables) {
                    try {
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"dropping temporary table", (Object)temp.getName());
                        s.execute(this.executionFactory.getDialect().getDefaultMultiTableBulkIdStrategy().getIdTableSupport().getDropIdTableCommand() + " " + temp.getName());
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.tempTables = null;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        super.close();
    }

    private static final class RenamingVisitor
    extends HierarchyVisitor {
        private Map<String, String> nameMap;

        private RenamingVisitor(Map<String, String> nameMap) {
            super(true);
            this.nameMap = nameMap;
        }

        public void visit(NamedTable obj) {
            if (obj.getMetadataObject() != null) {
                return;
            }
            String name = obj.getName();
            String val = this.nameMap.get(name);
            if (val != null) {
                obj.setName(val);
            }
            if (obj.getCorrelationName() == null) {
                obj.setCorrelationName(name);
            }
        }
    }
}

