/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.exasol;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Function;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.oracle.ConcatFunctionModifier;

@Translator(name="exasol", description="Translator for EXASOL database")
public class ExasolExecutionFactory
extends JDBCExecutionFactory {
    public static final String EXASOL = "exasol";
    public static final String TIME_FORMAT = "HH24:MI:SS";
    public static final String DATE_FORMAT = "YYYY-MM-DD";
    public static final String DATETIME_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    public static final String TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF1";
    public static final String LN = "LN";
    public static final String BIT_AND = "BIT_AND";
    public static final String BIT_NOT = "BIT_NOT";
    public static final String BIT_OR = "BIT_OR";
    public static final String BIT_XOR = "BIT_XOR";
    public static final String BIT_LENGTH = "BIT_LENGTH";
    public static final String CHARACTER_LENGTH = "CHARACTER_LENGTH";
    public static final String CHR = "CHR";
    public static final String COLOGNE_PHONETIC = "COLOGNE_PHONETIC";
    public static final String EDIT_DISTANCE = "EDIT_DISTANCE";
    public static final String INSTR = "INSTR";
    public static final String LOWER = "LOWER";
    public static final String LTRIM = "LTRIM";
    public static final String MID = "MID";
    public static final String OCTET_LENGTH = "OCTET_LENGTH";
    public static final String REGEXP_INSTR = "REGEXP_INSTR";
    public static final String REGEXP_REPLACE = "REGEXP_REPLACE";
    public static final String REGEXP_SUBSTR = "REGEXP_SUBSTR";
    public static final String REPLACE = "REPLACE";
    public static final String REVERSE = "REVERSE";
    public static final String RTRIM = "RTRIM";
    public static final String SOUNDEX = "SOUNDEX";
    public static final String SPACE = "SPACE";
    public static final String TO_NUMBER = "TO_NUMBER";
    public static final String UNICODE = "UNICODE";
    public static final String UNICODECHR = "UNICODECHR";
    public static final String UPPER = "UPPER";
    public static final String ADD_DAYS = "ADD_DAYS";
    public static final String ADD_HOURS = "ADD_HOURS";
    public static final String ADD_MINUTES = "ADD_MINUTES";
    public static final String ADD_MONTHS = "ADD_MONTHS";
    public static final String ADD_SECONDS = "ADD_SECONDS";
    public static final String ADD_WEEKS = "ADD_WEEKS";
    public static final String ADD_YEARS = "ADD_YEARS";
    public static final String DATE_TRUNC = "DATE_TRUNC";
    public static final String DAY = "DAY";
    public static final String DAYS_BETWEEN = "DAYS_BETWEEN";
    public static final String FROM_POSIX_TIME = "FROM_POSIX_TIME";
    public static final String HOURS_BETWEEN = "HOURS_BETWEEN";
    public static final String MINUTES_BETWEEN = "MINUTES_BETWEEN";
    public static final String MONTHS_BETWEEN = "MONTHS_BETWEEN";
    public static final String POSIX_TIME = "POSIX_TIME";
    public static final String ROUND = "ROUND";
    public static final String SECONDS_BETWEEN = "SECONDS_BETWEEN";
    public static final String TO_CHAR = "TO_CHAR";
    public static final String TO_TIMESTAMP = "TO_TIMESTAMP";
    public static final String TRUNC = "TRUNC";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String YEARS_BETWEEN = "YEARS_BETWEEN";

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.addPushDownFunction(EXASOL, "-", "boolean", new String[]{"boolean", "float"});
        this.addPushDownFunction(EXASOL, "-", "boolean", new String[]{"boolean", "double"});
        this.addPushDownFunction(EXASOL, "-", "boolean", new String[]{"boolean", "float"});
        this.registerFunctionModifier("log", new AliasModifier(LN));
        this.registerFunctionModifier("bitand", new AliasModifier(BIT_AND));
        this.registerFunctionModifier("bitnot", new AliasModifier(BIT_NOT));
        this.registerFunctionModifier("bitor", new AliasModifier(BIT_OR));
        this.registerFunctionModifier("bitxor", new AliasModifier(BIT_XOR));
        this.addPushDownFunction(EXASOL, BIT_LENGTH, "integer", new String[]{"string"});
        this.addPushDownFunction(EXASOL, COLOGNE_PHONETIC, "string", new String[]{"string"});
        this.addPushDownFunction(EXASOL, EDIT_DISTANCE, "integer", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, INSTR, "integer", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, INSTR, "integer", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(EXASOL, INSTR, "integer", new String[]{"string", "string", "integer", "integer"});
        this.addPushDownFunction(EXASOL, LTRIM, "string", new String[]{"string"});
        this.addPushDownFunction(EXASOL, LTRIM, "string", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, MID, "string", new String[]{"string", "integer"});
        this.addPushDownFunction(EXASOL, MID, "string", new String[]{"string", "integer", "integer"});
        this.addPushDownFunction(EXASOL, OCTET_LENGTH, "integer", new String[]{"string"});
        this.addPushDownFunction(EXASOL, REGEXP_INSTR, "integer", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, REGEXP_INSTR, "integer", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(EXASOL, REGEXP_INSTR, "integer", new String[]{"string", "string", "integer", "integer"});
        this.addPushDownFunction(EXASOL, REGEXP_REPLACE, "string", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, REGEXP_REPLACE, "string", new String[]{"string", "string", "string"});
        this.addPushDownFunction(EXASOL, REGEXP_REPLACE, "string", new String[]{"string", "string", "string", "integer"});
        this.addPushDownFunction(EXASOL, REGEXP_REPLACE, "string", new String[]{"string", "string", "string", "integer", "integer"});
        this.addPushDownFunction(EXASOL, REGEXP_SUBSTR, "string", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, REGEXP_SUBSTR, "string", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(EXASOL, REGEXP_SUBSTR, "string", new String[]{"string", "string", "integer", "integer"});
        this.addPushDownFunction(EXASOL, REPLACE, "string", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, REPLACE, "string", new String[]{"string", "string", "string"});
        this.addPushDownFunction(EXASOL, REVERSE, "string", new String[]{"string"});
        this.addPushDownFunction(EXASOL, RTRIM, "string", new String[]{"string"});
        this.addPushDownFunction(EXASOL, RTRIM, "string", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, SOUNDEX, "string", new String[]{"string"});
        this.addPushDownFunction(EXASOL, SPACE, "string", new String[]{"integer"});
        this.addPushDownFunction(EXASOL, TO_NUMBER, "double", new String[]{"string"});
        this.addPushDownFunction(EXASOL, TO_NUMBER, "double", new String[]{"string", "string"});
        this.addPushDownFunction(EXASOL, UNICODE, "integer", new String[]{"char"});
        this.addPushDownFunction(EXASOL, UNICODECHR, "char", new String[]{"integer"});
        this.registerFunctionModifier("ucase", new AliasModifier(UPPER));
        this.registerFunctionModifier("concat", new ConcatFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("length", new AliasModifier(CHARACTER_LENGTH));
        this.registerFunctionModifier("lcase", new AliasModifier(LOWER));
        this.addPushDownFunction(EXASOL, ADD_DAYS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(EXASOL, ADD_DAYS, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(EXASOL, ADD_HOURS, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(EXASOL, ADD_MINUTES, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(EXASOL, ADD_MONTHS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(EXASOL, ADD_MONTHS, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(EXASOL, ADD_SECONDS, "timestamp", new String[]{"timestamp", "double"});
        this.addPushDownFunction(EXASOL, ADD_WEEKS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(EXASOL, ADD_WEEKS, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(EXASOL, ADD_YEARS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(EXASOL, ADD_YEARS, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(EXASOL, DATE_TRUNC, "date", new String[]{"string", "date"});
        this.addPushDownFunction(EXASOL, DATE_TRUNC, "timestamp", new String[]{"string", "timestamp"});
        this.addPushDownFunction(EXASOL, DAYS_BETWEEN, "integer", new String[]{"date", "date"});
        this.addPushDownFunction(EXASOL, DAYS_BETWEEN, "integer", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(EXASOL, HOURS_BETWEEN, "double", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(EXASOL, MINUTES_BETWEEN, "double", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(EXASOL, MONTHS_BETWEEN, "double", new String[]{"date", "date"});
        this.addPushDownFunction(EXASOL, MONTHS_BETWEEN, "double", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(EXASOL, POSIX_TIME, "double", new String[]{"timestamp"});
        this.addPushDownFunction(EXASOL, ROUND, "date", new String[]{"date"});
        this.addPushDownFunction(EXASOL, ROUND, "date", new String[]{"date", "string"});
        this.addPushDownFunction(EXASOL, ROUND, "timestamp", new String[]{"timestamp"});
        this.addPushDownFunction(EXASOL, ROUND, "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(EXASOL, SECONDS_BETWEEN, "double", new String[]{"timestamp", "timestamp"});
        this.addPushDownFunction(EXASOL, TRUNC, "date", new String[]{"date"});
        this.addPushDownFunction(EXASOL, TRUNC, "date", new String[]{"date", "string"});
        this.addPushDownFunction(EXASOL, TRUNC, "timestamp", new String[]{"timestamp"});
        this.addPushDownFunction(EXASOL, TRUNC, "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(EXASOL, TRUNCATE, "date", new String[]{"date"});
        this.addPushDownFunction(EXASOL, TRUNCATE, "date", new String[]{"date", "string"});
        this.addPushDownFunction(EXASOL, TRUNCATE, "timestamp", new String[]{"timestamp"});
        this.addPushDownFunction(EXASOL, TRUNCATE, "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(EXASOL, YEARS_BETWEEN, "double", new String[]{"date", "date"});
        this.addPushDownFunction(EXASOL, YEARS_BETWEEN, "double", new String[]{"timestamp", "timestamp"});
        this.registerFunctionModifier("from_unixtime", new AliasModifier(FROM_POSIX_TIME));
        this.registerFunctionModifier("dayofmonth", new AliasModifier(DAY));
        this.registerFunctionModifier("formattimestamp", new AliasModifier(TO_CHAR));
        this.registerFunctionModifier("parsetimestamp", new AliasModifier(TO_TIMESTAMP));
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("VARCHAR(4000)", 0);
        convertModifier.addTypeMapping("DECIMAL(3)", 3);
        convertModifier.addTypeMapping("DECIMAL(5)", 4);
        convertModifier.addTypeMapping("DECIMAL(18)", 5);
        convertModifier.addTypeMapping("DECIMAL(18)", 6);
        convertModifier.addTypeMapping("DOUBLE PRECISION", 8);
        convertModifier.addTypeMapping("DOUBLE PRECISION", 9);
        convertModifier.addTypeMapping("DECIMAL(36)", 7);
        convertModifier.addTypeMapping("DECIMAL(36,18)", 10);
        convertModifier.addConvert(11, 0, new ConvertModifier.FormatModifier("to_char", DATE_FORMAT));
        convertModifier.addConvert(13, 0, new ConvertModifier.FormatModifier("to_char", TIMESTAMP_FORMAT));
        convertModifier.addNumericBooleanConversions();
        convertModifier.addConvert(2, 9, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(", function.getParameters().get(0), " as double precision)");
            }
        });
        convertModifier.addConvert(2, 3, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(", function.getParameters().get(0), " as decimal(3))");
            }
        });
        this.registerFunctionModifier("convert", convertModifier);
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("length");
        supportedFunctions.add("char");
        supportedFunctions.add("insert");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("translate");
        supportedFunctions.add("ucase");
        supportedFunctions.add("curdate");
        supportedFunctions.add("from_unixtime");
        supportedFunctions.add("month");
        supportedFunctions.add("now");
        supportedFunctions.add("parsetimestamp");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("convert");
        return supportedFunctions;
    }

    @Override
    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        if (expectedType == TypeFacility.RUNTIME_TYPES.CLOB) {
            expectedType = TypeFacility.RUNTIME_TYPES.STRING;
        }
        return super.retrieveValue(results, parameterIndex, expectedType);
    }

    @Override
    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        if (expectedType == TypeFacility.RUNTIME_TYPES.CLOB) {
            expectedType = TypeFacility.RUNTIME_TYPES.STRING;
        }
        return super.retrieveValue(results, columnIndex, expectedType);
    }

    public boolean supportsConvert(int fromType, int toType) {
        return fromType != 3 && fromType != 14 && fromType != 19 && fromType != 12 && fromType != 15 && fromType != 17 && toType != 3 && toType != 14 && toType != 19 && toType != 12 && toType != 15 && toType != 17;
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.HIGH;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    @Override
    public boolean supportsSearchedCaseExpressions() {
        return false;
    }

    @Override
    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    @Override
    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    public boolean supportsGroupByRollup() {
        return true;
    }

    public boolean supportsArrayType() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return true;
    }

    @Override
    public boolean supportsBatchedUpdates() {
        return false;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    @Override
    public boolean supportsExistsCriteria() {
        return true;
    }

    @Override
    public boolean supportsInCriteriaSubquery() {
        return true;
    }

    @Override
    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }
}

