/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;

public class TestMetadataProcessor {
    @Test
    public void testInvalidIndex() throws SQLException {
        JDBCMetadataProcessor processor = new JDBCMetadataProcessor();
        processor.setImportIndexes(true);
        processor.setWidenUnsingedTypes(false);
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "x", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        DatabaseMetaData dmd = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Table t = mf.addTable("c");
        JDBCMetadataProcessor.TableInfo ti = new JDBCMetadataProcessor.TableInfo("a", "b", "c", t);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)rs.next()).toAnswer((Answer)new Answer<Boolean>(){
            int count = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                if (this.count++ == 0) {
                    return true;
                }
                return false;
            }
        });
        Mockito.stub((Object)rs.getShort(7)).toReturn((Object)3);
        Mockito.stub((Object)dmd.getIndexInfo("a", "b", "c", false, true)).toReturn((Object)rs);
        processor.getIndexes(mf, dmd, Arrays.asList(ti), false);
        ((ResultSet)Mockito.verify((Object)rs)).getString(9);
        Assert.assertTrue((boolean)t.getIndexes().isEmpty());
    }

    @Test
    public void testQuoteStringNull() {
        JDBCMetadataProcessor jmp = new JDBCMetadataProcessor();
        Assert.assertEquals((Object)"x", (Object)jmp.quoteName("x"));
    }

    @Test
    public void testArrayRuntimeType() {
        JDBCMetadataProcessor jmp = new JDBCMetadataProcessor(){

            protected String getNativeComponentType(String typeName) {
                return typeName.substring(0, typeName.length() - 2);
            }
        };
        jmp.typeMapping.put("varchar", 12);
        Assert.assertEquals((Object)"string[]", (Object)jmp.getRuntimeType(2003, "varchar[]", 100, 0));
    }
}

