/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.mysql;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.mysql.MySQL5ExecutionFactory;

public class TestMySQL5Translator {
    private static MySQL5ExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void oneTimeSetup() throws TranslatorException {
        TRANSLATOR = new MySQL5ExecutionFactory();
        TRANSLATOR.start();
    }

    @Test
    public void testChar() throws Exception {
        String input = "SELECT intkey, CHR(CONVERT(bigintegervalue, integer)) FROM BQT1.MediumA";
        String output = "SELECT MediumA.IntKey, char(cast(MediumA.BigIntegerValue AS signed) USING ASCII) FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampFunctions() throws Exception {
        String input = "SELECT mysql.timestampdiff('SQL_TSI_FRAC_SECOND', timestampvalue, {d '1970-01-01'}), mysql.timestampdiff('SQL_TSI_HOUR', timestampvalue, {d '1970-01-01'}), timestampadd(SQL_TSI_FRAC_SECOND, 2000, MediumA.TimestampValue) FROM BQT1.MediumA";
        String output = "SELECT timestampdiff(MICROSECOND, MediumA.TimestampValue, {ts '1970-01-01 00:00:00.0'}) * 1000, timestampdiff(SQL_TSI_HOUR, MediumA.TimestampValue, {ts '1970-01-01 00:00:00.0'}), timestampadd(MICROSECOND, (2000 / 1000), MediumA.TimestampValue) FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"create temporary table if not exists foo (COL1 integer, COL2 varchar(100)) ", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)TRANSLATOR, true));
    }

    @Test
    public void testRollup() throws Exception {
        String input = "select intkey, max(stringkey) from bqt1.smalla group by rollup(intkey)";
        String output = "SELECT SmallA.IntKey, MAX(SmallA.StringKey) FROM SmallA GROUP BY SmallA.IntKey WITH ROLLUP";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testGeometryPushdown() throws Exception {
        String input = "select mkt_id from cola_markets where ST_Contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), shape);";
        String output = "SELECT COLA_MARKETS.MKT_ID FROM COLA_MARKETS WHERE st_contains(GeomFromWKB(?, 0), COLA_MARKETS.SHAPE) = 1";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testGeometryPushdownSrid() throws Exception {
        String input = "select mkt_id from cola_markets where ST_Contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))', 8307), shape);";
        String output = "SELECT COLA_MARKETS.MKT_ID FROM COLA_MARKETS WHERE st_contains(GeomFromWKB(?, 8307), COLA_MARKETS.SHAPE) = 1";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTinyintBoolean() throws Exception {
        String input = "select boolcol from x where boolcol = false";
        String output = "SELECT case when x.boolcol is null then null when x.boolcol = -1 or x.boolcol > 0 then 1 else 0 end FROM x WHERE case when x.boolcol is null then null when x.boolcol = -1 or x.boolcol > 0 then 1 else 0 end = 0";
        String ddl = "create foreign table x (boolcol boolean options (native_type 'tinyint(1)'))";
        TranslationHelper.helpTestVisitor(ddl, input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampLiteral() throws Exception {
        String input = "SELECT {ts '1970-01-01 00:00:00.123456789'}";
        String output = "SELECT {ts '1970-01-01 00:00:00.123456789'}";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

