/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sybase;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.language.Command;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslatedCommand;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.sybase.SybaseExecutionFactory;
import org.teiid.util.Version;

public class TestSybaseSQLConversionVisitor {
    private static SybaseExecutionFactory trans = new SybaseExecutionFactory();

    @BeforeClass
    public static void setup() throws TranslatorException {
        trans.setUseBindVariables(false);
        trans.setDatabaseVersion(Version.DEFAULT_VERSION);
        trans.start();
    }

    public String getTestVDB() {
        return "/PartsSupplier.vdb";
    }

    public String getBQTVDB() {
        return "/bqt.vdb";
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) {
        Command obj = TranslationHelper.helpTranslate(vdb, input);
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)Mockito.mock(ExecutionContext.class), (JDBCExecutionFactory)trans);
        try {
            tc.translateCommand(obj);
        }
        catch (TranslatorException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)"Did not get correct sql", (Object)expectedOutput, (Object)tc.getSql());
    }

    @Test
    public void testModFunction() {
        String input = "SELECT mod(CONVERT(PART_ID, INTEGER), 13) FROM parts";
        String output = "SELECT (cast(PARTS.PART_ID AS int) % 13) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConcatFunction() {
        String input = "SELECT concat(part_name, 'b') FROM PARTS";
        String output = "SELECT CASE WHEN PARTS.PART_NAME IS NULL THEN NULL ELSE (PARTS.PART_NAME + 'b') END FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testProjectedCriteria() {
        String input = "SELECT part_name like '%b' FROM PARTS";
        String output = "SELECT CASE WHEN PARTS.PART_NAME LIKE '%b' THEN 1 WHEN NOT (PARTS.PART_NAME LIKE '%b') THEN 0 END FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testLcaseFunction() {
        String input = "SELECT lcase(PART_NAME) FROM PARTS";
        String output = "SELECT lower(PARTS.PART_NAME) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testUcaseFunction() {
        String input = "SELECT ucase(PART_NAME) FROM PARTS";
        String output = "SELECT upper(PARTS.PART_NAME) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testLengthFunction() {
        String input = "SELECT length(PART_NAME) FROM PARTS";
        String output = "SELECT {fn length(PARTS.PART_NAME)} FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstring2ArgFunction() {
        String input = "SELECT substring(PART_NAME, 3) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_NAME, 3, {fn length(PARTS.PART_NAME)}) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstring3ArgFunction() {
        String input = "SELECT substring(PART_NAME, 3, 5) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_NAME, 3, 5) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConvertFunctionInteger() {
        String input = "SELECT convert(PARTS.PART_ID, integer) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_ID AS int) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConvertTimestampTime() {
        String input = "SELECT convert(TIMESTAMPVALUE, time) FROM BQT1.SMALLA";
        String output = "SELECT cast(CASE WHEN SmallA.TimestampValue IS NOT NULL THEN '1970-01-01 ' + convert(varchar, SmallA.TimestampValue, 8) END AS datetime) FROM SmallA";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testConvertFunctionChar() {
        String input = "SELECT convert(PART_NAME, char) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_NAME AS char(1)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConvertFunctionBoolean() {
        String input = "SELECT convert(PART_ID, boolean) FROM PARTS";
        String output = "SELECT CASE WHEN PARTS.PART_ID IN ('false', '0') THEN 0 WHEN PARTS.PART_ID IS NOT NULL THEN 1 END FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testIfNullFunction() {
        String input = "SELECT ifnull(PART_NAME, 'abc') FROM PARTS";
        String output = "SELECT isnull(PARTS.PART_NAME, 'abc') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDateLiteral() {
        this.helpTestVisitor(this.getTestVDB(), "select {d '2002-12-31'} FROM parts", "SELECT CAST('2002-12-31' AS DATE) FROM PARTS");
    }

    @Test
    public void testTimeLiteral() {
        this.helpTestVisitor(this.getTestVDB(), "select {t '13:59:59'} FROM parts", "SELECT CAST('1970-01-01 13:59:59.0' AS DATETIME) FROM PARTS");
    }

    @Test
    public void testTimestampLiteral() {
        this.helpTestVisitor(this.getTestVDB(), "select {ts '2002-12-31 13:59:59'} FROM parts", "SELECT CAST('2002-12-31 13:59:59.0' AS DATETIME) FROM PARTS");
    }

    @Test
    public void testDefect12120() {
        this.helpTestVisitor(this.getBQTVDB(), "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA WHERE BQT1.SmallA.BooleanValue IN ({b'false'}, {b'true'})", "SELECT SmallA.IntKey FROM SmallA WHERE SmallA.BooleanValue IN (0, 1)");
    }

    @Test
    public void testConvertFunctionString() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, integer) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_ID AS int) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testNonIntMod() throws Exception {
        String input = "select mod(intkey/1.5, 3) from bqt1.smalla";
        String output = "SELECT ((cast(SmallA.IntKey AS numeric(38, 19)) / 1.5) - (sign((cast(SmallA.IntKey AS numeric(38, 19)) / 1.5)) * floor(abs(((cast(SmallA.IntKey AS numeric(38, 19)) / 1.5) / 3))) * abs(3))) FROM SmallA";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testOrderByDesc() throws Exception {
        String input = "select intnum + 1 x from bqt1.smalla order by x desc";
        String output = "SELECT (SmallA.IntNum + 1) AS x FROM SmallA ORDER BY x DESC";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testCrossJoin() throws Exception {
        String input = "select smalla.intnum from (bqt1.smalla cross join bqt1.smallb) left outer join bqt1.mediuma on (smalla.intnum = mediuma.intnum)";
        String output = "SELECT SmallA.IntNum FROM SmallA INNER JOIN SmallB ON 1 = 1 LEFT OUTER JOIN MediumA ON SmallA.IntNum = MediumA.IntNum";
        this.helpTestVisitor(this.getBQTVDB(), input, output);
    }

    @Test
    public void testTimestampFunctions() {
        this.helpTestVisitor(this.getBQTVDB(), "SELECT timestampadd(sql_tsi_second, 1, timestampvalue), timestampadd(sql_tsi_frac_second, 1000, timestampvalue), timestampdiff(sql_tsi_frac_second, timestampvalue, timestampvalue) from bqt1.smalla", "SELECT {fn timestampadd(sql_tsi_second, 1, SmallA.TimestampValue)}, dateadd(millisecond, 1000/1000000, SmallA.TimestampValue), datediff(millisecond, SmallA.TimestampValue,SmallA.TimestampValue)*1000000 FROM SmallA");
    }

    @Test
    public void testLimitSupport() {
        SybaseExecutionFactory sybaseExecutionFactory = new SybaseExecutionFactory();
        sybaseExecutionFactory.setDatabaseVersion("12.5.4");
        Assert.assertTrue((boolean)sybaseExecutionFactory.supportsRowLimit());
        sybaseExecutionFactory.setDatabaseVersion("12.5.2");
        Assert.assertFalse((boolean)sybaseExecutionFactory.supportsRowLimit());
        sybaseExecutionFactory.setDatabaseVersion("15");
        Assert.assertFalse((boolean)sybaseExecutionFactory.supportsRowLimit());
        sybaseExecutionFactory.setDatabaseVersion("15.1");
        Assert.assertTrue((boolean)sybaseExecutionFactory.supportsRowLimit());
    }

    @Test
    public void testFormatSupport() {
        Assert.assertTrue((boolean)trans.supportsFormatLiteral("MM/dd/yy", ExecutionFactory.Format.DATE));
        Assert.assertFalse((boolean)trans.supportsFormatLiteral("MMM/yyy", ExecutionFactory.Format.DATE));
        this.helpTestVisitor(this.getBQTVDB(), "SELECT formattimestamp(timestampvalue, 'yy.MM.dd') from bqt1.smalla", "SELECT CONVERT(VARCHAR, SmallA.TimestampValue, 2) FROM SmallA");
    }

    @Test
    public void testGroupBySelect() {
        this.helpTestVisitor(this.getBQTVDB(), "SELECT 1 from bqt1.smalla group by intkey", "SELECT SmallA.IntKey FROM SmallA GROUP BY SmallA.IntKey");
    }

    @Test
    public void testBinaryLiteral() {
        this.helpTestVisitor(this.getBQTVDB(), "SELECT X'abcd1234'", "SELECT 0xABCD1234");
    }

    @Test
    public void testPadFunctions() {
        String input = "SELECT lpad(PART_NAME,2), lpad(part_name,2,'x'), rpad(PART_NAME,2), rpad(part_name,2,'x') FROM PARTS";
        String output = "SELECT CASE WHEN PARTS.PART_NAME IS NULL THEN NULL ELSE RIGHT(REPLICATE(' ', 2) + LEFT(PARTS.PART_NAME, 2), 2) END, CASE WHEN PARTS.PART_NAME IS NULL OR 'x' IS NULL THEN NULL ELSE RIGHT(REPLICATE('x', 2) + LEFT(PARTS.PART_NAME, 2), 2) END, CASE WHEN PARTS.PART_NAME IS NULL THEN NULL ELSE LEFT(PARTS.PART_NAME + REPLICATE(' ', 2), 2) END, CASE WHEN PARTS.PART_NAME IS NULL OR 'x' IS NULL THEN NULL ELSE LEFT(PARTS.PART_NAME + REPLICATE('x', 2), 2) END FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }
}

