/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.oracle.OracleExecutionFactory;

public class TestMonthOrDayNameFunctionModifier
extends TestCase {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public TestMonthOrDayNameFunctionModifier(String name) {
        super(name);
    }

    public void helpTestMod(Literal c, String format, String expectedStr) throws Exception {
        Function func = LANG_FACTORY.createFunction(format.toLowerCase() + "name", Arrays.asList(c), String.class);
        OracleExecutionFactory trans = new OracleExecutionFactory();
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        TestMonthOrDayNameFunctionModifier.assertEquals((String)expectedStr, (String)sqlVisitor.toString());
    }

    public void test1() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)104, (int)0, (int)21, (int)10, (int)5, (int)0, (int)10000000), Timestamp.class);
        this.helpTestMod(arg1, "Month", "rtrim(TO_CHAR({ts '2004-01-21 10:05:00.01'}, 'Month'))");
    }

    public void test2() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)104, (int)0, (int)21), Date.class);
        this.helpTestMod(arg1, "Month", "rtrim(TO_CHAR({d '2004-01-21'}, 'Month'))");
    }

    public void test3() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)104, (int)0, (int)21, (int)10, (int)5, (int)0, (int)10000000), Timestamp.class);
        this.helpTestMod(arg1, "Day", "rtrim(TO_CHAR({ts '2004-01-21 10:05:00.01'}, 'Day'))");
    }

    public void test4() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)104, (int)0, (int)21), Date.class);
        this.helpTestMod(arg1, "Day", "rtrim(TO_CHAR({d '2004-01-21'}, 'Day'))");
    }
}

