/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.StringUtil;
import org.teiid.translator.jdbc.ParseFormatFunctionModifier;

public class OracleFormatFunctionModifier
extends ParseFormatFunctionModifier {
    static final Pattern tokenPattern = Pattern.compile("(G+|y{1,4}|M{2,4}|DD|dd|E+|a+|HH|hh|mm|ss|S+|Z+|[\\- /,.;:]+|(?:'[^'\"]*')+|[^'\"a-zA-Z]+)");
    protected boolean parse;

    public OracleFormatFunctionModifier(String prefix, boolean parse) {
        super(prefix);
        this.parse = parse;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean supportsLiteral(String literal) {
        try {
            this.translateFormat(literal);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    protected Object translateFormat(String format) {
        Matcher m = tokenPattern.matcher(format);
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        int end = 0;
        char previous = '\u0000';
        while (m.find()) {
            if (m.group().length() == 0) continue;
            if (end == 0 ? m.start() != 0 : m.start() != end) {
                throw new IllegalArgumentException();
            }
            String group = m.group();
            if (Character.isLetter(previous) && group.charAt(0) == previous) {
                throw new IllegalArgumentException();
            }
            previous = group.charAt(0);
            sb.append(this.convertToken(group));
            end = m.end();
        }
        if (end != format.length()) {
            throw new IllegalArgumentException();
        }
        sb.append("'");
        return sb.toString();
    }

    protected Object convertToken(String group) {
        switch (group.charAt(0)) {
            case 'G': {
                return "AD";
            }
            case 'y': {
                if (group.length() == 2) {
                    return "YY";
                }
                return "YYYY";
            }
            case 'M': {
                if (group.length() == 2) {
                    return "MM";
                }
                if (group.length() == 3) {
                    return "Mon";
                }
                return "Month";
            }
            case 'D': {
                return "DDD";
            }
            case 'd': {
                return "DD";
            }
            case 'E': {
                if (group.length() >= 4) {
                    return "Day";
                }
                return "Dy";
            }
            case 'a': {
                return "AM";
            }
            case 'H': {
                return "HH24";
            }
            case 'h': {
                if (this.parse) {
                    return "HH24";
                }
                return "HH";
            }
            case 'm': {
                return "MI";
            }
            case 's': {
                return "SS";
            }
            case 'S': {
                return "FF" + group.length();
            }
            case 'Z': {
                return "TZHTZM";
            }
            case '\'': {
                return '\"' + StringUtil.replaceAll((String)StringUtil.replaceAll((String)StringUtil.replaceAll((String)group.substring(1, group.length() - 1), (String)"''", (String)"'"), (String)"'", (String)"''"), (String)"\"", (String)"\"\"") + '\"';
            }
            case ' ': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': {
                return group;
            }
        }
        return '\"' + group + '\"';
    }
}

