/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.postgresql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;

public class PostgreSQLMetadataProcessor
extends JDBCMetadataProcessor {
    @Override
    protected String getRuntimeType(int type, String typeName, int precision) {
        if ("geometry".equalsIgnoreCase(typeName)) {
            return "geometry";
        }
        if ("geography".equalsIgnoreCase(typeName)) {
            return "geography";
        }
        if ("json".equalsIgnoreCase(typeName) || "jsonb".equalsIgnoreCase(typeName)) {
            return "json";
        }
        if ("uuid".equalsIgnoreCase(typeName)) {
            return "string";
        }
        return super.getRuntimeType(type, typeName, precision);
    }

    @Override
    protected String getNativeComponentType(String typeName) {
        if (typeName.startsWith("_")) {
            return typeName.substring(1);
        }
        return super.getNativeComponentType(typeName);
    }

    @Override
    protected Column addColumn(ResultSet columns, Table table, MetadataFactory metadataFactory, int rsColumns) throws SQLException {
        Column result = super.addColumn(columns, table, metadataFactory, rsColumns);
        if ("uuid".equalsIgnoreCase(result.getNativeType())) {
            result.setLength(36);
            result.setCaseSensitive(false);
        }
        return result;
    }

    @Override
    protected String getGeographyMetadataTableName() {
        return "public.geometry_columns";
    }

    @Override
    protected String getGeometryMetadataTableName() {
        return "public.geography_columns";
    }

    @Override
    protected ResultSet executeSequenceQuery(Connection conn) throws SQLException {
        String query = "select null::varchar as sequence_catalog, nspname as sequence_schema, relname as sequence_name from pg_class, pg_namespace where relkind='S' and pg_namespace.oid = relnamespace and nspname like ? escape '' and relname like ? escape ''";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, this.getSchemaPattern() == null ? "%" : this.getSchemaPattern());
        ps.setString(2, this.getSequenceNamePattern() == null ? "%" : this.getSequenceNamePattern());
        return ps.executeQuery();
    }

    @Override
    protected String getSequenceNextSQL(String fullyQualifiedName) {
        return "nextval('" + StringUtil.replaceAll((String)fullyQualifiedName, (String)"'", (String)"''") + "')";
    }

    @Override
    protected Table addTable(MetadataFactory metadataFactory, String tableCatalog, String tableSchema, String tableName, String remarks, String fullName, ResultSet tables) throws SQLException {
        String type = tables.getString(4);
        if (type == null || type.contains("INDEX") || type.equalsIgnoreCase("TYPE") || type.equalsIgnoreCase("SEQUENCE")) {
            return null;
        }
        return super.addTable(metadataFactory, tableCatalog, tableSchema, tableName, remarks, fullName, tables);
    }
}

