/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.netezza;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.netezza.NetezzaExecutionFactory;

public class TestNetezzaConvertModifier {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public String helpGetString(Expression expr) throws Exception {
        NetezzaExecutionFactory trans = new NetezzaExecutionFactory();
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testStringToChar() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "char", "cast('5' AS char(1))");
    }

    @Test
    public void testStringToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "boolean", "CASE WHEN '5' IN ('false', '0') THEN '0' WHEN '5' IS NOT NULL THEN '1' END");
    }

    @Test
    public void testStringToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "byte", "cast('5' AS byteint)");
    }

    @Test
    public void testStringToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "short", "cast('5' AS smallint)");
    }

    @Test
    public void testStringToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "integer", "cast('5' AS integer)");
    }

    @Test
    public void testStringToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "long", "cast('5' AS bigint)");
    }

    @Test
    public void testStringToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "biginteger", "cast('5' AS numeric(38))");
    }

    @Test
    public void testStringToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "float", "cast('5' AS float)");
    }

    @Test
    public void testStringToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "double", "cast('5' AS double)");
    }

    @Test
    public void testStringToDate() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"2004-06-29", String.class), "date", "to_date('2004-06-29', 'YYYY-MM-DD')");
    }

    @Test
    public void testStringToTime() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"23:59:59", String.class), "time", "to_timestamp('23:59:59', 'HH24:MI:SS')");
    }

    @Test
    public void testStringToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"2004-06-29 23:59:59.987", String.class), "timestamp", "to_timestamp('2004-06-29 23:59:59.987', 'YYYY-MM-DD HH24:MI:SS.MS')");
    }

    @Test
    public void testStringToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "bigdecimal", "cast('5' AS numeric(38,18))");
    }

    @Test
    public void testCharToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Character('5'), Character.class), "string", "'5'");
    }

    @Test
    public void testBooleanToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "string", "CASE WHEN 1 = '0' THEN 'false' WHEN 1 IS NOT NULL THEN 'true' END");
    }

    @Test
    public void testBooleanToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "byte", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "short", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "integer", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "long", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToBigInteger() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "biginteger", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToFloat() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "float", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "double", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testBooleanToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.FALSE, Boolean.class), "bigdecimal", "(CASE WHEN 0 IN ( '0', 'FALSE') THEN 0 WHEN 0 IS NOT NULL THEN 1 END)");
    }

    @Test
    public void testByteToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testByteToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "boolean", "CASE WHEN 1 = 0 THEN '0' WHEN 1 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testShortToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testShortToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Short(1), Short.class), "boolean", "CASE WHEN 1 = 0 THEN '0' WHEN 1 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testIntegerToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class), "boolean", "CASE WHEN 1 = 0 THEN '0' WHEN 1 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testLongToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testLongToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Long(1L), Long.class), "boolean", "CASE WHEN 1 = 0 THEN '0' WHEN 1 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testBigIntegerToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testBigIntegerToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "boolean", "CASE WHEN 1 = 0 THEN '0' WHEN 1 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testFloatToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "string", "cast(1.2 AS varchar(4000))");
    }

    @Test
    public void testFloatToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "boolean", "CASE WHEN 1.2 = 0 THEN '0' WHEN 1.2 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testDoubleToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "string", "cast(1.2 AS varchar(4000))");
    }

    @Test
    public void testDoubleToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "boolean", "CASE WHEN 1.2 = 0 THEN '0' WHEN 1.2 IS NOT NULL THEN '1' END");
    }

    @Test
    public void testBigDecimalToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "string", "cast(1.0 AS varchar(4000))");
    }

    @Test
    public void testBigDecimalToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "boolean", "CASE WHEN 1.0 = 0 THEN '0' WHEN 1.0 IS NOT NULL THEN '1' END");
    }
}

