/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.ucanaccess;

import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.ucanaccess.UCanAccessExecutionFactory;

public class TestUCanAccessTranslator {
    private static UCanAccessExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setup() throws TranslatorException {
        TRANSLATOR = new UCanAccessExecutionFactory();
        TRANSLATOR.start();
    }

    @Test
    public void testPushDownFuctions() throws TranslatorException {
        String input = "SELECT ucanaccess.DCount('*','T20','id > 100') FROM BQT1.MediumA";
        String output = "SELECT DCount('*', 'T20', 'id > 100') FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT ucanaccess.DSum('id','T20','id > 100')";
        output = "VALUES(DSum('id', 'T20', 'id > 100'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT ucanaccess.DMax('id', 'T20')";
        output = "VALUES(DMax('id', 'T20'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT ucanaccess.DMin('id', 'T20')";
        output = "VALUES(DMin('id', 'T20'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT ucanaccess.DAvg('id', 'T20')";
        output = "VALUES(DAvg('id', 'T20'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT ucanaccess.DFirst('descr', 'T20')";
        output = "VALUES(DFirst('descr', 'T20'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "SELECT ucanaccess.DLast('descr', 'T20')";
        output = "VALUES(DLast('descr', 'T20'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

