/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.Arrays;
import java.util.List;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;

public class LocateFunctionModifier
extends AliasModifier {
    public static String LOCATE = "LOCATE";
    private LanguageFactory langFactory;
    private boolean sourceStringFirst;

    public LocateFunctionModifier(LanguageFactory langFactory) {
        this(langFactory, LOCATE, false);
    }

    public LocateFunctionModifier(LanguageFactory langFactory, String functionName, boolean sourceStringFirst) {
        super(functionName);
        this.langFactory = langFactory;
        this.sourceStringFirst = sourceStringFirst;
    }

    @Override
    public void modify(Function function) {
        super.modify(function);
        List args = function.getParameters();
        Expression searchStr = (Expression)args.get(0);
        Expression sourceStr = (Expression)args.get(1);
        if (args.size() > 2) {
            args.set(2, this.ensurePositiveStartIndex((Expression)args.get(2)));
        }
        if (this.sourceStringFirst) {
            args.set(0, sourceStr);
            args.set(1, searchStr);
        }
    }

    private Expression ensurePositiveStartIndex(Expression startIndex) {
        if (startIndex instanceof Literal) {
            Literal literal = (Literal)startIndex;
            if (literal.getValue() instanceof Integer && (Integer)literal.getValue() < 1) {
                literal.setValue((Object)1);
            }
        } else {
            Comparison whenExpr = this.langFactory.createCompareCriteria(Comparison.Operator.LT, startIndex, (Expression)this.langFactory.createLiteral((Object)1, Integer.class));
            Literal thenExpr = this.langFactory.createLiteral((Object)1, Integer.class);
            startIndex = this.langFactory.createSearchedCaseExpression(Arrays.asList(this.langFactory.createSearchedWhenCondition((Condition)whenExpr, (Expression)thenExpr)), startIndex, TypeFacility.RUNTIME_TYPES.INTEGER);
        }
        return startIndex;
    }

    protected LanguageFactory getLanguageFactory() {
        return this.langFactory;
    }
}

