/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.CommandContext;
import org.teiid.cdk.CommandBuilder;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.FakeExecutionContextImpl;
import org.teiid.language.Array;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Expression;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.Parameter;
import org.teiid.language.Select;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCProcedureExecution;
import org.teiid.translator.jdbc.JDBCQueryExecution;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.TranslatedCommand;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.oracle.OracleExecutionFactory;
import org.teiid.translator.jdbc.oracle.OracleMetadataProcessor;
import org.teiid.util.Version;

public class TestOracleTranslator {
    private OracleExecutionFactory TRANSLATOR;
    private static ExecutionContext EMPTY_CONTEXT = new FakeExecutionContextImpl();

    @Before
    public void setup() throws Exception {
        this.TRANSLATOR = new OracleExecutionFactory();
        this.TRANSLATOR.setUseBindVariables(false);
        this.TRANSLATOR.setDatabaseVersion(Version.DEFAULT_VERSION);
        this.TRANSLATOR.start();
    }

    private void helpTestVisitor(String input, String expectedOutput) throws TranslatorException {
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, expectedOutput);
    }

    @Test
    public void testSourceHint() throws Exception {
        FakeExecutionContextImpl impl = new FakeExecutionContextImpl();
        impl.setHints(Arrays.asList("hello world"));
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts", (ExecutionContext)impl, null, "SELECT /*+ hello world */ g_0.PART_NAME FROM PARTS g_0", true);
    }

    @Test
    public void testSourceHint1() throws Exception {
        FakeExecutionContextImpl impl = new FakeExecutionContextImpl();
        impl.setHints(Arrays.asList("hello world"));
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts union select part_id from parts", (ExecutionContext)impl, null, "SELECT /*+ hello world */ g_1.PART_NAME AS c_0 FROM PARTS g_1 UNION SELECT g_0.PART_ID AS c_0 FROM PARTS g_0", true);
    }

    @Test
    public void testSourceHint2() throws Exception {
        FakeExecutionContextImpl impl = new FakeExecutionContextImpl();
        impl.setHints(Arrays.asList("hello world"));
        this.helpTestVisitor(this.getTestVDB(), "with x (y) as /*+ no_inline */ (select part_name from parts) select y from x", (ExecutionContext)impl, null, "WITH x AS (SELECT g_0.PART_NAME AS y FROM PARTS g_0) SELECT /*+ hello world */ g_1.y FROM x g_1", true);
    }

    @Test
    public void testSourceHint3() throws Exception {
        FakeExecutionContextImpl impl = new FakeExecutionContextImpl();
        impl.setHints(Arrays.asList("hello world"));
        impl.setGeneralHints(Arrays.asList("other"));
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts", (ExecutionContext)impl, null, "SELECT /*+ hello world other */ g_0.PART_NAME FROM PARTS g_0", true);
    }

    @Test
    public void testInsertWithSequnce() throws Exception {
        this.helpTestVisitor("insert into smalla (doublenum) values (1)", "INSERT INTO SmallishA (DoubleNum, ID) VALUES (1.0, MYSEQUENCE.nextVal)");
    }

    @Test
    public void testInsertWithSequnce1() throws Exception {
        this.helpTestVisitor("insert into smalla (doublenum, id) values (1, 1)", "INSERT INTO SmallishA (DoubleNum, ID) VALUES (1.0, 1)");
    }

    @Test
    public void testJoins() throws Exception {
        String input = "select smalla.intkey from bqt1.smalla inner join bqt1.smallb on smalla.stringkey=smallb.stringkey cross join bqt1.mediuma";
        String output = "SELECT SmallA.IntKey FROM SmallA INNER JOIN SmallB ON SmallA.StringKey = SmallB.StringKey CROSS JOIN MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testJoins2() throws Exception {
        String input = "select smalla.intkey from bqt1.smalla cross join (bqt1.smallb cross join bqt1.mediuma)";
        String output = "SELECT SmallA.IntKey FROM SmallA CROSS JOIN (SmallB CROSS JOIN MediumA)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion1() throws Exception {
        String input = "SELECT char(convert(STRINGNUM, integer) + 100) FROM BQT1.SMALLA";
        String output = "SELECT chr((trunc(to_number(SmallA.StringNum)) + 100)) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion2() throws Exception {
        String input = "SELECT convert(STRINGNUM, long) FROM BQT1.SMALLA";
        String output = "SELECT trunc(to_number(SmallA.StringNum)) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion3() throws Exception {
        String input = "SELECT convert(convert(STRINGNUM, long), string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(trunc(to_number(SmallA.StringNum))) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion4() throws Exception {
        String input = "SELECT convert(convert(TIMESTAMPVALUE, date), string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(trunc(cast(SmallA.TimestampValue AS date)), 'YYYY-MM-DD') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion6() throws Exception {
        String input = "SELECT convert(convert(TIMEVALUE, timestamp), string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(cast(SmallA.TimeValue AS timestamp), 'YYYY-MM-DD HH24:MI:SS.FF') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion6a() throws Exception {
        String input = "SELECT convert(timestampvalue, string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(SmallishA.timestampvalue, 'YYYY-MM-DD HH24:MI:SS') FROM SmallishA";
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testConversion8() throws Exception {
        String input = "SELECT nvl(INTNUM, 'otherString') FROM BQT1.SMALLA";
        String output = "SELECT nvl(to_char(SmallA.IntNum), 'otherString') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConversion7() throws Exception {
        String input = "SELECT convert(convert(STRINGNUM, integer), string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(trunc(to_number(SmallA.StringNum))) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate() throws Exception {
        String input = "SELECT locate(INTNUM, 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', to_char(SmallA.IntNum), 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate2() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp') FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate3() throws Exception {
        String input = "SELECT locate(INTNUM, '234567890', 1) FROM BQT1.SMALLA WHERE INTKEY = 26";
        String output = "SELECT INSTR('234567890', to_char(SmallA.IntNum), 1) FROM SmallA WHERE SmallA.IntKey = 26";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate4() throws Exception {
        String input = "SELECT locate('c', 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT 1 FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate5() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', -5) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum, 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate6() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', INTNUM) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum, CASE WHEN SmallA.IntNum < 1 THEN 1 ELSE SmallA.IntNum END) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLocate7() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', LOCATE(STRINGNUM, 'chimp') + 1) FROM BQT1.SMALLA";
        String output = "SELECT INSTR('chimp', SmallA.StringNum, CASE WHEN (INSTR('chimp', SmallA.StringNum) + 1) < 1 THEN 1 ELSE (INSTR('chimp', SmallA.StringNum) + 1) END) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testSubstring1() throws Exception {
        String input = "SELECT substring(StringNum, 1) FROM BQT1.SMALLA";
        String output = "SELECT substr(SmallA.StringNum, 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testSubstring2() throws Exception {
        String input = "SELECT substring(StringNum, 1, 1) FROM BQT1.SMALLA";
        String output = "SELECT substr(SmallA.StringNum, 1, 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testUnionWithOrderBy() throws Exception {
        String input = "SELECT IntKey FROM BQT1.SMALLA UNION SELECT IntKey FROM BQT1.SMALLB ORDER BY IntKey";
        String output = "SELECT SmallA.IntKey FROM SmallA UNION SELECT SmallB.IntKey FROM SmallB ORDER BY IntKey";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRecursiveCTEWithStringLiteral() throws Exception {
        String input = "WITH tmp_cte(id, name, fk, fkname, lvl) AS \n    (SELECT id, name, fk, cast(NULL as string) as fkname, 0 as lvl \n            FROM cte_source WHERE fk IS NULL \n     UNION ALL \n     SELECT e.id, e.name, e.fk, ecte.name as fkname, lvl + 1 as lvl \n           FROM cte_source AS e \n           INNER JOIN tmp_cte AS ecte ON ecte.id = e.fk\n     ) \nSELECT * FROM tmp_cte order by lvl";
        String output = "WITH tmp_cte (id, name, fk, fkname, lvl) AS (SELECT cte_source.id, cte_source.name, cte_source.fk, NULL AS fkname, 0 AS lvl FROM cte_source WHERE cte_source.fk IS NULL UNION ALL SELECT e.id, e.name, e.fk, ecte.name AS fkname, (ecte.lvl + 1) AS lvl FROM cte_source e INNER JOIN tmp_cte ecte ON ecte.id = e.fk) SELECT tmp_cte.id, tmp_cte.name, tmp_cte.fk, tmp_cte.fkname, tmp_cte.lvl FROM tmp_cte ORDER BY tmp_cte.lvl";
        TranslationHelper.helpTestVisitor("create foreign table cte_source (id integer, name string options (native_type 'varchar(255)'), fk integer)", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRowLimit1() throws Exception {
        String input = "select intkey from bqt1.smalla limit 10, 0";
        String output = "SELECT * FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT SmallA.IntKey FROM SmallA) VIEW_FOR_LIMIT WHERE ROWNUM <= 10) WHERE ROWNUM_ > 10";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRowLimit2() throws Exception {
        String input = "select intkey from bqt1.smalla limit 0, 10";
        String output = "SELECT * FROM (SELECT SmallA.IntKey FROM SmallA) WHERE ROWNUM <= 10";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRowLimit3() throws Exception {
        String input = "select intkey from bqt1.smalla limit 1, 10";
        String output = "SELECT * FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT SmallA.IntKey FROM SmallA) VIEW_FOR_LIMIT WHERE ROWNUM <= 11) WHERE ROWNUM_ > 1";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRowLimit4() throws Exception {
        String input = "select intkey from bqt1.mediuma limit 100";
        String output = "SELECT * FROM (SELECT MediumA.IntKey FROM MediumA) WHERE ROWNUM <= 100";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRowLimit5() throws Exception {
        String input = "select intkey from bqt1.mediuma limit 50, 100";
        String output = "SELECT * FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT MediumA.IntKey FROM MediumA) VIEW_FOR_LIMIT WHERE ROWNUM <= 150) WHERE ROWNUM_ > 50";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testConcat2_useLiteral() throws Exception {
        String input = "select concat2(stringnum,'_xx') from bqt1.Smalla";
        String output = "SELECT (g_0.StringNum || '_xx') FROM SmallA g_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        commandBuilder.getLanguageBridgeFactory().setSupportsConcat2(true);
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)this.TRANSLATOR, obj);
    }

    @Test
    public void testConcat2() throws Exception {
        String input = "select concat2(stringnum, stringkey) from bqt1.Smalla";
        String output = "SELECT (g_0.StringNum || g_0.StringKey) FROM SmallA g_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        commandBuilder.getLanguageBridgeFactory().setSupportsConcat2(true);
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)this.TRANSLATOR, obj);
    }

    @Test
    public void test_sdo_relate() throws Exception {
        String input = "SELECT a.INTKEY FROM BQT1.SMALLA A, BQT1.SMALLB B WHERE sdo_relate(A.OBJECTVALUE, b.OBJECTVALUE, 'mask=ANYINTERACT') = true";
        String output = "SELECT /*+ ORDERED */ A.IntKey FROM SmallA A, SmallB B WHERE sdo_relate(A.ObjectValue, B.ObjectValue, 'mask=ANYINTERACT') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void test_sdo_within_distance() throws Exception {
        String input = "SELECT INTKEY FROM BQT1.SMALLA WHERE sdo_within_distance(OBJECTVALUE, 'SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL)', 'DISTANCE=25.0 UNIT=NAUT_MILE') = true";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE sdo_within_distance(SmallA.ObjectValue, SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL), 'DISTANCE=25.0 UNIT=NAUT_MILE') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void test_sdo_within_distance_pushdownfunction() throws Exception {
        String input = "SELECT INTKEY FROM BQT1.SMALLA WHERE sdo_within_distance(OBJECTVALUE, 'SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL)', 'DISTANCE=25.0 UNIT=NAUT_MILE') = true";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE sdo_within_distance(SmallA.ObjectValue, SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL), 'DISTANCE=25.0 UNIT=NAUT_MILE') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void test_sdo_within_distance2() throws Exception {
        String input = "SELECT INTKEY FROM BQT1.SMALLA WHERE sdo_within_distance('SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL)', OBJECTVALUE, 'DISTANCE=25.0 UNIT=NAUT_MILE') = true";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE sdo_within_distance(SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL), SmallA.ObjectValue, 'DISTANCE=25.0 UNIT=NAUT_MILE') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void test_sdo_within_distance3() throws Exception {
        String input = "SELECT INTKEY FROM BQT1.SMALLA WHERE sdo_within_distance(STRINGKEY, 'SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL)', 'DISTANCE=25.0 UNIT=NAUT_MILE') = true";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE sdo_within_distance(SmallA.StringKey, SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL), 'DISTANCE=25.0 UNIT=NAUT_MILE') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void test_sdo_within_distance4() throws Exception {
        String input = "SELECT INTKEY FROM BQT1.SMALLA WHERE sdo_within_distance('SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL)', 'SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL)', 'DISTANCE=25.0 UNIT=NAUT_MILE') = true";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE sdo_within_distance(SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL), SDO_GEOMETRY(2001, 8307, MDSYS.SDO_POINT_TYPE(90.0, -45.0, NULL), NULL, NULL), 'DISTANCE=25.0 UNIT=NAUT_MILE') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void test_sdo_within_distance5() throws Exception {
        String input = "SELECT a.INTKEY FROM BQT1.SMALLA A, BQT1.SMALLB B WHERE sdo_within_distance(a.OBJECTVALUE, b.OBJECTVALUE, 'DISTANCE=25.0 UNIT=NAUT_MILE') = true";
        String output = "SELECT A.IntKey FROM SmallA A, SmallB B WHERE sdo_within_distance(A.ObjectValue, B.ObjectValue, 'DISTANCE=25.0 UNIT=NAUT_MILE') = 'true'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLogFunction() throws Exception {
        String input = "SELECT log(CONVERT(stringkey, INTEGER)) FROM bqt1.smalla";
        String output = "SELECT ln(trunc(to_number(SmallA.StringKey))) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testLog10Function() throws Exception {
        String input = "SELECT log10(CONVERT(stringkey, INTEGER)) FROM bqt1.smalla";
        String output = "SELECT log(10, trunc(to_number(SmallA.StringKey))) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testAliasedFunctions() throws Exception {
        String input = "SELECT char(CONVERT(stringkey, INTEGER)), lcase(stringkey), ucase(stringkey), ifnull(stringkey, 'x') FROM bqt1.smalla";
        String output = "SELECT chr(trunc(to_number(SmallA.StringKey))), lower(SmallA.StringKey), upper(SmallA.StringKey), nvl(SmallA.StringKey, 'x') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    private String getTestVDB() {
        return UnitTestUtil.getTestDataPath() + "/PartsSupplierOracle.vdb";
    }

    private void helpTestVisitor(String vdb, String input, String dbmsTimeZone, String expectedOutput) throws TranslatorException {
        this.helpTestVisitor(vdb, input, EMPTY_CONTEXT, dbmsTimeZone, expectedOutput, false);
    }

    private void helpTestVisitor(String vdb, String input, String dbmsTimeZone, String expectedOutput, boolean correctNaming) throws TranslatorException {
        this.helpTestVisitor(vdb, input, EMPTY_CONTEXT, dbmsTimeZone, expectedOutput, correctNaming);
    }

    private void helpTestVisitor(String vdb, String input, ExecutionContext context, String dbmsTimeZone, String expectedOutput, boolean correctNaming) throws TranslatorException {
        TranslationUtility util = new TranslationUtility(vdb);
        Command obj = util.parseCommand(input, correctNaming, true);
        this.helpTestVisitor(obj, context, dbmsTimeZone, expectedOutput);
    }

    private Command helpTestVisitor(QueryMetadataInterface metadata, String input, ExecutionContext context, String dbmsTimeZone, String expectedOutput) throws TranslatorException {
        CommandBuilder commandBuilder = new CommandBuilder(metadata);
        Command obj = commandBuilder.getCommand(input);
        this.helpTestVisitor(obj, context, dbmsTimeZone, expectedOutput);
        return obj;
    }

    private void helpTestVisitor(Command obj, ExecutionContext context, String dbmsTimeZone, String expectedOutput) throws TranslatorException {
        OracleExecutionFactory translator = new OracleExecutionFactory();
        if (dbmsTimeZone != null) {
            translator.setDatabaseTimeZone(dbmsTimeZone);
        }
        translator.setUseBindVariables(false);
        translator.start();
        TranslatedCommand tc = new TranslatedCommand(context, (JDBCExecutionFactory)translator);
        tc.translateCommand(obj);
        Assert.assertEquals((String)"Did not get correct sql", (Object)expectedOutput, (Object)tc.getSql());
    }

    @Test
    public void testDateStuff() throws Exception {
        String input = "SELECT ((CASE WHEN month(datevalue) < 10 THEN ('0' || convert(month(datevalue), string)) ELSE convert(month(datevalue), string) END || CASE WHEN dayofmonth(datevalue) < 10 THEN ('0' || convert(dayofmonth(datevalue), string)) ELSE convert(dayofmonth(datevalue), string) END) || convert(year(datevalue), string)), SUM(intkey) FROM bqt1.SMALLA GROUP BY datevalue";
        String output = "SELECT CASE WHEN CASE WHEN CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END IS NULL OR CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END IS NULL THEN NULL ELSE concat(CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END, CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END) END IS NULL OR to_char(EXTRACT(YEAR FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat(CASE WHEN CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END IS NULL OR CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END IS NULL THEN NULL ELSE concat(CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END, CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END) END, to_char(EXTRACT(YEAR FROM SmallA.DateValue))) END, SUM(SmallA.IntKey) FROM SmallA GROUP BY SmallA.DateValue";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testDateStuff1() throws Exception {
        String input = "SELECT hour(datevalue), minute(timestampvalue), second(cast(stringkey as date)) FROM bqt1.SMALLA";
        String output = "SELECT EXTRACT(HOUR FROM cast(SmallA.DateValue AS timestamp)), EXTRACT(MINUTE FROM SmallA.TimestampValue), EXTRACT(SECOND FROM cast(to_date(SmallA.StringKey, 'YYYY-MM-DD') AS timestamp)) FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testDateStuff2() throws Exception {
        String input = "SELECT hour(timestampvalue) FROM SmallA";
        String output = "SELECT EXTRACT(HOUR FROM cast(SmallishA.timestampvalue AS timestamp)) FROM SmallishA";
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testTimeExtract() throws Exception {
        String input = "SELECT hour(cast(timestampvalue as time)) FROM SmallA";
        String output = "SELECT EXTRACT(HOUR FROM cast(case when SmallishA.timestampvalue is null then null else to_date('1970-01-01 ' || to_char(SmallishA.timestampvalue, 'HH24:MI:SS'), 'YYYY-MM-DD HH24:MI:SS') end AS timestamp)) FROM SmallishA";
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testAliasedGroup() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select y.part_name from parts as y", null, "SELECT y.PART_NAME FROM PARTS y");
    }

    @Test
    public void testDateLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {d '2002-12-31'} FROM parts", null, "SELECT {d '2002-12-31'} FROM PARTS");
    }

    @Test
    public void testTimeLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {t '13:59:59'} FROM parts", null, "SELECT to_date('1970-01-01 13:59:59', 'YYYY-MM-DD HH24:MI:SS') FROM PARTS");
    }

    @Test
    public void testTimestampLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {ts '2002-12-31 13:59:59.1'} FROM parts", null, "SELECT {ts '2002-12-31 13:59:59.1'} FROM PARTS");
    }

    @Test
    public void testTimestampLiteral1() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {ts '2002-12-31 13:59:59'} FROM parts", null, "SELECT to_date('2002-12-31 13:59:59', 'YYYY-MM-DD HH24:MI:SS') FROM PARTS");
    }

    @Test
    public void testUnionOrderByWithThreeBranches() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_id id FROM parts UNION ALL select part_name FROM parts UNION ALL select part_id FROM parts ORDER BY id", null, "SELECT g_2.PART_ID AS c_0 FROM PARTS g_2 UNION ALL SELECT g_1.PART_NAME AS c_0 FROM PARTS g_1 UNION ALL SELECT g_0.PART_ID AS c_0 FROM PARTS g_0 ORDER BY c_0", true);
    }

    @Test
    public void testUnionOrderBy() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_id FROM parts UNION ALL select part_name FROM parts ORDER BY part_id", null, "SELECT g_1.PART_ID AS c_0 FROM PARTS g_1 UNION ALL SELECT g_0.PART_NAME AS c_0 FROM PARTS g_0 ORDER BY c_0", true);
    }

    @Test
    public void testUnionOrderBy2() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_id as p FROM parts UNION ALL select part_name FROM parts ORDER BY p", null, "SELECT PARTS.PART_ID AS p FROM PARTS UNION ALL SELECT PARTS.PART_NAME FROM PARTS ORDER BY p");
    }

    @Test
    public void testUpdateWithFunction() throws Exception {
        String input = "UPDATE bqt1.smalla SET intkey = intkey + 1";
        String output = "UPDATE SmallA SET IntKey = (SmallA.IntKey + 1)";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testDUAL() throws Exception {
        String input = "SELECT something FROM DUAL as g0";
        String output = "SELECT seq.nextval FROM DUAL";
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testDUALLimit() throws Exception {
        String input = "SELECT something FROM DUAL as g0 LIMIT 2";
        String output = "SELECT seq.nextval FROM DUAL";
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testDUALLimit1() throws Exception {
        String input = "SELECT something FROM DUAL as g0 LIMIT 1, 2";
        String output = "SELECT seq.nextval FROM DUAL WHERE 1 = 0";
        this.helpTestVisitor(this.getOracleSpecificMetadata(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testROWNUM() throws Exception {
        String input = "SELECT part_name, rownum FROM parts";
        String output = "SELECT PARTS.PART_NAME, ROWNUM FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    @Test
    public void testROWNUM2() throws Exception {
        String input = "SELECT part_name FROM parts where rownum < 100";
        String output = "SELECT PARTS.PART_NAME FROM PARTS WHERE ROWNUM < 100";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    @Test
    public void testOracleCommentPayload() throws Exception {
        String input = "SELECT part_name, rownum FROM parts";
        String output = "SELECT /*+ ALL_ROWS */ PARTS.PART_NAME, ROWNUM FROM PARTS";
        String hint = "/*+ ALL_ROWS */";
        ExecutionContextImpl context = new ExecutionContextImpl(null, (Object)1, (Serializable)((Object)hint), null, "", 1L, null, null);
        this.helpTestVisitor(this.getTestVDB(), input, (ExecutionContext)context, null, output, false);
    }

    @Test
    public void testOracleCommentPayload1() throws Exception {
        String input = "SELECT part_name, rownum FROM parts";
        String output = "SELECT PARTS.PART_NAME, ROWNUM FROM PARTS";
        String hint = "/*+ ALL_ROWS */ something else";
        ExecutionContextImpl context = new ExecutionContextImpl(null, (Object)1, (Serializable)((Object)hint), null, "", 1L, null, null);
        this.helpTestVisitor(this.getTestVDB(), input, (ExecutionContext)context, null, output, false);
    }

    @Test
    public void testCase3845() throws Exception {
        String input = "SELECT (DoubleNum * 1.0) FROM BQT1.Smalla";
        String output = "SELECT (SmallishA.DoubleNum * 1.0) FROM SmallishA";
        QueryMetadataInterface metadata = this.getOracleSpecificMetadata();
        this.helpTestVisitor(metadata, input, EMPTY_CONTEXT, null, output);
    }

    private QueryMetadataInterface getOracleSpecificMetadata() {
        MetadataStore metadataStore = new MetadataStore();
        Schema foo = RealMetadataFactory.createPhysicalModel((String)"BQT1", (MetadataStore)metadataStore);
        Table table = RealMetadataFactory.createPhysicalGroup((String)"SmallA", (Schema)foo);
        Table x = RealMetadataFactory.createPhysicalGroup((String)"x", (Schema)foo);
        x.setProperty("{http://www.teiid.org/ext/relational/2012}native-query", "select c from d");
        Table dual = RealMetadataFactory.createPhysicalGroup((String)"DUAL", (Schema)foo);
        table.setNameInSource("SmallishA");
        String[] elemNames = new String[]{"DoubleNum", "ID", "timestampvalue", "description", "ndescription"};
        String[] elemTypes = new String[]{"double", "integer", "timestamp", "string", "string"};
        RealMetadataFactory.createElements((ColumnSet)x, (String[])elemNames, (String[])elemTypes);
        List cols = RealMetadataFactory.createElements((ColumnSet)table, (String[])elemNames, (String[])elemTypes);
        ((Column)cols.get(1)).setAutoIncremented(true);
        ((Column)cols.get(1)).setNameInSource("ID:SEQUENCE=MYSEQUENCE.nextVal");
        ((Column)cols.get(2)).setNativeType("date");
        ((Column)cols.get(3)).setNativeType("CHAR");
        ((Column)cols.get(4)).setNativeType("NCHAR");
        List dualCols = RealMetadataFactory.createElements((ColumnSet)dual, (String[])new String[]{"something"}, (String[])new String[]{"string"});
        ((Column)dualCols.get(0)).setNameInSource("seq.nextval");
        ProcedureParameter in1 = RealMetadataFactory.createParameter((String)"in1", (int)1, (String)"integer");
        ColumnSet rs3 = RealMetadataFactory.createResultSet((String)"proc.rs1", (String[])new String[]{"e1"}, (String[])new String[]{"integer"});
        Procedure p = RealMetadataFactory.createStoredProcedure((String)"proc", (Schema)foo, Arrays.asList(in1));
        p.setResultSet(rs3);
        p.setProperty("{http://www.teiid.org/ext/relational/2012}native-query", "select x from y where z = $1");
        p = RealMetadataFactory.createStoredProcedure((String)"proc1", (Schema)foo, Arrays.asList(RealMetadataFactory.createParameter((String)"in1", (int)1, (String)"string")));
        p.setResultSet(RealMetadataFactory.createResultSet((String)"proc.rs1", (String[])new String[]{"e1"}, (String[])new String[]{"integer"}));
        p.setProperty("{http://www.teiid.org/ext/relational/2012}native-query", "select $1 from y");
        p.setProperty("{http://www.teiid.org/ext/relational/2012}non-prepared", "true");
        CompositeMetadataStore store = new CompositeMetadataStore(metadataStore);
        return new TransformationMetadata(null, store, null, RealMetadataFactory.SFM.getSystemFunctions(), null);
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) throws TranslatorException {
        this.helpTestVisitor(vdb, input, null, expectedOutput);
    }

    @Test
    public void testLimitWithNestedInlineView() throws Exception {
        String input = "select max(intkey), stringkey from (select intkey, stringkey from bqt1.smalla order by intkey limit 100) x group by stringkey";
        String output = "SELECT MAX(x.intkey), x.stringkey FROM (SELECT * FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA ORDER BY SmallA.IntKey) WHERE ROWNUM <= 100) x GROUP BY x.stringkey";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testOffsetWithNoLimit() throws Exception {
        String input = "select intkey, stringkey from bqt1.smalla order by intkey offset 100 rows";
        String output = "SELECT * FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA ORDER BY SmallA.IntKey) VIEW_FOR_LIMIT) WHERE ROWNUM_ > 100";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testLimitOffsetOverflow() throws Exception {
        String input = "select intkey, stringkey from bqt1.smalla order by intkey limit 2000000000, 2000000000";
        String output = "SELECT * FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA ORDER BY SmallA.IntKey) VIEW_FOR_LIMIT WHERE ROWNUM <= 4000000000) WHERE ROWNUM_ > 2000000000";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testExceptAsMinus() throws Exception {
        String input = "select intkey, intnum from bqt1.smalla except select intnum, intkey from bqt1.smallb";
        String output = "SELECT SmallA.IntKey, SmallA.IntNum FROM SmallA MINUS SELECT SmallB.IntNum, SmallB.IntKey FROM SmallB";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testConcat() throws Exception {
        String sql = "select concat(stringnum, stringkey) from BQT1.Smalla";
        String expected = "SELECT CASE WHEN SmallA.StringNum IS NULL OR SmallA.StringKey IS NULL THEN NULL ELSE concat(SmallA.StringNum, SmallA.StringKey) END FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }

    @Test
    public void testConcat_withLiteral() throws Exception {
        String sql = "select stringnum || '1' from BQT1.Smalla";
        String expected = "SELECT CASE WHEN SmallA.StringNum IS NULL THEN NULL ELSE concat(SmallA.StringNum, '1') END FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }

    @Test
    public void testRowLimitWithUnionOrderBy() throws Exception {
        String input = "(select intkey from bqt1.smalla limit 50, 100) union select intnum from bqt1.smalla order by intkey";
        String output = "(SELECT c_0 FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT g_1.IntKey AS c_0 FROM SmallA g_1) VIEW_FOR_LIMIT WHERE ROWNUM <= 150) WHERE ROWNUM_ > 50) UNION SELECT g_0.IntNum AS c_0 FROM SmallA g_0 ORDER BY c_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        this.helpTestVisitor(obj, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testCot() throws Exception {
        String sql = "select cot(doublenum) from BQT1.Smalla";
        String expected = "SELECT (1 / tan(SmallA.DoubleNum)) FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }

    @Test
    public void testLikeRegex() throws Exception {
        String input = "SELECT intkey FROM BQT1.SMALLA where stringkey like_regex 'ab.*c+' and stringkey not like_regex 'ab{3,5}c'";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE REGEXP_LIKE(SmallA.StringKey, 'ab.*c+') AND NOT(REGEXP_LIKE(SmallA.StringKey, 'ab{3,5}c'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testCallWithResultSet() throws Exception {
        String input = "call spTest5(1)";
        String output = "{?= call spTest5(?)}";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testCallWithoutResultSet() throws Exception {
        String input = "call sp_noreturn()";
        String output = "{call sp_noreturn()}";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testProcedureExecution() throws Exception {
        Command command = TranslationHelper.helpTranslate("/bqt.vdb", "call spTest8(1)");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CallableStatement cs = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.stub((Object)cs.getUpdateCount()).toReturn((Object)-1);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)cs.getObject(1)).toReturn((Object)rs);
        Mockito.stub((Object)cs.getInt(3)).toReturn((Object)4);
        Mockito.stub((Object)connection.prepareCall("{?= call spTest8(?,?)}")).toReturn((Object)cs);
        OracleExecutionFactory ef = new OracleExecutionFactory();
        JDBCProcedureExecution procedureExecution = new JDBCProcedureExecution(command, connection, (ExecutionContext)Mockito.mock(ExecutionContext.class), (JDBCExecutionFactory)ef);
        procedureExecution.execute();
        Assert.assertEquals(Arrays.asList(4), (Object)procedureExecution.getOutputParameterValues());
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, OracleExecutionFactory.CURSOR_TYPE);
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.times((int)1))).getObject(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNativeQueryWithNoCorrelationName() throws Exception {
        String input = "SELECT (DoubleNum * 1.0) FROM x";
        String output = "SELECT (x.DoubleNum * 1.0) FROM (select c from d) x";
        QueryMetadataInterface metadata = this.getOracleSpecificMetadata();
        this.helpTestVisitor(metadata, input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testNativeQuery() throws Exception {
        String input = "SELECT (DoubleNum * 1.0) FROM x as y";
        String output = "SELECT (y.DoubleNum * 1.0) FROM (select c from d) y";
        QueryMetadataInterface metadata = this.getOracleSpecificMetadata();
        this.helpTestVisitor(metadata, input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testNativeQueryProc() throws Exception {
        String input = "call proc(2)";
        String output = "select x from y where z = ?";
        QueryMetadataInterface metadata = this.getOracleSpecificMetadata();
        this.helpTestVisitor(metadata, input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testNativeQueryProcNonPrepared() throws Exception {
        String input = "call proc1('col')";
        String output = "select 'col' from y";
        QueryMetadataInterface metadata = this.getOracleSpecificMetadata();
        this.helpTestVisitor(metadata, input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testNativeQueryProcPreparedExecution() throws Exception {
        CommandBuilder commandBuilder = new CommandBuilder(this.getOracleSpecificMetadata());
        Command command = commandBuilder.getCommand("call proc(2)");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CallableStatement cs = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.stub((Object)cs.getUpdateCount()).toReturn((Object)-1);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)cs.getObject(1)).toReturn((Object)rs);
        Mockito.stub((Object)cs.getInt(3)).toReturn((Object)4);
        Mockito.stub((Object)connection.prepareCall("select x from y where z = ?")).toReturn((Object)cs);
        OracleExecutionFactory ef = new OracleExecutionFactory();
        JDBCProcedureExecution procedureExecution = new JDBCProcedureExecution(command, connection, (ExecutionContext)Mockito.mock(ExecutionContext.class), (JDBCExecutionFactory)ef);
        procedureExecution.execute();
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.never())).registerOutParameter(1, OracleExecutionFactory.CURSOR_TYPE);
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.never())).getObject(1);
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)2, 4);
    }

    @Test
    public void testCharType() throws Exception {
        CommandBuilder commandBuilder = new CommandBuilder(this.getOracleSpecificMetadata());
        Command command = commandBuilder.getCommand("select id from smalla where description = 'a' and ndescription in ('b', 'c')");
        for (Literal l : CollectorVisitor.collectObjects(Literal.class, (LanguageObject)command)) {
            l.setBindEligible(true);
        }
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)connection.prepareStatement("SELECT SmallishA.ID FROM SmallishA WHERE SmallishA.description = ? AND SmallishA.ndescription IN (?, ?)")).toReturn((Object)ps);
        OracleExecutionFactory ef = new OracleExecutionFactory();
        ef.start();
        JDBCQueryExecution e = new JDBCQueryExecution(command, connection, (ExecutionContext)new FakeExecutionContextImpl(), (JDBCExecutionFactory)ef);
        e.execute();
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)"a", OracleExecutionFactory.FIXED_CHAR_TYPE);
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).setObject(2, (Object)"b", OracleExecutionFactory.FIXED_CHAR_TYPE);
    }

    @Test
    public void testParseFormat() throws Exception {
        String input = "select parsetimestamp(smalla.timestampvalue, 'yyyy.MM.dd'), formattimestamp(smalla.timestampvalue, 'yy.MM.dd') from bqt1.smalla";
        String output = "SELECT TO_TIMESTAMP(to_char(cast(g_0.TimestampValue AS timestamp), 'YYYY-MM-DD HH24:MI:SS.FF'), 'YYYY.MM.DD'), TO_CHAR(g_0.TimestampValue, 'YY.MM.DD') FROM SmallA g_0";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Command obj = commandBuilder.getCommand(input, true, true);
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)this.TRANSLATOR, obj);
    }

    @Test
    public void testArrayComparison() throws Exception {
        String input = "select intkey from bqt1.smalla where intkey = 5";
        String output = "SELECT g_0.IntKey FROM SmallA g_0 WHERE (g_0.IntKey, g_0.IntKey) = ((5, 2))";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Select obj = (Select)commandBuilder.getCommand(input, true, true);
        Comparison comp = (Comparison)obj.getWhere();
        comp.setLeftExpression((Expression)new Array(comp.getLeftExpression().getType(), Arrays.asList(comp.getLeftExpression(), comp.getLeftExpression())));
        comp.setRightExpression((Expression)new Array(comp.getLeftExpression().getType(), Arrays.asList(comp.getRightExpression(), new Literal((Object)2, TypeFacility.RUNTIME_TYPES.INTEGER))));
        TranslationHelper.helpTestVisitor(output, (JDBCExecutionFactory)this.TRANSLATOR, (Command)obj);
    }

    @Test
    public void testWith() throws Exception {
        String input = "with a (col) as /*+ no_inline */ (select intkey from bqt1.smallb) select intkey, col from bqt1.smalla, a where intkey = 5";
        String output = "WITH a AS (SELECT SmallB.IntKey AS col FROM SmallB) SELECT SmallA.IntKey, a.col FROM SmallA, a WHERE SmallA.IntKey = 5";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testWithAndLimit() throws Exception {
        String input = "with a (col) as /*+ no_inline */ (select intkey from bqt1.smallb) select intkey, col from bqt1.smalla, a where intkey = 5 limit 10";
        String output = "WITH a AS (SELECT SmallB.IntKey AS col FROM SmallB) SELECT * FROM (SELECT SmallA.IntKey, a.col FROM SmallA, a WHERE SmallA.IntKey = 5) WHERE ROWNUM <= 10";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRecursiveCte() throws Exception {
        String input = "with a (intkey, lvl) as (select intkey, 0 as lvl from bqt1.smallb where intkey = 1 UNION ALL select n.intkey, rcte.lvl + 1 as lvl from bqt1.smallb n inner join a rcte on rcte.intkey = n.intkey + 1) select * from a";
        String output = "WITH a (intkey, lvl) AS (SELECT SmallB.IntKey, 0 AS lvl FROM SmallB WHERE SmallB.IntKey = 1 UNION ALL SELECT n.IntKey, (rcte.lvl + 1) AS lvl FROM SmallB n INNER JOIN a rcte ON rcte.intkey = (n.IntKey + 1)) SELECT a.intkey, a.lvl FROM a";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testVersionedCapabilities() throws Exception {
        OracleExecutionFactory oef = new OracleExecutionFactory();
        oef.setDatabaseVersion("10.0");
        oef.start();
        Assert.assertTrue((boolean)oef.supportsCommonTableExpressions());
    }

    @Test
    public void testSelectWithoutFrom() throws Exception {
        String input = "SELECT 1";
        String output = "SELECT 1 FROM DUAL";
        QueryMetadataInterface metadata = this.getOracleSpecificMetadata();
        this.helpTestVisitor(metadata, input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testSequenceFunction() throws Exception {
        String input = "SELECT seq.nextval()";
        String output = "SELECT seq.nextval FROM DUAL";
        String ddl = "create foreign function \"seq.nextval\" () returns integer OPTIONS (\"teiid_rel:native-query\" 'seq.nextval');";
        this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.fromDDL((String)ddl, (String)"x", (String)"y"), input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testCursorResult() throws Exception {
        String input = "call proc('foo')";
        String output = "{call proc(?,?)}";
        String ddl = "create foreign procedure proc (in x string, out y object options (native_type 'REF CURSOR')) returns table (a string);";
        Command command = this.helpTestVisitor((QueryMetadataInterface)RealMetadataFactory.fromDDL((String)ddl, (String)"x", (String)"y"), input, EMPTY_CONTEXT, null, output);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CallableStatement cs = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.stub((Object)cs.getUpdateCount()).toReturn((Object)-1);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)cs.getObject(2)).toReturn((Object)rs);
        Mockito.stub((Object)connection.prepareCall(output)).toReturn((Object)cs);
        OracleExecutionFactory ef = new OracleExecutionFactory();
        JDBCProcedureExecution procedureExecution = new JDBCProcedureExecution(command, connection, (ExecutionContext)Mockito.mock(ExecutionContext.class), (JDBCExecutionFactory)ef);
        procedureExecution.execute();
        Assert.assertEquals(Arrays.asList(rs), (Object)procedureExecution.getOutputParameterValues());
        ((CallableStatement)Mockito.verify((Object)cs, (VerificationMode)Mockito.times((int)1))).registerOutParameter(2, OracleExecutionFactory.CURSOR_TYPE);
    }

    @Test
    public void testDependentJoin() throws Exception {
        CommandBuilder commandBuilder = new CommandBuilder(this.getOracleSpecificMetadata());
        Select command = (Select)commandBuilder.getCommand("select id from smalla where description = 'a'");
        Parameter param = new Parameter();
        param.setType(TypeFacility.RUNTIME_TYPES.STRING);
        param.setDependentValueId("x");
        param.setValueIndex(0);
        HashMap<String, List<List>> dependentValues = new HashMap<String, List<List>>();
        dependentValues.put("x", Arrays.asList(Arrays.asList("a"), Arrays.asList("b")));
        command.setDependentValues(dependentValues);
        ((Comparison)command.getWhere()).setRightExpression((Expression)param);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.stub((Object)connection.createStatement()).toReturn((Object)statement);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)ps.executeBatch()).toReturn((Object)new int[]{-2, -2});
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO TEIID_DKJ1 (COL1) VALUES (?)")).toReturn((Object)ps);
        PreparedStatement ps1 = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)connection.prepareStatement("SELECT SmallishA.ID FROM TEIID_DKJ1, SmallishA WHERE SmallishA.description = TEIID_DKJ1.COL1")).toReturn((Object)ps1);
        OracleExecutionFactory ef = new OracleExecutionFactory(){

            public String getTemporaryTableName(String prefix) {
                return prefix;
            }
        };
        ef.setDatabaseVersion(Version.DEFAULT_VERSION);
        ef.start();
        JDBCQueryExecution e = new JDBCQueryExecution((Command)command, connection, (ExecutionContext)new FakeExecutionContextImpl(), (JDBCExecutionFactory)ef);
        e.execute();
        ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).execute("DECLARE PRAGMA AUTONOMOUS_TRANSACTION; BEGIN EXECUTE IMMEDIATE 'create global temporary table TEIID_DKJ1 (COL1 varchar2(100 char)) on commit delete rows; END;");
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)"a", 12);
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)"b", 12);
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    public void testTempTable() throws Exception {
        Assert.assertEquals((Object)"DECLARE PRAGMA AUTONOMOUS_TRANSACTION; BEGIN EXECUTE IMMEDIATE 'create global temporary table foo (COL1 number(10,0), COL2 varchar2(100 char)) on commit delete rows; END;", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)this.TRANSLATOR, true));
        Assert.assertEquals((Object)"create global temporary table foo (COL1 number(10,0), COL2 varchar2(100 char)) ON COMMIT PRESERVE ROWS", (Object)TranslationHelper.helpTestTempTable((JDBCExecutionFactory)this.TRANSLATOR, false));
    }

    @Test
    public void testGeometrySelectConvert() throws Exception {
        String input = "select shape x from cola_markets";
        String output = "SELECT SDO_UTIL.TO_GMLGEOMETRY(COLA_MARKETS.SHAPE) AS x FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryDistance() throws Exception {
        String input = "select ST_Distance(shape, shape) from cola_markets";
        String output = "SELECT SDO_GEOM.SDO_DISTANCE(COLA_MARKETS.SHAPE, COLA_MARKETS.SHAPE, 0.005) FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryDisjoint() throws Exception {
        String input = "select ST_Disjoint(shape, shape) from cola_markets";
        String output = "SELECT CASE SDO_GEOM.RELATE(COLA_MARKETS.SHAPE, 'disjoint', COLA_MARKETS.SHAPE, 0.005) WHEN 'DISJOINT' THEN 'TRUE' ELSE 'FALSE' END FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryIntersects() throws Exception {
        String input = "select ST_Intersects(shape, shape) from cola_markets";
        String output = "SELECT SDO_ANYINTERACT(COLA_MARKETS.SHAPE, COLA_MARKETS.SHAPE) FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryComparison() throws Exception {
        String input = "select shape from cola_markets where ST_Contains(shape, shape) and NOT ST_Intersects(shape, shape)";
        String output = "SELECT SDO_UTIL.TO_GMLGEOMETRY(COLA_MARKETS.SHAPE) FROM COLA_MARKETS WHERE SDO_CONTAINS(COLA_MARKETS.SHAPE, COLA_MARKETS.SHAPE) = 'TRUE' AND SDO_ANYINTERACT(COLA_MARKETS.SHAPE, COLA_MARKETS.SHAPE) <> 'TRUE'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryInsert() throws Exception {
        String input = "insert into cola_markets(name,shape) values('foo124', ST_GeomFromText('POINT (300 100)', 8307))";
        String output = "INSERT INTO COLA_MARKETS (NAME, SHAPE) VALUES ('foo124', SDO_GEOMETRY(TO_BLOB(?), 8307))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryInsertNull() throws Exception {
        String input = "insert into cola_markets(name,shape) values('foo124', null)";
        String output = "INSERT INTO COLA_MARKETS (NAME, SHAPE) VALUES ('foo124', ?)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testSrid() throws Exception {
        String input = "select st_srid(shape) from cola_markets c";
        String output = "SELECT nvl(c.SHAPE.sdo_srid, 0) FROM COLA_MARKETS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testGeometryInsertQueryExpression() throws Exception {
        String input = "insert into cola_markets select * from cola_markets";
        String output = "INSERT INTO COLA_MARKETS (MKT_ID, NAME, SHAPE, GEOG_SHAPE) SELECT COLA_MARKETS.MKT_ID, COLA_MARKETS.NAME, COLA_MARKETS.SHAPE, COLA_MARKETS.GEOG_SHAPE FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testVarbinaryComparison() throws Exception {
        String input = "select bin_col from binary_test where bin_col = x'ab'";
        String output = "SELECT binary_test.BIN_COL FROM binary_test WHERE binary_test.BIN_COL = HEXTORAW('AB')";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testVarbinaryInsert() throws Exception {
        String input = "insert into binary_test (bin_col) values (x'bc')";
        String output = "INSERT INTO binary_test (BIN_COL) VALUES (HEXTORAW('BC'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testPackageQualified() throws Exception {
        OracleMetadataProcessor omp = new OracleMetadataProcessor();
        omp.setQuoteString("\"");
        String val = omp.getFullyQualifiedName("package", "schema", "proc", true);
        Assert.assertEquals((Object)"\"schema\".\"package\".\"proc\"", (Object)val);
        val = omp.getFullyQualifiedName("", "schema", "proc", true);
        Assert.assertEquals((Object)"\"schema\".\"proc\"", (Object)val);
        omp.setUseQualifiedName(false);
        val = omp.getFullyQualifiedName("package", "schema", "proc", true);
        Assert.assertEquals((Object)"\"package\".\"proc\"", (Object)val);
    }

    @Test
    public void testBooleanInGroupByAndHaving() throws Exception {
        String input = "SELECT g_0.IntKey, cast(g_0.IntNum as boolean) FROM BQT1.SmallA AS g_0 GROUP BY g_0.IntKey, cast(g_0.IntNum as boolean) HAVING CONVERT(cast(g_0.IntNum as boolean), STRING) > 'false'";
        String output = "SELECT g_0.IntKey, CASE WHEN g_0.IntNum = 0 THEN 0 WHEN g_0.IntNum IS NOT NULL THEN 1 END FROM SmallA g_0 GROUP BY g_0.IntKey, CASE WHEN g_0.IntNum = 0 THEN 0 WHEN g_0.IntNum IS NOT NULL THEN 1 END HAVING CASE WHEN CASE WHEN g_0.IntNum = 0 THEN 0 WHEN g_0.IntNum IS NOT NULL THEN 1 END = 0 THEN 'false' WHEN CASE WHEN g_0.IntNum = 0 THEN 0 WHEN g_0.IntNum IS NOT NULL THEN 1 END IS NOT NULL THEN 'true' END > 'false'";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testTrunc() throws Exception {
        String input = "SELECT trunc(IntNum, 10), trunc(IntNum), trunc(TIMESTAMPVALUE, 'day') FROM BQT1.SmallA";
        String output = "SELECT TRUNC(SmallA.IntNum, 10), TRUNC(SmallA.IntNum), TRUNC(SmallA.TimestampValue, 'day') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testListAgg() throws Exception {
        this.TRANSLATOR.setDatabaseVersion("12.0");
        this.TRANSLATOR.initCapabilities(null);
        String input = "SELECT listagg(stringkey) within group (order by intkey), oracle.listagg(stringkey, ';' order by intkey), oracle.listagg(stringkey) FROM BQT1.SmallA";
        String output = "SELECT LISTAGG(SmallA.StringKey, '') WITHIN GROUP (ORDER BY SmallA.IntKey), LISTAGG(SmallA.StringKey, ';') WITHIN GROUP (ORDER BY SmallA.IntKey), LISTAGG(SmallA.StringKey) WITHIN GROUP (ORDER BY 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testRand() throws Exception {
        String input = "SELECT rand() FROM BQT1.SmallA";
        String output = "SELECT DBMS_RANDOM.VALUE() FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)this.TRANSLATOR);
    }

    @Test
    public void testUnicodeLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_name like N'\u65e5\u672c\u8a9e\u306e\u30ad\u30fc\u30dc\u30fc\u30c9_'", null, "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_NAME LIKE N'\u65e5\u672c\u8a9e\u306e\u30ad\u30fc\u30dc\u30fc\u30c9_'");
    }

    @Test
    public void testUnicodeCase() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select case when part_name = 'a' then N'\u65e5\u672c\u8a9e\u306e\u30ad\u30fc\u30dc\u30fc\u30c9' else part_name end from parts", null, "SELECT CASE WHEN PARTS.PART_NAME = 'a' THEN N'\u65e5\u672c\u8a9e\u306e\u30ad\u30fc\u30dc\u30fc\u30c9' ELSE TO_NCHAR(PARTS.PART_NAME) END FROM PARTS");
    }

    @Test
    public void testUnicodeUnion() throws Exception {
        String input = "select part_name from parts union all select 'a' from parts";
        String output = "SELECT parts.part_name FROM parts UNION ALL SELECT TO_NCHAR('a') FROM parts";
        String ddl = "create foreign table parts (a_name string, part_name string options (native_type 'nvarchar'));";
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)ddl, (String)"x", (String)"y");
        this.helpTestVisitor((QueryMetadataInterface)tm, input, EMPTY_CONTEXT, null, output);
    }

    @Test
    public void testTimestampAdd() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_second, 1, now())", null, "SELECT now() + (INTERVAL '1' SECOND(1)) FROM DUAL");
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_quarter, -2, now())", null, "SELECT now() + (INTERVAL '-6' MONTH(1)) FROM DUAL");
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_week, 1000, now())", null, "SELECT now() + (INTERVAL '7000' DAY(4)) FROM DUAL");
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_frac_second, 1, now())", null, "SELECT now() + (INTERVAL '0.000000001' SECOND(1)) FROM DUAL");
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_frac_second, 123456789, now())", null, "SELECT now() + (INTERVAL '0.123456789' SECOND(1)) FROM DUAL");
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_month, 123, now())", null, "SELECT ADD_MONTHS(now(), 123) FROM DUAL");
        this.helpTestVisitor(this.getTestVDB(), "select timestampadd(sql_tsi_year, -10, now())", null, "SELECT ADD_MONTHS(now(), -120) FROM DUAL");
    }

    @Test
    public void testUnicodeInsertToVarchar() throws Exception {
        String sql = "insert into char_test values ('\u0100')";
        String ddl = "create foreign table char_test (name string options (native_type 'varchar'));";
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)ddl, (String)"x", (String)"y");
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)tm);
        Command command = commandBuilder.getCommand(sql);
        for (Literal l : CollectorVisitor.collectObjects(Literal.class, (LanguageObject)command)) {
            l.setBindEligible(true);
        }
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.stub((Object)ps.executeUpdate()).toReturn((Object)1);
        Mockito.stub((Object)connection.prepareStatement("INSERT INTO char_test (name) VALUES (?)")).toReturn((Object)ps);
        OracleExecutionFactory ef = new OracleExecutionFactory();
        ef.start();
        ExecutionContext executionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)executionContext.getCommandContext()).toReturn(Mockito.mock(CommandContext.class));
        JDBCUpdateExecution update = new JDBCUpdateExecution(command, connection, executionContext, (JDBCExecutionFactory)ef);
        update.execute();
        ((PreparedStatement)Mockito.verify((Object)ps, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)"\u0100", 12);
    }
}

