/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.types.GeographyType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.Literal;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.util.Version;

public class TestJDBCExecutionFactory {
    @Test
    public void testDatabaseCalender() throws Exception {
        final JDBCExecutionFactory jef = new JDBCExecutionFactory();
        jef.setDatabaseTimeZone("GMT");
        jef.start();
        final Calendar[] cals = new Calendar[2];
        Thread t1 = new Thread(){

            @Override
            public void run() {
                cals[0] = jef.getDatabaseCalendar();
            }
        };
        t1.start();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                cals[1] = jef.getDatabaseCalendar();
            }
        };
        t2.start();
        t1.join();
        t2.join();
        Assert.assertNotSame((Object)cals[0], (Object)cals[1]);
    }

    @Test
    public void testVersion() {
        JDBCExecutionFactory jef = new JDBCExecutionFactory();
        jef.setDatabaseVersion("Some db 1.2.3 (some build)");
        Assert.assertEquals((Object)"1.2.3", (Object)jef.getDatabaseVersion().toString());
        Assert.assertEquals((Object)new Version(new Integer[]{1, 2, 3}), (Object)jef.getVersion());
        Version version = Version.getVersion((String)"10.0");
        Assert.assertTrue((version.compareTo(Version.getVersion((String)"9.1")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((version.compareTo(Version.getVersion((String)"10.0.1")) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStructRetrival() throws SQLException {
        JDBCExecutionFactory jef = new JDBCExecutionFactory();
        jef.setStructRetrieval(JDBCExecutionFactory.StructRetrieval.ARRAY);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Struct s = (Struct)Mockito.mock(Struct.class);
        Mockito.stub((Object)rs.getObject(1)).toReturn((Object)s);
        Assert.assertTrue((boolean)(jef.retrieveValue(rs, 1, TypeFacility.RUNTIME_TYPES.OBJECT) instanceof Array));
    }

    @Test
    public void testBooleanRetrival() throws SQLException {
        JDBCExecutionFactory jef = new JDBCExecutionFactory();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)rs.getBoolean(1)).toReturn((Object)false);
        Mockito.stub((Object)rs.wasNull()).toReturn((Object)true);
        Assert.assertNull((Object)jef.retrieveValue(rs, 1, TypeFacility.RUNTIME_TYPES.BOOLEAN));
    }

    @Test
    public void testLiteralWithDatabaseTimezone() throws TranslatorException {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT"));
        try {
            JDBCExecutionFactory jef = new JDBCExecutionFactory();
            jef.setDatabaseTimeZone("GMT+1");
            jef.start();
            Assert.assertEquals((Object)"2015-02-03 05:00:00.0", (Object)jef.formatDateValue((Date)TimestampUtil.createTimestamp((int)115, (int)1, (int)3, (int)4, (int)0, (int)0, (int)0)));
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testInitCaps() throws Exception {
        JDBCExecutionFactory jef = new JDBCExecutionFactory();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData mock = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.stub((Object)connection.getMetaData()).toReturn((Object)mock);
        Mockito.stub((Object)mock.supportsGetGeneratedKeys()).toThrow((Throwable)new SQLException());
        jef.initCapabilities(connection);
    }

    @Test
    public void testRemovePushdownCharacters() throws SQLException {
        JDBCExecutionFactory jef = new JDBCExecutionFactory();
        jef.setRemovePushdownCharacters("[\\u0000-\\u0002]");
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        jef.bindValue(ps, (Object)"\u0000Hello\u0001World", TypeFacility.RUNTIME_TYPES.STRING, 1);
        ((PreparedStatement)Mockito.verify((Object)ps)).setObject(1, (Object)"HelloWorld", 12);
        SQLConversionVisitor scv = new SQLConversionVisitor(jef);
        StringBuilder sb = new StringBuilder();
        scv.translateSQLType(TypeFacility.RUNTIME_TYPES.STRING, (Object)"\u0003?\u0002", sb);
        Assert.assertEquals((Object)"'\u0003?'", (Object)sb.toString());
    }

    @Test
    public void testBindNChar() throws SQLException {
        JDBCExecutionFactory jef = new JDBCExecutionFactory(){

            public boolean useUnicodePrefix() {
                return true;
            }
        };
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        jef.bindValue(ps, (Object)"Hello\u0128World", TypeFacility.RUNTIME_TYPES.STRING, 1);
        ((PreparedStatement)Mockito.verify((Object)ps)).setObject(1, (Object)"Hello\u0128World", -9);
    }

    @Test
    public void testGeospatialLiterals() throws Exception {
        JDBCExecutionFactory jef = new JDBCExecutionFactory();
        List result = jef.translateGeometryLiteral(new Literal((Object)new GeometryType(), TypeFacility.RUNTIME_TYPES.GEOMETRY));
        Assert.assertTrue((boolean)result.get(0).toString().startsWith("st_geom"));
        GeographyType value = new GeographyType();
        result = jef.translateGeographyLiteral(new Literal((Object)value, TypeFacility.RUNTIME_TYPES.GEOGRAPHY));
        Assert.assertTrue((boolean)result.get(0).toString().startsWith("st_geog"));
        value.setSrid(4333);
        result = jef.translateGeographyLiteral(new Literal((Object)value, TypeFacility.RUNTIME_TYPES.GEOGRAPHY));
        Assert.assertTrue((boolean)result.get(0).toString().startsWith("st_setsrid(st_geog"));
        Assert.assertTrue((boolean)result.get(0).toString().endsWith("4333)"));
    }
}

