/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.mysql;

import java.sql.Blob;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.GeometryType;
import org.teiid.query.function.GeometryUtils;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.mysql.MySQLExecutionFactory;

public class TestMySQLTranslator {
    private static MySQLExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void oneTimeSetup() throws TranslatorException {
        TRANSLATOR = new MySQLExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.start();
    }

    private String getTestVDB() {
        return "/PartsSupplierJDBC.vdb";
    }

    private String getTestBQTVDB() {
        return "/bqt.vdb";
    }

    @Test
    public void testConversion1() throws Exception {
        String input = "SELECT char(convert(PART_WEIGHT, integer) + 100) FROM PARTS";
        String output = "SELECT char((cast(PARTS.PART_WEIGHT AS signed) + 100)) FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion2() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, long) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS signed) FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion3() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, long), string) FROM PARTS";
        String output = "SELECT cast(cast(PARTS.PART_WEIGHT AS signed) AS char) FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion4() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, date), string) FROM PARTS";
        String output = "SELECT date_format(DATE(PARTS.PART_WEIGHT), '%Y-%m-%d') FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion5() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, time), string) FROM PARTS";
        String output = "SELECT date_format(TIME(PARTS.PART_WEIGHT), '%H:%i:%S') FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion6() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), string) FROM PARTS";
        String output = "SELECT date_format(TIMESTAMP(PARTS.PART_WEIGHT), '%Y-%m-%d %H:%i:%S.%f') FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion8() throws Exception {
        String input = "SELECT ifnull(PART_WEIGHT, 'otherString') FROM PARTS";
        String output = "SELECT ifnull(PARTS.PART_WEIGHT, 'otherString') FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion7() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, integer), string) FROM PARTS";
        String output = "SELECT cast(cast(PARTS.PART_WEIGHT AS signed) AS char) FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testInsert() throws Exception {
        String input = "SELECT insert(PART_WEIGHT, 1, 5, 'chimp') FROM PARTS";
        String output = "SELECT insert(PARTS.PART_WEIGHT, 1, 5, 'chimp') FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate() throws Exception {
        String input = "SELECT locate(INTNUM, 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT LOCATE(cast(SmallA.IntNum AS char), 'chimp', 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate2() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp') FROM BQT1.SMALLA";
        String output = "SELECT LOCATE(SmallA.StringNum, 'chimp') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate3() throws Exception {
        String input = "SELECT locate(INTNUM, '234567890', 1) FROM BQT1.SMALLA WHERE INTKEY = 26";
        String output = "SELECT LOCATE(cast(SmallA.IntNum AS char), '234567890', 1) FROM SmallA WHERE SmallA.IntKey = 26";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate4() throws Exception {
        String input = "SELECT locate('c', 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT 1 FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate5() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', -5) FROM BQT1.SMALLA";
        String output = "SELECT LOCATE(SmallA.StringNum, 'chimp', 1) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate6() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', INTNUM) FROM BQT1.SMALLA";
        String output = "SELECT LOCATE(SmallA.StringNum, 'chimp', CASE WHEN SmallA.IntNum < 1 THEN 1 ELSE SmallA.IntNum END) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate7() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', LOCATE(STRINGNUM, 'chimp') + 1) FROM BQT1.SMALLA";
        String output = "SELECT LOCATE(SmallA.StringNum, 'chimp', CASE WHEN (LOCATE(SmallA.StringNum, 'chimp') + 1) < 1 THEN 1 ELSE (LOCATE(SmallA.StringNum, 'chimp') + 1) END) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSubstring1() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 1) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT, 1) FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSubstring2() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 1, 5) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT, 1, 5) FROM PARTS";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testUnionWithOrderBy() throws Exception {
        String input = "SELECT PART_ID FROM PARTS UNION SELECT PART_ID FROM PARTS ORDER BY PART_ID";
        String output = "(SELECT PARTS.PART_ID FROM PARTS) UNION (SELECT PARTS.PART_ID FROM PARTS) ORDER BY PART_ID";
        TranslationHelper.helpTestVisitor(this.getTestVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testRowLimit2() throws Exception {
        String input = "select intkey from bqt1.smalla limit 100";
        String output = "SELECT SmallA.IntKey FROM SmallA LIMIT 100";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testRowLimit3() throws Exception {
        String input = "select intkey from bqt1.smalla limit 50, 100";
        String output = "SELECT SmallA.IntKey FROM SmallA LIMIT 50, 100";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBitAnd() throws Exception {
        String input = "select bitand(intkey, intnum) from bqt1.smalla";
        String output = "SELECT cast((SmallA.IntKey & SmallA.IntNum) AS signed) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testJoins() throws Exception {
        String input = "select smalla.intkey from bqt1.smalla inner join bqt1.smallb on smalla.stringkey=smallb.stringkey cross join bqt1.mediuma";
        String output = "SELECT SmallA.IntKey FROM (SmallA INNER JOIN SmallB ON SmallA.StringKey = SmallB.StringKey) CROSS JOIN MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampLiteral() throws Exception {
        String input = "select smalla.intkey from bqt1.smalla where smalla.timestampvalue = '2009-08-06 12:23:34.999'";
        String output = "SELECT SmallA.IntKey FROM SmallA WHERE SmallA.TimestampValue = {ts '2009-08-06 12:23:34.0'}";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        String input = "select convert(smalla.datevalue, timestamp) from bqt1.smalla";
        String output = "SELECT cast(SmallA.DateValue AS datetime) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testWeek() throws Exception {
        String input = "select week(smalla.datevalue) from bqt1.smalla";
        String output = "SELECT WEEKOFYEAR(SmallA.DateValue) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testPad() throws Exception {
        String input = "select lpad(smalla.stringkey, 18), rpad(smalla.stringkey, 12) from bqt1.smalla";
        String output = "SELECT lpad(SmallA.StringKey, 18, ' '), rpad(SmallA.StringKey, 12, ' ') FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testChar() throws Exception {
        String input = "SELECT intkey, CHR(CONVERT(bigintegervalue, integer)) FROM BQT1.MediumA";
        String output = "SELECT MediumA.IntKey, char(cast(MediumA.BigIntegerValue AS signed)) FROM MediumA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBooleanToString() throws Exception {
        String input = "SELECT convert(INTKEY, boolean) FROM BQT1.SmallA";
        String output = "SELECT CASE WHEN SmallA.IntKey = 0 THEN 0 WHEN SmallA.IntKey IS NOT NULL THEN 1 END FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testThreeUnionBranches() throws Exception {
        String input = "select part_id id FROM parts UNION ALL select part_name FROM parts UNION ALL select part_id FROM parts ORDER BY id";
        String output = "(SELECT PARTS.PART_ID AS id FROM PARTS) UNION ALL (SELECT PARTS.PART_NAME FROM PARTS) UNION ALL (SELECT PARTS.PART_ID FROM PARTS) ORDER BY id";
        TranslationHelper.helpTestVisitor("/PartsSupplierJDBC.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Ignore(value="There's no good workaround for this case on mysql 4 and for 5 can be done with a suquery, but only if the first union branch has no parens...")
    @Test
    public void testNestedSetQuery() throws Exception {
        String input = "select part_id id FROM parts UNION ALL (select part_name FROM parts UNION select part_id FROM parts)";
        String output = "";
        TranslationHelper.helpTestVisitor("/PartsSupplierJDBC.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testGeometrySelectConvert() throws Exception {
        String input = "select shape from cola_markets";
        String output = "SELECT COLA_MARKETS.SHAPE FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testMysqlGeometryRead() throws Exception {
        MySQLExecutionFactory msef = new MySQLExecutionFactory();
        msef.start();
        GeometryType gt = msef.toGeometryType((Blob)BlobType.createBlob((byte[])new byte[]{1, 2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16, 63, 0, 0, 0, 0, 0, 0, -16, 63}));
        Assert.assertEquals((long)513L, (long)gt.getSrid());
        GeometryUtils.getGeometry((AbstractGeospatialType)gt);
    }

    @Test
    public void testStringUnion() throws Exception {
        String input = "select intkey FROM bqt1.smalla UNION select stringkey FROM bqt1.smallb";
        String output = "(SELECT SmallA.IntKey AS IntKey FROM SmallA) UNION (SELECT SmallB.StringKey FROM SmallB)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
        input = "select cast(intkey as string) FROM bqt1.smalla UNION select cast(intnum as string) FROM bqt1.smallb";
        output = "(SELECT cast(SmallA.IntKey AS char) FROM SmallA) UNION (SELECT cast(SmallB.IntNum AS char) FROM SmallB)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testBigDecimalConversion() throws Exception {
        String input = "SELECT cast(stringkey as bigdecimal) * 2 FROM bqt1.smalla";
        String output = "SELECT ((SmallA.StringKey + 0.0) * 2) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

