/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.translator.jdbc.oracle.OracleFormatFunctionModifier;

public class TestFormatFunctionModifier {
    OracleFormatFunctionModifier offm = new OracleFormatFunctionModifier("TO_CHAR(", false);

    public void helpTest(String expected, String format) {
        Assert.assertTrue((boolean)this.offm.supportsLiteral(format));
        Assert.assertEquals((Object)expected, (Object)this.offm.translateFormat(format));
    }

    @Test
    public void testQuoting() {
        this.helpTest("'\"a\"\"123\"'", "'a'123");
        this.helpTest("'\"a''\"\"123\"'", "'a'''123");
    }

    @Test
    public void testParseHour() {
        OracleFormatFunctionModifier offmFormat = new OracleFormatFunctionModifier("TO_TIMESTAMP(", true);
        String format = "hh:mm:ss";
        String expected = "'HH24:MI:SS'";
        Assert.assertTrue((boolean)offmFormat.supportsLiteral(format));
        Assert.assertEquals((Object)expected, (Object)offmFormat.translateFormat(format));
    }

    @Test
    public void testDay() {
        this.helpTest("'DD DDD'", "dd DD");
    }

    @Test
    public void testYear() {
        this.helpTest("'YYYY YY YYYY YYYY'", "y yy yyy yyyy");
    }

    @Test
    public void testMonth() {
        this.helpTest("'MM Mon Month'", "MM MMM MMMM");
    }

    @Test
    public void testEra() {
        this.helpTest("'AD'", "GG");
    }

    @Test
    public void testAmPm() {
        this.helpTest("'AM'", "aa");
    }

    @Test
    public void testISO() {
        this.helpTest("'YYYY-MM-DD\"T\"HH24:MI:SS.FF3'", "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)this.offm.supportsLiteral("MMM"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("yyyyy"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("h"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("H"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("M"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("\""));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("'"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("x"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("-ax"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("k"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("F MMM-dd-yyyy G"));
        Assert.assertFalse((boolean)this.offm.supportsLiteral("MMM-dd-yyyy G u "));
    }
}

