/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.oracle.OracleExecutionFactory;

public class TestSubstringFunctionModifier
extends TestCase {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public TestSubstringFunctionModifier(String name) {
        super(name);
    }

    public void helpTestMod(Expression[] args, String expectedStr) throws Exception {
        Function func = LANG_FACTORY.createFunction("substring", Arrays.asList(args), TypeFacility.RUNTIME_TYPES.STRING);
        OracleExecutionFactory trans = new OracleExecutionFactory();
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        TestSubstringFunctionModifier.assertEquals((String)expectedStr, (String)sqlVisitor.toString());
    }

    public void testTwoArgs() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a.b.c", String.class), LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class)};
        this.helpTestMod(args, "substr('a.b.c', 1)");
    }

    public void testThreeArgsWithConstant() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a.b.c", String.class), LANG_FACTORY.createLiteral((Object)new Integer(3), Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class)};
        this.helpTestMod(args, "substr('a.b.c', 3, 1)");
    }

    public void testThreeArgsWithElement() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a.b.c", String.class), LANG_FACTORY.createColumnReference("e1", null, null, Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(1), Integer.class)};
        this.helpTestMod(args, "substr('a.b.c', e1, 1)");
    }

    public void testThreeArgsWithNull() throws Exception {
        Expression[] args = new Expression[]{LANG_FACTORY.createLiteral((Object)"a.b.c", String.class), LANG_FACTORY.createLiteral(null, Integer.class), LANG_FACTORY.createLiteral((Object)new Integer(5), Integer.class)};
        this.helpTestMod(args, "substr('a.b.c', NULL, 5)");
    }
}

