/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.actian;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Function;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;

@Translator(name="actian-vector", description="A translator for Actian Vector in Hadoop")
public class ActianVectorInHadoopExecutionFactory
extends JDBCExecutionFactory {
    public static final String ACTIAN = "actian";

    @Override
    public void start() throws TranslatorException {
        super.start();
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("CHAR(1)", 1);
        convertModifier.addTypeMapping("VARCHAR", 0);
        convertModifier.addTypeMapping("NVARCHAR", 0);
        convertModifier.addTypeMapping("INTEGER1", 3);
        convertModifier.addTypeMapping("INTEGER2", 4);
        convertModifier.addTypeMapping("INTEGER4", 5);
        convertModifier.addTypeMapping("INTEGER8", 6);
        convertModifier.addTypeMapping("DECIMAL", 10);
        convertModifier.addTypeMapping("MONEY", 10);
        convertModifier.addTypeMapping("FLOAT", 9);
        convertModifier.addTypeMapping("FLOAT4", 8);
        convertModifier.addTypeMapping("ANSIDATE", 11);
        convertModifier.addTypeMapping("TIME WITHOUT TIME ZONE", 12);
        convertModifier.addTypeMapping("TIME WITH TIME ZONE", 12);
        convertModifier.addTypeMapping("TIME WITH LOCAL TIME ZONE", 12);
        convertModifier.addTypeMapping("TIMESTAMP WITHOUT TIME ZONE", 13);
        convertModifier.addTypeMapping("TIMESTAMP WITH TIME ZONE", 13);
        convertModifier.addTypeMapping("TIMESTAMP WITH LOCAL TIME ZONE", 13);
        this.registerFunctionModifier("convert", convertModifier);
        this.registerFunctionModifier("char", new AliasModifier("CHR"));
        this.registerFunctionModifier("lcase", new AliasModifier("LOWERCASE"));
        this.registerFunctionModifier("ucase", new AliasModifier("UPPERCASE"));
        this.registerFunctionModifier("ceiling", new AliasModifier("CEIL"));
        this.registerFunctionModifier("nullif", new AliasModifier("NVL"));
        this.registerFunctionModifier("curdate", new Constant("CURRENT_DATE"));
        this.registerFunctionModifier("curtime", new Constant("CURRENT_TIME"));
        this.registerFunctionModifier("rand", new AliasModifier("RANDOM"));
        this.registerFunctionModifier("CURRENT_TIMESTAMP", new Constant());
        this.registerFunctionModifier("CURRENT_USER", new Constant());
        this.registerFunctionModifier("INITIAL_USER", new Constant());
        this.registerFunctionModifier("LOCAL_TIME", new Constant());
        this.registerFunctionModifier("LOCAL_TIMESTAMP", new Constant());
        this.registerFunctionModifier("SESSION_USER", new Constant());
        this.registerFunctionModifier("SYSTEM_USER", new Constant());
        this.registerFunctionModifier("USER", new Constant());
        this.addPushDownFunction(ACTIAN, "CHAREXTRACT", "char", new String[]{"string", "integer"});
        this.addPushDownFunction(ACTIAN, "SHIFT", "string", new String[]{"string", "integer"});
        this.addPushDownFunction(ACTIAN, "SIZE", "integer", new String[]{"string"});
        this.addPushDownFunction(ACTIAN, "SOUNDEX", "string", new String[]{"string"});
        this.addPushDownFunction(ACTIAN, "SQUEEZE", "string", new String[]{"string"});
        this.addPushDownFunction(ACTIAN, "TRUNC", "bigdecimal", new String[]{"bigdecimal", "integer"});
        this.addPushDownFunction(ACTIAN, "DAY", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "DAY", "integer", new String[]{"date"});
        this.addPushDownFunction(ACTIAN, "CURRENT_TIMESTAMP", "timestamp", new String[0]);
        this.addPushDownFunction(ACTIAN, "CURRENT_USER", "string", new String[0]);
        this.addPushDownFunction(ACTIAN, "INITIAL_USER", "string", new String[0]);
        this.addPushDownFunction(ACTIAN, "LOCAL_TIME", "time", new String[0]);
        this.addPushDownFunction(ACTIAN, "LOCAL_TIMESTAMP", "timestamp", new String[0]);
        this.addPushDownFunction(ACTIAN, "SESSION_USER", "string", new String[0]);
        this.addPushDownFunction(ACTIAN, "SYSTEM_USER", "string", new String[0]);
        this.addPushDownFunction(ACTIAN, "USER", "string", new String[0]);
        this.addPushDownFunction(ACTIAN, "ADD_MONTHS", "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(ACTIAN, "DATE_FORMAT", "string", new String[]{"timestamp", "string"});
        this.addPushDownFunction(ACTIAN, "DATE_PART", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "DATE_TRUNC", "timestamp", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "DAY", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "DAYOFMONTH", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "DAYOFWEEK", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "DAYOFYEAR", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "FROM_UNIXTIME", "timestamp", new String[]{"integer"});
        this.addPushDownFunction(ACTIAN, "HOUR", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "LASTDAY", "timestamp", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "MICROSECOND", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "MILLISECOND", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "MINUTE", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "MONTH", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "MONTHS_BETWEEN", "float", new String[]{"timestamp", "date", "date"});
        this.addPushDownFunction(ACTIAN, "MONTHS_BETWEEN", "float", new String[]{"timestamp", "timestamp", "timestamp"});
        this.addPushDownFunction(ACTIAN, "NANOSECOND", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "QUATER", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "SECOND", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "WEEK", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "YEAR", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "YEAR_WEEK", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "UNIX_TIMESTAMP", "integer", new String[]{"timestamp"});
        this.addPushDownFunction(ACTIAN, "WEEK_ISO", "integer", new String[]{"timestamp"});
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("convert");
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("initcap");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lcase");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("rand");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("now");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("nullif");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsOrderByWithExtendedGrouping() {
        return true;
    }

    public boolean supportsGroupByRollup() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    @Override
    public boolean supportsSetQueryOrderBy() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return true;
    }

    public boolean supportsSubqueryCommonTableExpressions() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return true;
    }

    public boolean supportsWindowOrderByWithAggregates() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public boolean supportsSelectExpression() {
        return true;
    }

    static class Constant
    extends FunctionModifier {
        private String name;

        public Constant() {
        }

        public Constant(String name) {
            this.name = name;
        }

        @Override
        public List<?> translate(Function function) {
            if (this.name != null) {
                function.setName(this.name);
            }
            return Arrays.asList(function.getName());
        }
    }
}

