/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.ingres;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.ingres.IngresExecutionFactory;

public class TestIngresConvertModifier {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();

    public String helpGetString(Expression expr) throws Exception {
        IngresExecutionFactory trans = new IngresExecutionFactory();
        trans.start();
        SQLConversionVisitor sqlVisitor = trans.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)this.helpGetString((Expression)func));
    }

    @Test
    public void testStringToChar() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)"5", String.class), "char", "cast('5' AS char(1))");
    }

    @Test
    public void testBooleanToBigDecimal() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)Boolean.TRUE, Boolean.class), "bigdecimal", "1");
    }

    @Test
    public void testByteToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "string", "cast(1 AS varchar(4000))");
    }

    @Test
    public void testByteToBoolean() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Byte(1), Byte.class), "boolean", "CASE WHEN 1 = 0 THEN 0 WHEN 1 IS NOT NULL THEN 1 END");
    }

    @Test
    public void testBigIntegerToDouble() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigInteger("1"), BigInteger.class), "double", "1");
    }

    @Test
    public void testFloatToLong() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Float(1.2f), Float.class), "long", "cast(1.2 AS bigint)");
    }

    @Test
    public void testDoubleToShort() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new Double(1.2), Double.class), "short", "cast(1.2 AS smallint)");
    }

    @Test
    public void testBigDecimalToByte() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)new BigDecimal("1.0"), BigDecimal.class), "byte", "cast(1.0 AS tinyint)");
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createDate((int)103, (int)10, (int)1), Date.class), "timestamp", "cast(DATE '2003-11-01' AS timestamp)");
    }

    @Test
    public void testTimeToString() throws Exception {
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)TimestampUtil.createTime((int)23, (int)59, (int)59), Time.class), "string", "cast(TIME '23:59:59' AS varchar(4000))");
    }

    @Test
    public void testTimestampToString() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)10, (int)1, (int)12, (int)5, (int)2, (int)0);
        this.helpTest((Expression)LANG_FACTORY.createLiteral((Object)ts, Timestamp.class), "string", "cast(TIMESTAMP '2003-11-01 12:05:02.0' AS varchar(4000))");
    }
}

