/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.postgresql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.GeometryInputSource;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.JsonType;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.logging.LogManager;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.ExtractFunctionModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.oracle.LeftOrRightFunctionModifier;
import org.teiid.translator.jdbc.oracle.MonthOrDayNameFunctionModifier;
import org.teiid.translator.jdbc.oracle.OracleFormatFunctionModifier;
import org.teiid.translator.jdbc.postgresql.LocateFunctionModifier;
import org.teiid.translator.jdbc.postgresql.PostgreSQLConversionVisitor;
import org.teiid.translator.jdbc.postgresql.PostgreSQLMetadataProcessor;
import org.teiid.util.Version;

@Translator(name="postgresql", description="A translator for postgreSQL Database")
public class PostgreSQLExecutionFactory
extends JDBCExecutionFactory {
    public static String POSTGRESQL = "postgresql";
    static final String UUID_TYPE = "uuid";
    private static final String INTEGER_TYPE = "integer";
    public static final Version EIGHT_0 = Version.getVersion((String)"8.0");
    public static final Version EIGHT_1 = Version.getVersion((String)"8.1");
    public static final Version EIGHT_2 = Version.getVersion((String)"8.2");
    public static final Version EIGHT_3 = Version.getVersion((String)"8.3");
    public static final Version EIGHT_4 = Version.getVersion((String)"8.4");
    public static final Version NINE_0 = Version.getVersion((String)"9.0");
    public static final Version NINE_3 = Version.getVersion((String)"9.3");
    public static final Version NINE_4 = Version.getVersion((String)"9.4");
    protected OracleFormatFunctionModifier parseModifier = new PostgreSQLFormatFunctionModifier("TO_TIMESTAMP(", true);
    public static final Version ONE_3 = Version.getVersion((String)"1.3");
    public static final Version ONE_4 = Version.getVersion((String)"1.4");
    public static final Version ONE_5 = Version.getVersion((String)"1.5");
    public static final Version TWO_0 = Version.getVersion((String)"2.0");
    private Version postGisVersion = Version.DEFAULT_VERSION;
    private boolean projSupported = false;
    protected ConvertModifier convertModifier;

    public PostgreSQLExecutionFactory() {
        this.setMaxDependentInPredicates(1);
        this.setMaxInCriteriaSize(32717);
    }

    public Object convertToken(String group) {
        switch (group.charAt(0)) {
            case 'Z': {
                return "TZ";
            }
            case 'S': {
                if (group.length() > 3) {
                    return "US";
                }
                return "MS";
            }
        }
        return null;
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("log", new AliasModifier("ln"));
        this.registerFunctionModifier("log10", new AliasModifier("log"));
        this.registerFunctionModifier("bitand", new AliasModifier("&"));
        this.registerFunctionModifier("bitnot", new AliasModifier("~"));
        this.registerFunctionModifier("bitor", new AliasModifier("|"));
        this.registerFunctionModifier("bitxor", new AliasModifier("#"));
        this.registerFunctionModifier("char", new AliasModifier("chr"));
        this.registerFunctionModifier("concat", new AliasModifier("||"));
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("substring", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<String> parts = new ArrayList<String>();
                parts.add("substring(");
                parts.add((String)function.getParameters().get(0));
                parts.add(" from ");
                Expression index = (Expression)function.getParameters().get(1);
                if (!(index instanceof Literal)) {
                    parts.add("case sign(");
                    parts.add((String)index);
                    parts.add(") when -1 then length(");
                    parts.add((String)function.getParameters().get(0));
                    parts.add(") + 1 + ");
                    parts.add((String)index);
                    parts.add(" when 0 then 1 else ");
                    parts.add((String)index);
                    parts.add(" end");
                } else {
                    parts.add((String)index);
                }
                if (function.getParameters().size() > 2) {
                    parts.add(" for ");
                    parts.add((String)function.getParameters().get(2));
                }
                parts.add(")");
                return parts;
            }
        });
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("dayname", new MonthOrDayNameFunctionModifier(this.getLanguageFactory(), "Day"));
        this.registerFunctionModifier("dayofweek", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("dayofmonth", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("dayofyear", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("hour", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("minute", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("month", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("monthname", new MonthOrDayNameFunctionModifier(this.getLanguageFactory(), "Month"));
        this.registerFunctionModifier("quarter", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("second", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("week", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("year", new ExtractFunctionModifier(INTEGER_TYPE));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("ifnull", new AliasModifier("coalesce"));
        this.registerFunctionModifier("parsetimestamp", this.parseModifier);
        this.registerFunctionModifier("formattimestamp", new PostgreSQLFormatFunctionModifier("TO_CHAR(", false));
        this.registerFunctionModifier("mod", new ModFunctionModifier("%", this.getLanguageFactory(), Arrays.asList(TypeFacility.RUNTIME_TYPES.BIG_INTEGER, TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)));
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier());
        this.registerFunctionModifier("rand", new AliasModifier("random"));
        this.registerFunctionModifier("array_get", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), Character.valueOf('['), function.getParameters().get(1), Character.valueOf(']'));
            }
        });
        this.registerFunctionModifier("array_length", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (function.getParameters().size() == 1) {
                    function.getParameters().add(new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER));
                }
                return null;
            }
        });
        this.registerFunctionModifier("round", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression ex;
                if (function.getParameters().size() > 1 && ((ex = (Expression)function.getParameters().get(0)).getType() == TypeFacility.RUNTIME_TYPES.DOUBLE || ex.getType() == TypeFacility.RUNTIME_TYPES.FLOAT)) {
                    if (function.getParameters().get(1) instanceof Literal && Integer.valueOf(0).equals(((Literal)function.getParameters().get(1)).getValue())) {
                        function.getParameters().remove(1);
                    } else {
                        function.getParameters().set(0, new Function("convert", Arrays.asList(ex, new Literal((Object)"bigdecimal", TypeFacility.RUNTIME_TYPES.STRING)), TypeFacility.RUNTIME_TYPES.BIG_DECIMAL));
                    }
                }
                return null;
            }
        });
        this.convertModifier = new ConvertModifier();
        this.convertModifier.addTypeMapping("boolean", 2);
        this.convertModifier.addTypeMapping("smallint", 3, 4);
        this.convertModifier.addTypeMapping(INTEGER_TYPE, 5);
        this.convertModifier.addTypeMapping("bigint", 6);
        this.convertModifier.addTypeMapping("real", 8);
        this.convertModifier.addTypeMapping("float8", 9);
        this.convertModifier.addTypeMapping("numeric(38)", 7);
        this.convertModifier.addTypeMapping("decimal", 10);
        this.convertModifier.addTypeMapping("char(1)", 1);
        this.convertModifier.addTypeMapping("varchar(4000)", 0);
        this.convertModifier.addTypeMapping("date", 11);
        this.convertModifier.addTypeMapping("time", 12);
        this.convertModifier.addTypeMapping("timestamp", 13);
        this.convertModifier.addTypeMapping("geography", 21);
        this.convertModifier.addTypeMapping("geometry", 20);
        this.convertModifier.addTypeMapping("json", 22);
        this.convertModifier.addConvert(10, 2, new NonIntegralNumberToBoolean());
        this.convertModifier.addConvert(8, 2, new NonIntegralNumberToBoolean());
        this.convertModifier.addConvert(10, 2, new NonIntegralNumberToBoolean());
        this.convertModifier.addConvert(12, 13, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), " + TIMESTAMP '1970-01-01'");
            }
        });
        this.convertModifier.addConvert(13, 12, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(date_trunc('second', ", function.getParameters().get(0), ") AS time)");
            }
        });
        this.convertModifier.addConvert(11, 0, new ConvertModifier.FormatModifier("to_char", "YYYY-MM-DD"));
        this.convertModifier.addConvert(12, 0, new ConvertModifier.FormatModifier("to_char", "HH24:MI:SS"));
        this.convertModifier.addConvert(13, 0, new ConvertModifier.FormatModifier("to_char", "YYYY-MM-DD HH24:MI:SS.US"));
        this.convertModifier.addConvert(2, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression stringValue = (Expression)function.getParameters().get(0);
                return Arrays.asList("CASE WHEN ", stringValue, " THEN 'true' WHEN not(", stringValue, ") THEN 'false' END");
            }
        });
        this.convertModifier.addSourceConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ((Literal)function.getParameters().get(1)).setValue((Object)PostgreSQLExecutionFactory.INTEGER_TYPE);
                return null;
            }
        }, 2);
        this.registerFunctionModifier("convert", this.convertModifier);
        this.addPushDownFunction(POSTGRESQL, "ilike", "boolean", new String[]{"string", "string"}).setProperty("teiid_rel:native-query", "($1 ilike $2)");
        this.addPushDownFunction(POSTGRESQL, "rlike", "boolean", new String[]{"string", "string"}).setProperty("teiid_rel:native-query", "($1 ~ $2)");
        this.addPushDownFunction(POSTGRESQL, "iregexp", "boolean", new String[]{"string", "string"}).setProperty("teiid_rel:native-query", "($1 ~* $2)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.getVersion().compareTo(NINE_0) <= 0) {
            this.registerFunctionModifier("left", new LeftOrRightFunctionModifier(this.getLanguageFactory()));
        }
        if (this.postGisVersion.compareTo(Version.DEFAULT_VERSION) != 0 || connection == null) {
            return;
        }
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = s.executeQuery("SELECT 1 FROM pg_catalog.pg_proc where lower(proname) = 'postgis_full_version'");
            if (!rs.next()) {
                return;
            }
            rs.close();
            rs = s.executeQuery("SELECT PostGIS_Full_Version()");
            rs.next();
            String versionInfo = rs.getString(1);
            if (versionInfo != null) {
                int index;
                if (versionInfo.contains("PROJ=")) {
                    this.projSupported = true;
                }
                if ((index = versionInfo.indexOf("POSTGIS=")) > -1) {
                    String version = versionInfo.substring(index + 9, versionInfo.indexOf(34, index + 9));
                    this.setPostGisVersion(version);
                }
            }
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Could not determine PostGIS version");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(dateValue) + "'";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME '" + this.formatDateValue(timeValue) + "'";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP '" + this.formatDateValue(timestampValue) + "'";
    }

    @Override
    public int getTimestampNanoPrecision() {
        return 6;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("LIMIT ", limit.getRowLimit(), " OFFSET ", limit.getRowOffset());
        }
        return null;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (obj instanceof AggregateFunction) {
            AggregateFunction agg = (AggregateFunction)obj;
            if (agg.getParameters().size() == 1 && TypeFacility.RUNTIME_TYPES.BOOLEAN.equals(((Expression)agg.getParameters().get(0)).getType())) {
                if (agg.getName().equalsIgnoreCase("MIN")) {
                    agg.setName("bool_and");
                } else if (agg.getName().equalsIgnoreCase("MAX")) {
                    agg.setName("bool_or");
                }
            }
        } else if (obj instanceof Like) {
            Like like = (Like)obj;
            if (like.getMode() == Like.MatchMode.REGEX) {
                return Arrays.asList(like.getLeftExpression(), like.isNegated() ? " !~ " : " ~ ", like.getRightExpression());
            }
            if (like.getEscapeCharacter() == null) {
                return PostgreSQLExecutionFactory.addDefaultEscape(like);
            }
        }
        return super.translate(obj, context);
    }

    public static List<Object> addDefaultEscape(Like like) {
        return Arrays.asList(like.getLeftExpression(), like.isNegated() ? " NOT " : " ", like.getMode() == Like.MatchMode.LIKE ? "LIKE " : "SIMILAR TO ", like.getRightExpression(), " ESCAPE ''");
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.HIGH;
    }

    public boolean supportsOrderByNullOrdering() {
        return this.getVersion().compareTo(EIGHT_4) >= 0;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("BITAND");
        supportedFunctions.add("BITNOT");
        supportedFunctions.add("BITOR");
        supportedFunctions.add("BITXOR");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("ROUND");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ascii");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("||");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("INITCAP");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("rand");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("REPLACE");
        if (this.getVersion().compareTo(NINE_0) > 0) {
            supportedFunctions.add("RIGHT");
        }
        supportedFunctions.add("RPAD");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("trim");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("SECOND");
        if (this.getVersion().compareTo(EIGHT_2) >= 0) {
            supportedFunctions.add("TIMESTAMPADD");
        }
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("COALESCE");
        supportedFunctions.add("array_get");
        supportedFunctions.add("array_length");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("parsetimestamp");
        if (this.postGisVersion.compareTo(ONE_3) >= 0) {
            supportedFunctions.add("st_asbinary");
            supportedFunctions.add("st_astext");
            supportedFunctions.add("st_contains");
            supportedFunctions.add("st_crosses");
            supportedFunctions.add("st_disjoint");
            supportedFunctions.add("st_distance");
            supportedFunctions.add("st_equals");
            supportedFunctions.add("st_geomfromtext");
            supportedFunctions.add("st_geomfromwkb");
            supportedFunctions.add("st_intersects");
            supportedFunctions.add("st_overlaps");
            supportedFunctions.add("st_setsrid");
            supportedFunctions.add("st_srid");
            supportedFunctions.add("st_touches");
            supportedFunctions.add("st_hasarc");
            supportedFunctions.add("st_simplify");
            supportedFunctions.add("st_force_2d");
            supportedFunctions.add("st_envelope");
            supportedFunctions.add("st_within");
            supportedFunctions.add("st_dwithin");
            supportedFunctions.add("st_extent");
            supportedFunctions.add("&&");
            supportedFunctions.add("st_geomfromewkt");
            supportedFunctions.add("st_geomfromewkb");
            supportedFunctions.add("st_asewkb");
            supportedFunctions.add("st_asewkt");
            supportedFunctions.add("st_area");
            supportedFunctions.add("st_boundary");
            supportedFunctions.add("st_buffer");
            supportedFunctions.add("st_centroid");
            supportedFunctions.add("st_coorddim");
            supportedFunctions.add("st_convexhull");
            supportedFunctions.add("st_difference");
            supportedFunctions.add("st_dimension");
            supportedFunctions.add("st_endpoint");
            supportedFunctions.add("st_exteriorring");
            supportedFunctions.add("st_geometryn");
            supportedFunctions.add("st_geometrytype");
            supportedFunctions.add("st_intersection");
            supportedFunctions.add("st_interiorringn");
            supportedFunctions.add("st_isclosed");
            supportedFunctions.add("st_isempty");
            supportedFunctions.add("st_isring");
            supportedFunctions.add("st_issimple");
            supportedFunctions.add("st_isvalid");
            supportedFunctions.add("st_length");
            supportedFunctions.add("st_numgeometries");
            supportedFunctions.add("st_numinteriorrings");
            supportedFunctions.add("st_numpoints");
            supportedFunctions.add("st_orderingequals");
            supportedFunctions.add("st_perimeter");
            supportedFunctions.add("st_point");
            supportedFunctions.add("st_pointn");
            supportedFunctions.add("st_pointonsurface");
            supportedFunctions.add("st_polygon");
            supportedFunctions.add("st_relate");
            supportedFunctions.add("st_startpoint");
            supportedFunctions.add("st_symdifference");
            supportedFunctions.add("st_union");
            supportedFunctions.add("st_x");
            supportedFunctions.add("st_y");
            supportedFunctions.add("st_snaptogrid");
            supportedFunctions.add("st_simplifypreservetopology");
        }
        if (this.postGisVersion.compareTo(ONE_4) >= 0) {
            supportedFunctions.add("st_asgeojson");
            supportedFunctions.add("st_asgml");
            supportedFunctions.add("st_curvetoline");
            supportedFunctions.add("st_z");
        }
        if (this.postGisVersion.compareTo(ONE_5) >= 0) {
            supportedFunctions.add("st_geomfromgml");
            supportedFunctions.add("st_makeenvelope");
        }
        if (this.postGisVersion.compareTo(TWO_0) >= 0) {
            supportedFunctions.add("st_geomfromgeojson");
        }
        if (this.projSupported) {
            supportedFunctions.add("st_transform");
            supportedFunctions.add("st_askml");
        }
        supportedFunctions.add("pg_catalog.encode");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.getVersion().compareTo(EIGHT_2) >= 0;
    }

    public boolean supportsCommonTableExpressions() {
        return this.getVersion().compareTo(EIGHT_4) >= 0;
    }

    public boolean supportsRecursiveCommonTableExpressions() {
        return this.supportsCommonTableExpressions();
    }

    public boolean supportsArrayAgg() {
        return false;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getVersion().compareTo(EIGHT_4) >= 0;
    }

    public boolean supportsAdvancedOlapOperations() {
        return this.getVersion().compareTo(NINE_4) >= 0;
    }

    public boolean supportsWindowDistinctAggregates() {
        return false;
    }

    public boolean supportsSimilarTo() {
        return true;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    public boolean supportsOnlyFormatLiterals() {
        return true;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (format == ExecutionFactory.Format.NUMBER) {
            return false;
        }
        return this.parseModifier.supportsLiteral(literal);
    }

    public boolean supportsArrayType() {
        return true;
    }

    public boolean supportsSelectExpressionArrayType() {
        return false;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsStringAgg() {
        return this.getVersion().compareTo(NINE_0) >= 0;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        if (this.getVersion().compareTo(EIGHT_2) >= 0) {
            return "org.hibernate.dialect.PostgreSQL82Dialect";
        }
        return "org.hibernate.dialect.PostgreSQL81Dialect";
    }

    @Override
    public String getCreateTemporaryTablePostfix(boolean inTransaction) {
        if (!inTransaction) {
            return "ON COMMIT PRESERVE ROWS";
        }
        return super.getCreateTemporaryTablePostfix(inTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadedTemporaryTable(String tableName, ExecutionContext context, Connection connection) throws SQLException {
        Statement s = connection.createStatement();
        try {
            s.execute("ANALYZE " + tableName);
        }
        finally {
            try {
                s.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new PostgreSQLConversionVisitor(this);
    }

    public void setPostGisVersion(String postGisVersion) {
        this.postGisVersion = Version.getVersion((String)postGisVersion);
    }

    @TranslatorProperty(display="PostGIS Version", description="The version of the PostGIS extension.", advanced=true)
    public String getPostGisVersion() {
        return this.postGisVersion.toString();
    }

    @TranslatorProperty(display="Proj support enabled", description="If PostGIS Proj support is enabled for ST_TRANSFORM", advanced=true)
    public boolean isProjSupported() {
        return this.projSupported;
    }

    public void setProjSupported(boolean projSupported) {
        this.projSupported = projSupported;
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new PostgreSQLMetadataProcessor();
    }

    @Override
    public Expression translateGeometrySelect(Expression expr) {
        return new Function("st_asewkb", Arrays.asList(expr), TypeFacility.RUNTIME_TYPES.VARBINARY);
    }

    @Override
    public Expression translateGeographySelect(Expression expr) {
        return new Function("st_asewkb", Arrays.asList(new Function("CAST", Arrays.asList(expr, new Literal((Object)"geometry", TypeFacility.RUNTIME_TYPES.STRING)), TypeFacility.RUNTIME_TYPES.GEOMETRY)), TypeFacility.RUNTIME_TYPES.VARBINARY);
    }

    @Override
    public Object retrieveGeometryValue(ResultSet results, int paramIndex) throws SQLException {
        final byte[] bytes = results.getBytes(paramIndex);
        if (bytes != null) {
            return new GeometryInputSource(){

                public InputStream getEwkb() throws Exception {
                    return new ByteArrayInputStream(bytes);
                }
            };
        }
        return null;
    }

    @Override
    public Object retrieveGeographyValue(ResultSet results, int paramIndex) throws SQLException {
        return this.retrieveGeometryValue(results, paramIndex);
    }

    @Override
    public boolean useStreamsForLobs() {
        return true;
    }

    @Override
    public String translateLiteralBinaryType(BinaryType obj) {
        return "E'\\\\x" + obj + '\'';
    }

    public boolean supportsLateralJoin() {
        return this.getVersion().compareTo(NINE_3) >= 0;
    }

    @Override
    public void bindValue(PreparedStatement stmt, Object param, Class<?> paramType, int i) throws SQLException {
        if (param == null && (paramType == TypeFacility.RUNTIME_TYPES.BLOB || paramType == TypeFacility.RUNTIME_TYPES.GEOMETRY || paramType == TypeFacility.RUNTIME_TYPES.GEOGRAPHY)) {
            paramType = TypeFacility.RUNTIME_TYPES.VARBINARY;
        } else if (param instanceof org.teiid.language.Array) {
            org.teiid.language.Array array = (org.teiid.language.Array)param;
            Connection c = stmt.getConnection();
            int code = ConvertModifier.getCode(array.getBaseType());
            String nativeType = this.convertModifier.getSimpleTypeMapping(code);
            int index = nativeType.indexOf(40);
            if (index > 0) {
                nativeType = nativeType.substring(0, index);
            }
            Object[] values = new Object[array.getExpressions().size()];
            for (int j = 0; j < values.length; ++j) {
                Expression ex = (Expression)array.getExpressions().get(j);
                values[j] = ((Literal)ex).getValue();
            }
            Array value = c.createArrayOf(nativeType, values);
            stmt.setArray(i, value);
            return;
        }
        super.bindValue(stmt, param, paramType, i);
    }

    public boolean supportsIsDistinctCriteria() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public boolean supportsGeographyType() {
        return this.postGisVersion.compareTo(ONE_5) >= 0;
    }

    @Override
    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        if (expectedType == TypeFacility.RUNTIME_TYPES.JSON) {
            return new JsonType((Clob)new ClobImpl(results.getString(parameterIndex)));
        }
        return super.retrieveValue(results, parameterIndex, expectedType);
    }

    @Override
    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        if (expectedType == TypeFacility.RUNTIME_TYPES.JSON) {
            return new JsonType((Clob)new ClobImpl(results.getString(columnIndex)));
        }
        return super.retrieveValue(results, columnIndex, expectedType);
    }

    public int getMaxProjectedColumns() {
        return 1600;
    }

    private final class PostgreSQLFormatFunctionModifier
    extends OracleFormatFunctionModifier {
        private PostgreSQLFormatFunctionModifier(String prefix, boolean parse) {
            super(prefix, parse);
        }

        @Override
        protected Object convertToken(String group) {
            Object result = PostgreSQLExecutionFactory.this.convertToken(group);
            if (result == null) {
                return super.convertToken(group);
            }
            return result;
        }
    }

    private static final class NonIntegralNumberToBoolean
    extends FunctionModifier {
        private NonIntegralNumberToBoolean() {
        }

        @Override
        public List<?> translate(Function function) {
            return Arrays.asList(function.getParameters().get(0), " <> 0");
        }
    }
}

