/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.dqp.internal.datamgr.FakeExecutionContextImpl;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;

public class TestJDBCDirectQueryExecution {
    @Test
    public void testSelectExecution() throws Exception {
        Command command = TranslationHelper.helpTranslate("/bqt.vdb", "call native('select * from Source')");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rsm = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)stmt.getUpdateCount()).toReturn((Object)-1);
        Mockito.stub((Object)stmt.getResultSet()).toReturn((Object)rs);
        Mockito.stub((Object)rs.getMetaData()).toReturn((Object)rsm);
        Mockito.stub((Object)rsm.getColumnCount()).toReturn((Object)2);
        Mockito.stub((Object)connection.createStatement()).toReturn((Object)stmt);
        Mockito.stub((Object)stmt.execute("select * from Source")).toReturn((Object)true);
        Mockito.stub((Object)rs.next()).toReturn((Object)true);
        Mockito.stub((Object)rs.getObject(1)).toReturn((Object)5);
        Mockito.stub((Object)rs.getObject(2)).toReturn((Object)"five");
        DatabaseMetaData dbmd = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.stub((Object)connection.getMetaData()).toReturn((Object)dbmd);
        JDBCExecutionFactory ef = new JDBCExecutionFactory();
        ef.setSupportsDirectQueryProcedure(true);
        ResultSetExecution execution = (ResultSetExecution)ef.createExecution(command, (ExecutionContext)Mockito.mock(ExecutionContext.class), (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), (Object)connection);
        execution.execute();
        Assert.assertArrayEquals((Object[])new Object[]{5, "five"}, (Object[])((Object[])execution.next().get(0)));
    }

    @Test
    public void testPrepareExecution() throws Exception {
        Command command = TranslationHelper.helpTranslate("/bqt.vdb", "call native('select * from Source where e1 = ?', 2)");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement stmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rsm = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)stmt.getUpdateCount()).toReturn((Object)-1);
        Mockito.stub((Object)stmt.getResultSet()).toReturn((Object)rs);
        Mockito.stub((Object)stmt.execute()).toReturn((Object)true);
        Mockito.stub((Object)rs.getMetaData()).toReturn((Object)rsm);
        Mockito.stub((Object)rsm.getColumnCount()).toReturn((Object)2);
        Mockito.stub((Object)connection.prepareStatement("select * from Source where e1 = ?")).toReturn((Object)stmt);
        Mockito.stub((Object)rs.next()).toReturn((Object)true);
        Mockito.stub((Object)rs.getObject(1)).toReturn((Object)5);
        Mockito.stub((Object)rs.getObject(2)).toReturn((Object)"five");
        DatabaseMetaData dbmd = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.stub((Object)connection.getMetaData()).toReturn((Object)dbmd);
        JDBCExecutionFactory ef = new JDBCExecutionFactory();
        ef.setSupportsDirectQueryProcedure(true);
        ResultSetExecution execution = (ResultSetExecution)ef.createExecution(command, (ExecutionContext)new FakeExecutionContextImpl(), (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), (Object)connection);
        execution.execute();
        ((PreparedStatement)Mockito.verify((Object)stmt)).setObject(1, 2);
        Assert.assertArrayEquals((Object[])new Object[]{5, "five"}, (Object[])((Object[])execution.next().get(0)));
    }

    @Test
    public void testPrepareUpdateCount() throws Exception {
        Command command = TranslationHelper.helpTranslate("/bqt.vdb", "call native('update source set e1=? where e2 = ?', 2, 'foo')");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement stmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData rsm = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.stub((Object)stmt.getUpdateCount()).toReturn((Object)-1);
        Mockito.stub((Object)stmt.getUpdateCount()).toReturn((Object)5);
        Mockito.stub((Object)stmt.execute()).toReturn((Object)false);
        Mockito.stub((Object)rs.getMetaData()).toReturn((Object)rsm);
        Mockito.stub((Object)rsm.getColumnCount()).toReturn((Object)2);
        Mockito.stub((Object)connection.prepareStatement("update source set e1=? where e2 = ?")).toReturn((Object)stmt);
        DatabaseMetaData dbmd = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.stub((Object)connection.getMetaData()).toReturn((Object)dbmd);
        JDBCExecutionFactory ef = new JDBCExecutionFactory();
        ef.setSupportsDirectQueryProcedure(true);
        ResultSetExecution execution = (ResultSetExecution)ef.createExecution(command, (ExecutionContext)new FakeExecutionContextImpl(), (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), (Object)connection);
        execution.execute();
        Assert.assertArrayEquals((Object[])new Object[]{5}, (Object[])((Object[])execution.next().get(0)));
    }
}

