/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.mockito.Mockito;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslatedCommand;

public class TranslationHelper {
    public static final String PARTS_VDB = "/PartsSupplierJDBC.vdb";
    public static final String BQT_VDB = "/bqt.vdb";

    public static Command helpTranslate(String vdbFileName, String sql) {
        return TranslationHelper.helpTranslate(vdbFileName, null, sql);
    }

    public static TranslationUtility getTranslationUtility(String vdbFileName) {
        TranslationUtility util = null;
        if (PARTS_VDB.equals(vdbFileName)) {
            util = new TranslationUtility("PartsSupplierJDBC.vdb", TranslationHelper.class.getResource(vdbFileName));
        } else if (BQT_VDB.equals(vdbFileName)) {
            util = FakeTranslationFactory.getInstance().getBQTTranslationUtility();
        } else {
            try {
                util = new TranslationUtility((QueryMetadataInterface)RealMetadataFactory.fromDDL((String)vdbFileName, (String)"vdb", (String)"test"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return util;
    }

    public static Command helpTranslate(String vdbFileName, List<FunctionMethod> pushdowns, String sql) {
        TranslationUtility util = TranslationHelper.getTranslationUtility(vdbFileName);
        if (pushdowns != null) {
            util.addUDF("SYS", pushdowns);
        }
        return util.parseCommand(sql);
    }

    public static TranslatedCommand helpTestVisitor(String vdb, String input, String expectedOutput, JDBCExecutionFactory translator) throws TranslatorException {
        Command obj = TranslationHelper.helpTranslate(vdb, translator.getPushDownFunctions(), input);
        return TranslationHelper.helpTestVisitor(expectedOutput, translator, obj);
    }

    public static TranslatedCommand helpTestVisitor(String expectedOutput, JDBCExecutionFactory translator, Command obj) throws TranslatorException {
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)Mockito.mock(ExecutionContext.class), translator);
        tc.translateCommand(obj);
        Assert.assertEquals((String)"Did not get correct sql", (Object)expectedOutput, (Object)tc.getSql());
        return tc;
    }

    public static String helpTestTempTable(JDBCExecutionFactory transaltor, boolean transactional) throws QueryMetadataException, TeiidComponentException {
        ArrayList<ColumnReference> cols = new ArrayList<ColumnReference>();
        cols.add(new ColumnReference(null, "COL1", RealMetadataFactory.exampleBQTCached().getElementID("BQT1.SMALLA.INTKEY"), TypeFacility.RUNTIME_TYPES.INTEGER));
        cols.add(new ColumnReference(null, "COL2", RealMetadataFactory.exampleBQTCached().getElementID("BQT1.SMALLA.STRINGKEY"), TypeFacility.RUNTIME_TYPES.STRING));
        return transaltor.getCreateTempTableSQL("foo", cols, transactional);
    }
}

