/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.netezza;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.netezza.NetezzaExecutionFactory;

public class TestNetezzaTranslatorDatetimeConversion {
    private static NetezzaExecutionFactory TRANSLATOR;
    private static final LanguageFactory LANG_FACTORY;

    @BeforeClass
    public static void oneTimeSetup() throws TranslatorException {
        TRANSLATOR = new NetezzaExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.start();
    }

    private String getTestBQTVDB() {
        return "/bqt.vdb";
    }

    public void helpTest(Expression srcExpression, String tgtType, String expectedExpression) throws Exception {
        Function func = LANG_FACTORY.createFunction("convert", Arrays.asList(srcExpression, LANG_FACTORY.createLiteral((Object)tgtType, String.class)), TypeFacility.getDataTypeClass((String)tgtType));
        Assert.assertEquals((String)("Error converting from " + srcExpression.getType() + " to " + tgtType), (Object)expectedExpression, (Object)this.helpGetString((Expression)func));
    }

    public String helpGetString(Expression expr) throws Exception {
        SQLConversionVisitor sqlVisitor = TRANSLATOR.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)expr);
        return sqlVisitor.toString();
    }

    @Test
    public void testdayofmonth() throws Exception {
        String input = "SELECT dayofmonth(datevalue) FROM BQT1.SMALLA";
        String output = "SELECT extract(DAY from SmallA.DateValue) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampToDate() throws Exception {
        String input = "SELECT convert(convert(TIMESTAMPVALUE, date), string) FROM BQT1.SMALLA";
        String output = "SELECT cast(cast(SmallA.TimestampValue AS DATE) AS varchar(4000)) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampToTime() throws Exception {
        String input = "SELECT convert(convert(TIMESTAMPVALUE, time), string) FROM BQT1.SMALLA";
        String output = "SELECT cast(cast(SmallA.TimestampValue AS TIME) AS varchar(4000)) FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimestampToString() throws Exception {
        String input = "SELECT convert(timestampvalue, string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(SmallA.TimestampValue, 'YYYY-MM-DD HH24:MI:SS.MS') FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        String input = "SELECT convert(convert(datevalue, timestamp), string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(cast(SmallA.DateValue AS TIMESTAMP), 'YYYY-MM-DD HH24:MI:SS.MS') FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimeToTimestamp() throws Exception {
        String input = "SELECT convert(convert(TIMEVALUE, timestamp), string) FROM BQT1.SMALLA";
        String output = "SELECT to_char(SmallA.TimeValue, 'YYYY-MM-DD HH24:MI:SS.MS') FROM SmallA";
        TranslationHelper.helpTestVisitor(this.getTestBQTVDB(), input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    static {
        LANG_FACTORY = new LanguageFactory();
    }
}

