/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.vertica;

import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.vertica.VerticaExecutionFactory;

public class TestVerticaTranslator {
    private static VerticaExecutionFactory translator;

    @BeforeClass
    public static void setupOnce() throws Exception {
        translator = new VerticaExecutionFactory();
        translator.start();
    }

    public String getBQT_VDB() {
        return "/bqt.vdb";
    }

    public String getPARTS_VDB() {
        return "/PartsSupplierJDBC.vdb";
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) throws TranslatorException {
        TranslationHelper.helpTestVisitor(vdb, input, expectedOutput, (JDBCExecutionFactory)translator);
    }

    @Test
    public void testConversion() throws TranslatorException {
        String input = "SELECT char(convert(PART_WEIGHT, integer) + 100) FROM PARTS";
        String output = "SELECT CHR((convert(PARTS.PART_WEIGHT, integer) + 100)) FROM PARTS";
        this.helpTestVisitor(this.getPARTS_VDB(), input, output);
        input = "SELECT curdate() FROM BQT1.MediumA";
        output = "SELECT CURRENT_DATE() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT curtime() FROM BQT1.MediumA";
        output = "SELECT CURRENT_TIME() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT week(datevalue) FROM BQT1.MediumA";
        output = "SELECT WEEK_ISO(MediumA.DateValue) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
    }

    @Test
    public void testPushDownFuctions() throws TranslatorException {
        String input = "SELECT vertica.BIT_LENGTH('abc') FROM BQT1.MediumA";
        String output = "SELECT BIT_LENGTH('abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.BITCOUNT(127) FROM BQT1.MediumA";
        output = "SELECT BITCOUNT(127) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.BITSTRING_TO_BINARY('abc') FROM BQT1.MediumA";
        output = "SELECT BITSTRING_TO_BINARY('abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.BTRIM('abc', 'abc') FROM BQT1.MediumA";
        output = "SELECT BTRIM('abc', 'abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.GREATEST(127) FROM BQT1.MediumA";
        output = "SELECT GREATEST(127) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.GREATESTB(127) FROM BQT1.MediumA";
        output = "SELECT GREATESTB(127) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.HEX_TO_BINARY('abc') FROM BQT1.MediumA";
        output = "SELECT HEX_TO_BINARY('abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.HEX_TO_INTEGER('127') FROM BQT1.MediumA";
        output = "SELECT HEX_TO_INTEGER('127') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.INITCAP('abc') FROM BQT1.MediumA";
        output = "SELECT INITCAP('abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.INSERT('abc', 1, 2, 'd') FROM BQT1.MediumA";
        output = "SELECT INSERT('abc', 1, 2, 'd') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.ISUTF8('abc') FROM BQT1.MediumA";
        output = "SELECT ISUTF8('abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.MD5('abc') FROM BQT1.MediumA";
        output = "SELECT MD5('abc') FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.SPACE(127) FROM BQT1.MediumA";
        output = "SELECT SPACE(127) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.TO_HEX(127) FROM BQT1.MediumA";
        output = "SELECT TO_HEX(127) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.CBRT(6.2) FROM BQT1.MediumA";
        output = "SELECT CBRT(6.2) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.LN(6.2) FROM BQT1.MediumA";
        output = "SELECT LN(6.2) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.PI() FROM BQT1.MediumA";
        output = "SELECT PI() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.RANDOM() FROM BQT1.MediumA";
        output = "SELECT RANDOM() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.TRUNC(6.2) FROM BQT1.MediumA";
        output = "SELECT TRUNC(6.2) FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.GETDATE() FROM BQT1.MediumA";
        output = "SELECT GETDATE() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.GETUTCDATE() FROM BQT1.MediumA";
        output = "SELECT GETUTCDATE() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.LOCALTIME() FROM BQT1.MediumA";
        output = "SELECT LOCALTIME() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT vertica.LOCALTIMESTAMP() FROM BQT1.MediumA";
        output = "SELECT LOCALTIMESTAMP() FROM MediumA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
    }

    @Test
    public void testMinMaxBoolean() throws TranslatorException {
        String input = "SELECT MIN(booleanvalue) FROM BQT1.SmallA";
        String output = "SELECT CAST(MIN(CAST(SmallA.BooleanValue AS tinyint)) AS boolean) FROM SmallA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
        input = "SELECT MAX(booleanvalue) FROM BQT1.SmallA";
        output = "SELECT CAST(MAX(CAST(SmallA.BooleanValue AS tinyint)) AS boolean) FROM SmallA";
        this.helpTestVisitor(this.getBQT_VDB(), input, output);
    }
}

