/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.BulkCommand;
import org.teiid.language.Command;
import org.teiid.language.Insert;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorBatchException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.JDBCBaseExecution;
import org.teiid.translator.jdbc.JDBCExecutionException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.TranslatedCommand;

public class JDBCUpdateExecution
extends JDBCBaseExecution
implements UpdateExecution {
    private int[] result;
    private int maxPreparedInsertBatchSize = this.executionFactory.getMaxPreparedInsertBatchSize();
    private boolean atomic = true;

    public JDBCUpdateExecution(Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory env) {
        super(command, connection, context, env);
    }

    public void execute() throws TranslatorException {
        if (this.command instanceof BatchedUpdates) {
            this.execute((BatchedUpdates)this.command);
        } else {
            TranslatedCommand translatedComm = this.translateCommand(this.command);
            this.executeTranslatedCommand(translatedComm);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] execute(BatchedUpdates batchedCommand) throws TranslatorException {
        boolean bl;
        boolean succeeded = false;
        boolean commitType = false;
        if (batchedCommand.isSingleResult()) {
            commitType = this.getAutoCommit(null);
        }
        Command[] commands = batchedCommand.getUpdateCommands().toArray(new Command[batchedCommand.getUpdateCommands().size()]);
        this.result = new int[commands.length];
        TranslatedCommand tCommand = null;
        int batchStart = 0;
        int i = 0;
        try {
            if (commitType) {
                this.connection.setAutoCommit(false);
            }
            ArrayList<TranslatedCommand> executedCmds = new ArrayList<TranslatedCommand>();
            TranslatedCommand previousCommand = null;
            while (i < commands.length) {
                tCommand = this.translateCommand(commands[i]);
                if (tCommand.isPrepared()) {
                    PreparedStatement pstmt = null;
                    if (previousCommand != null && previousCommand.isPrepared() && previousCommand.getSql().equals(tCommand.getSql())) {
                        pstmt = (PreparedStatement)this.statement;
                    } else {
                        if (!executedCmds.isEmpty()) {
                            this.executeBatch(i, this.result, executedCmds);
                            batchStart = i;
                        }
                        pstmt = this.getPreparedStatement(tCommand.getSql());
                    }
                    this.bind(pstmt, tCommand.getPreparedValues(), null);
                    pstmt.addBatch();
                } else {
                    if (previousCommand != null && previousCommand.isPrepared()) {
                        this.executeBatch(i, this.result, executedCmds);
                        batchStart = i;
                        this.getStatement();
                    }
                    if (this.statement == null) {
                        this.getStatement();
                    }
                    this.statement.addBatch(tCommand.getSql());
                }
                executedCmds.add(tCommand);
                previousCommand = tCommand;
                ++i;
            }
            if (!executedCmds.isEmpty()) {
                this.executeBatch(commands.length, this.result, executedCmds);
            }
            succeeded = true;
            if (!commitType) return this.result;
            bl = !succeeded;
        }
        catch (TranslatorException e) {
            try {
                if (batchedCommand.isSingleResult()) {
                    throw e;
                }
                int size = i + 1;
                if (!(e.getCause() instanceof BatchUpdateException)) {
                    size = batchStart;
                    throw new TranslatorBatchException((Throwable)e, Arrays.copyOf(this.result, size));
                }
                BatchUpdateException bue = (BatchUpdateException)e.getCause();
                int[] batchResults = bue.getUpdateCounts();
                int j = 0;
                while (true) {
                    if (j >= batchResults.length) {
                        size = batchStart + batchResults.length;
                        throw new TranslatorBatchException((Throwable)e, Arrays.copyOf(this.result, size));
                    }
                    this.result[batchStart + j] = batchResults[j];
                    ++j;
                }
                catch (SQLException e2) {
                    if (!batchedCommand.isSingleResult()) throw new TranslatorBatchException((Throwable)e2, Arrays.copyOf(this.result, batchStart));
                    throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11011, e2, tCommand);
                }
            }
            catch (Throwable throwable) {
                if (!commitType) throw throwable;
                this.restoreAutoCommit(!succeeded, null);
                throw throwable;
            }
        }
        this.restoreAutoCommit(bl, null);
        return this.result;
    }

    private void executeBatch(int commandCount, int[] results, List<TranslatedCommand> commands) throws TranslatorException {
        try {
            int[] batchResults = this.statement.executeBatch();
            this.addStatementWarnings();
            for (int j = 0; j < batchResults.length; ++j) {
                results[commandCount - 1 - j] = batchResults[batchResults.length - 1 - j];
            }
            commands.clear();
        }
        catch (SQLException err) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11012, err, commands.toArray(new TranslatedCommand[commands.size()]));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void executeTranslatedCommand(TranslatedCommand translatedComm) throws TranslatorException {
        sql = translatedComm.getSql();
        commitType = false;
        succeeded = false;
        try {
            updateCount = 0;
            keyColumnNames = null;
            if (this.command instanceof Insert && this.executionFactory.supportsGeneratedKeys(this.context, this.command) && (cols = this.context.getGeneratedKeyColumns()) != null) {
                keyColumnNames = this.context.returnGeneratedKeys().getColumnNames();
            }
            if (!translatedComm.isPrepared()) {
                this.statement = this.getStatement();
                updateCount = keyColumnNames != null ? (this.executionFactory.useColumnNamesForGeneratedKeys() ? this.statement.executeUpdate(sql, keyColumnNames) : this.statement.executeUpdate(sql, 1)) : this.statement.executeUpdate(sql);
                this.result = new int[]{updateCount};
                this.addStatementWarnings();
            } else {
                pstatement = null;
                if (this.statement != null) {
                    this.statement.close();
                }
                pstatement = keyColumnNames != null ? (this.executionFactory.useColumnNamesForGeneratedKeys() ? this.connection.prepareStatement(sql, keyColumnNames) : this.connection.prepareStatement(sql, 1)) : this.getPreparedStatement(sql);
                this.statement = pstatement;
                vi = null;
                if (this.command instanceof BulkCommand) {
                    batchCommand = (BulkCommand)this.command;
                    vi = batchCommand.getParameterValues();
                }
                k = 0;
                batchStart = 0;
                if (vi != null) {
                    try {
                        commitType = this.getAutoCommit(translatedComm);
                        if (commitType) {
                            this.connection.setAutoCommit(false);
                        }
                        maxBatchSize = this.command instanceof Insert != false ? this.maxPreparedInsertBatchSize : 0x7FFFFFFF;
                        done = false;
                        while (!done) {
                            for (i = 0; i < maxBatchSize; ++i) {
                                if (vi.hasNext()) {
                                    values = (List)vi.next();
                                    this.bind(pstatement, translatedComm.getPreparedValues(), values);
                                    ++k;
                                    continue;
                                }
                                if (i == 0) ** GOTO lbl69
                                done = true;
                                break;
                            }
                            results = pstatement.executeBatch();
                            batchStart = k;
                            if (this.result == null) {
                                this.result = results;
                                continue;
                            }
                            len = this.result.length;
                            this.result = Arrays.copyOf(this.result, len + results.length);
                            System.arraycopy(results, 0, this.result, len, results.length);
                        }
                    }
                    catch (SQLException e) {
                        size = k + 1;
                        this.result = this.result == null ? new int[size] : Arrays.copyOf(this.result, size);
                        if (e instanceof BatchUpdateException) {
                            bue = (BatchUpdateException)e;
                            batchResults = bue.getUpdateCounts();
                            for (j = 0; j < batchResults.length; ++j) {
                                this.result[batchStart + j] = batchResults[j];
                            }
                            size = batchStart + batchResults.length;
                        } else {
                            size = batchStart;
                        }
                        throw new TranslatorBatchException((Throwable)e, Arrays.copyOf(this.result, size));
                    }
                } else {
                    this.bind(pstatement, translatedComm.getPreparedValues(), null);
                    updateCount = pstatement.executeUpdate();
                    this.result = new int[]{updateCount};
                }
lbl69:
                // 3 sources

                this.addStatementWarnings();
                succeeded = true;
            }
            if (keyColumnNames != null) {
                try {
                    keys = this.statement.getGeneratedKeys();
                    generatedKeys = this.context.returnGeneratedKeys();
                    block11: while (keys.next()) {
                        vals = new ArrayList<Object>(keyColumnNames.length);
                        for (i = 0; i < keyColumnNames.length; ++i) {
                            javaType = generatedKeys.getColumnTypes()[i];
                            value = this.executionFactory.retrieveValue(keys, i + 1, javaType);
                            if (value != null && TypeFacility.getRuntimeType(value.getClass()) != javaType) {
                                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11023, new Object[]{javaType, keyColumnNames[i], value.getClass()}));
                                continue block11;
                            }
                            vals.add(value);
                        }
                        generatedKeys.addKey(vals);
                    }
                }
                catch (SQLException e) {
                    this.context.addWarning((Exception)e);
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Exception determining generated keys, no keys will be returned");
                }
            }
            if (commitType) {
                this.restoreAutoCommit(succeeded == false, translatedComm);
            }
        }
        catch (SQLException err) {
            try {
                throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11013, err, new TranslatedCommand[]{translatedComm});
            }
            catch (Throwable var16_28) {
                if (commitType) {
                    this.restoreAutoCommit(succeeded == false, translatedComm);
                }
                throw var16_28;
            }
        }
    }

    private boolean getAutoCommit(TranslatedCommand tCommand) throws TranslatorException {
        if (!this.atomic) {
            return false;
        }
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException err) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11014, err, tCommand);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreAutoCommit(boolean exceptionOccurred, TranslatedCommand tCommand) throws TranslatorException {
        try {
            if (exceptionOccurred) {
                this.connection.rollback();
            }
        }
        catch (SQLException err) {
            try {
                throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11015, err, tCommand);
            }
            catch (Throwable throwable) {
                try {
                    if (!exceptionOccurred) {
                        this.connection.commit();
                    }
                    this.connection.setAutoCommit(true);
                    throw throwable;
                }
                catch (SQLException err2) {
                    throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11016, err2, tCommand);
                }
            }
        }
        try {
            if (!exceptionOccurred) {
                this.connection.commit();
            }
            this.connection.setAutoCommit(true);
            return;
        }
        catch (SQLException err) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11016, err, tCommand);
        }
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return this.result;
    }

    public void setMaxPreparedInsertBatchSize(int maxPreparedInsertBatchSize) {
        this.maxPreparedInsertBatchSize = maxPreparedInsertBatchSize;
    }

    public void setAtomic(boolean atomic) {
        this.atomic = atomic;
    }
}

