/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.exasol;

import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.exasol.ExasolExecutionFactory;

public class TestExasolTranslator {
    private static ExasolExecutionFactory translator;

    @BeforeClass
    public static void setupOnce() throws Exception {
        translator = new ExasolExecutionFactory();
        translator.start();
    }

    public void helpTestVisitor(String input, String expectedOutput) throws TranslatorException {
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, expectedOutput, (JDBCExecutionFactory)translator);
    }

    @Test
    public void testConvertBooleanToDouble() throws TranslatorException {
        String input = "SELECT convert(BooleanValue, double) FROM BQT1.SmallA";
        String output = "SELECT cast(SmallA.BooleanValue as double precision) FROM SmallA";
        this.helpTestVisitor(input, output);
    }

    @Test
    public void testConvertBooleanToString() throws TranslatorException {
        String input = "SELECT convert(BooleanValue, byte) FROM BQT1.SmallA";
        String output = "SELECT cast(SmallA.BooleanValue as decimal(3)) FROM SmallA";
        this.helpTestVisitor(input, output);
    }
}

