/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.informix;

import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.informix.InformixExecutionFactory;

public class TestInformixExecutionFactory {
    private static InformixExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new InformixExecutionFactory();
        TRANSLATOR.start();
    }

    @Test
    public void testCast() throws Exception {
        String input = "SELECT cast(INTKEY as string), cast(stringkey as time), cast(stringkey as date), cast(stringkey as timestamp) FROM BQT1.SmallA";
        String output = "SELECT cast(SmallA.IntKey AS varchar(255)), cast(SmallA.StringKey AS datetime hour to second), cast(SmallA.StringKey AS date), cast(SmallA.StringKey AS datetime year to fraction(5)) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testTimeLiteral() throws Exception {
        String input = "SELECT {t '12:11:01'} FROM BQT1.SmallA";
        String output = "SELECT {t '12:11:01'} FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testMinMaxBoolean() throws Exception {
        String input = "SELECT min(booleanvalue), max(booleanvalue) FROM BQT1.SmallA";
        String output = "SELECT cast(MIN(cast(SmallA.BooleanValue as char)) as boolean), cast(MAX(cast(SmallA.BooleanValue as char)) as boolean) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }
}

