/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.hana;

import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslationHelper;
import org.teiid.translator.jdbc.hana.HanaExecutionFactory;
import org.teiid.util.Version;

public class TestHanaTranslator {
    private static HanaExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setupOnce() throws Exception {
        TRANSLATOR = new HanaExecutionFactory();
        TRANSLATOR.setUseBindVariables(false);
        TRANSLATOR.setDatabaseVersion(Version.DEFAULT_VERSION);
        TRANSLATOR.start();
    }

    public String getTestVDB() {
        return "/PartsSupplierJDBC.vdb";
    }

    private String getTestBQTVDB() {
        return "/bqt.vdb";
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) throws TranslatorException {
        TranslationHelper.helpTestVisitor(vdb, input, expectedOutput, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testConversion1() throws Exception {
        String input = "SELECT char(convert(PART_WEIGHT, integer) + 100) FROM PARTS";
        String output = "SELECT to_nvarchar((cast(PARTS.PART_WEIGHT AS integer) + 100)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion2() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, long) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS bigint) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion3() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, short) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS smallint) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion4() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, float) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS float) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion5() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, double) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS double) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion6() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, biginteger) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS bigint) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion7() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, bigdecimal) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS decimal) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion8() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, boolean) FROM PARTS";
        String output = "SELECT cast(PARTS.PART_WEIGHT AS boolean) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion8a() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, boolean), long) FROM PARTS";
        String output = "SELECT cast(cast(PARTS.PART_WEIGHT AS boolean) AS tinyint) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion9() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, date) FROM PARTS";
        String output = "SELECT to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion10() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, time) FROM PARTS";
        String output = "SELECT to_time(PARTS.PART_WEIGHT, 'HH24:MI:SS') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion11() throws Exception {
        String input = "SELECT convert(PART_WEIGHT, timestamp) FROM PARTS";
        String output = "SELECT to_timestamp(PARTS.PART_WEIGHT, 'YYYY-MM-DD HH24:MI:SS') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion12() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, time), string) FROM PARTS";
        String output = "SELECT cast(to_time(PARTS.PART_WEIGHT, 'HH24:MI:SS') AS nvarchar) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion13() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), string) FROM PARTS";
        String output = "SELECT cast(to_timestamp(PARTS.PART_WEIGHT, 'YYYY-MM-DD HH24:MI:SS') AS nvarchar) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion14() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, date), string) FROM PARTS";
        String output = "SELECT cast(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD') AS nvarchar) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion15() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), date) FROM PARTS";
        String output = "SELECT cast(to_timestamp(PARTS.PART_WEIGHT, 'YYYY-MM-DD HH24:MI:SS') AS date) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion16() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, timestamp), time) FROM PARTS";
        String output = "SELECT cast(to_timestamp(PARTS.PART_WEIGHT, 'YYYY-MM-DD HH24:MI:SS') AS time) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion17() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, time), timestamp) FROM PARTS";
        String output = "SELECT cast(to_time(PARTS.PART_WEIGHT, 'HH24:MI:SS') AS timestamp) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testConversion18() throws Exception {
        String input = "SELECT convert(convert(PART_WEIGHT, date), timestamp) FROM PARTS";
        String output = "SELECT cast(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD') AS timestamp) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testLog() throws Exception {
        String input = "SELECT log(convert(PART_WEIGHT, double)) FROM PARTS";
        String output = "SELECT log(10, cast(PARTS.PART_WEIGHT AS double)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
        input = "SELECT log10(convert(PART_WEIGHT, double)) FROM PARTS";
        output = "SELECT log(10, cast(PARTS.PART_WEIGHT AS double)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testLeft() throws Exception {
        String input = "SELECT left(PART_WEIGHT, 2) FROM PARTS";
        String output = "SELECT left(PARTS.PART_WEIGHT, 2) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testRight() throws Exception {
        String input = "SELECT right(PART_WEIGHT, 2) FROM PARTS";
        String output = "SELECT right(PARTS.PART_WEIGHT, 2) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfWeek() throws Exception {
        String input = "SELECT dayofweek(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT (MOD((WEEKDAY(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'))+1),7)+1) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfMonth() throws Exception {
        String input = "SELECT dayofmonth(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT dayofmonth(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayOfYear() throws Exception {
        String input = "SELECT dayofyear(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT dayofyear(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testHour() throws Exception {
        String input = "SELECT hour(convert(PART_WEIGHT, time)) FROM PARTS";
        String output = "SELECT hour(to_time(PARTS.PART_WEIGHT, 'HH24:MI:SS')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testMinute() throws Exception {
        String input = "SELECT minute(convert(PART_WEIGHT, time)) FROM PARTS";
        String output = "SELECT minute(to_time(PARTS.PART_WEIGHT, 'HH24:MI:SS')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testMonth() throws Exception {
        String input = "SELECT month(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT month(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testQuarter() throws Exception {
        String input = "SELECT quarter(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT ((month(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'))+2)/3) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSecond() throws Exception {
        String input = "SELECT second(convert(PART_WEIGHT, time)) FROM PARTS";
        String output = "SELECT second(to_time(PARTS.PART_WEIGHT, 'HH24:MI:SS')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testWeek() throws Exception {
        String input = "SELECT week(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT cast(substring(isoweek(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')), 7, 2) as integer) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testYear() throws Exception {
        String input = "SELECT year(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT year(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testDayName() throws Exception {
        String input = "SELECT dayname(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT initcap(lower(dayname(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')))) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testMonthName() throws Exception {
        String input = "SELECT monthname(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT monthname(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testIfnull() throws Exception {
        String input = "SELECT ifnull(PART_WEIGHT, 'otherString') FROM PARTS";
        String output = "SELECT ifnull(PARTS.PART_WEIGHT, 'otherString') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstring1() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 1) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT, 1) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testSubstring2() throws Exception {
        String input = "SELECT substring(PART_WEIGHT, 1, 5) FROM PARTS";
        String output = "SELECT substring(PARTS.PART_WEIGHT, 1, 5) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testRowLimit2() throws Exception {
        String input = "select intkey from bqt1.smalla limit 100";
        String output = "SELECT SmallA.IntKey FROM SmallA LIMIT 100";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testRowLimit3() throws Exception {
        String input = "select intkey from bqt1.smalla limit 50, 100";
        String output = "SELECT SmallA.IntKey FROM SmallA LIMIT 100 OFFSET 50";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testBitFunctions() throws Exception {
        String input = "select bitand(intkey, intnum), bitnot(intkey), bitor(intnum, intkey), bitxor(intnum, intkey) from bqt1.smalla";
        String output = "SELECT bitand(SmallA.IntKey, SmallA.IntNum), bitnot(SmallA.IntKey), bitor(SmallA.IntNum, SmallA.IntKey), bitxor(SmallA.IntNum, SmallA.IntKey) FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testLocate() throws Exception {
        String input = "SELECT locate(INTNUM, 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT locate(substring('chimp', 1), cast(SmallA.IntNum AS nvarchar)) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate2() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp') FROM BQT1.SMALLA";
        String output = "SELECT locate('chimp', SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate3() throws Exception {
        String input = "SELECT locate(INTNUM, '234567890', 1) FROM BQT1.SMALLA WHERE INTKEY = 26";
        String output = "SELECT locate(substring('234567890', 1), cast(SmallA.IntNum AS nvarchar)) FROM SmallA WHERE SmallA.IntKey = 26";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate4() throws Exception {
        String input = "SELECT locate('h', 'chimp', 1) FROM BQT1.SMALLA";
        String output = "SELECT 2 FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate5() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', -5) FROM BQT1.SMALLA";
        String output = "SELECT locate(substring('chimp', 1), SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate5a() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', 2) FROM BQT1.SMALLA";
        String output = "SELECT locate(substring('chimp', 2), SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate6() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', INTNUM) FROM BQT1.SMALLA";
        String output = "SELECT locate(substring('chimp', CASE WHEN SmallA.IntNum < 1 THEN 1 ELSE SmallA.IntNum END), SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testLocate7() throws Exception {
        String input = "SELECT locate(STRINGNUM, 'chimp', LOCATE(STRINGNUM, 'chimp') + 1) FROM BQT1.SMALLA";
        String output = "SELECT locate(substring('chimp', CASE WHEN (locate('chimp', SmallA.StringNum) + 1) < 1 THEN 1 ELSE (locate('chimp', SmallA.StringNum) + 1) END), SmallA.StringNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testAggregate() throws Exception {
        String input = "SELECT count(*), min(intnum), max(intnum) FROM BQT1.SMALLA";
        String output = "SELECT COUNT(*), MIN(SmallA.IntNum), MAX(SmallA.IntNum) FROM SmallA";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTDistance() throws Exception {
        String input = "select ST_Distance(shape, shape) from cola_markets";
        String output = "SELECT COLA_MARKETS.SHAPE.st_distance(COLA_MARKETS.SHAPE) FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTDisjoint() throws Exception {
        String input = "select ST_Disjoint(shape, shape) from cola_markets";
        String output = "SELECT COLA_MARKETS.SHAPE.st_disjoint(COLA_MARKETS.SHAPE) FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTIntersects() throws Exception {
        String input = "select ST_Intersects(shape, shape) from cola_markets";
        String output = "SELECT COLA_MARKETS.SHAPE.st_intersects(COLA_MARKETS.SHAPE) FROM COLA_MARKETS";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTInsert() throws Exception {
        String input = "insert into cola_markets(name,shape) values('foo124', ST_GeomFromText('POINT (300 100)', 8307))";
        String output = "INSERT INTO COLA_MARKETS (NAME, SHAPE) VALUES ('foo124', st_geomfromwkb(?, 8307))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTInsertNull() throws Exception {
        String input = "insert into cola_markets(name,shape) values('foo124', null)";
        String output = "INSERT INTO COLA_MARKETS (NAME, SHAPE) VALUES ('foo124', ?)";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTSrid() throws Exception {
        String input = "select st_srid(shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_srid() FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTAsBinary() throws Exception {
        String input = "select st_asbinary(shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_asbinary() FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTAsWKT() throws Exception {
        String input = "select st_asewkt(shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_asewkt() FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTAsText() throws Exception {
        String input = "select st_astext(shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_astext() FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTAsGeoJSON() throws Exception {
        String input = "select st_asgeojson(shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_asgeojson() FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTContains() throws Exception {
        String input = "select st_contains(shape, shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_contains(c.SHAPE) FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTCrosses() throws Exception {
        String input = "select st_crosses(shape, shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_crosses(c.SHAPE) FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTEquals() throws Exception {
        String input = "select st_equals(shape, shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_equals(c.SHAPE) FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testSTTouches() throws Exception {
        String input = "select st_touches(shape, shape) from cola_markets c";
        String output = "SELECT c.SHAPE.st_touches(c.SHAPE) FROM COLA_MARKETS AS c";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testVarbinaryComparison() throws Exception {
        String input = "select bin_col from binary_test where bin_col = x'ab'";
        String output = "SELECT binary_test.BIN_COL FROM binary_test WHERE binary_test.BIN_COL = to_binary('AB')";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testVarbinaryInsert() throws Exception {
        String input = "insert into binary_test (bin_col) values (x'bc')";
        String output = "INSERT INTO binary_test (BIN_COL) VALUES (to_binary('BC'))";
        TranslationHelper.helpTestVisitor("/bqt.vdb", input, output, (JDBCExecutionFactory)TRANSLATOR);
    }

    @Test
    public void testPushDownAddDays() throws Exception {
        String input = "SELECT add_days(convert(PART_WEIGHT, date), 30) FROM PARTS";
        String output = "SELECT add_days(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'), 30) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownAddMonths() throws Exception {
        String input = "SELECT add_months(convert(PART_WEIGHT, date), 10) FROM PARTS";
        String output = "SELECT add_months(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'), 10) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownAddSeconds() throws Exception {
        String input = "SELECT add_seconds(convert(PART_WEIGHT, timestamp), 10) FROM PARTS";
        String output = "SELECT add_seconds(to_timestamp(PARTS.PART_WEIGHT, 'YYYY-MM-DD HH24:MI:SS'), 10) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownAddYears() throws Exception {
        String input = "SELECT add_years(convert(PART_WEIGHT, date), 10) FROM PARTS";
        String output = "SELECT add_years(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'), 10) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownCurrentUTCTime() throws Exception {
        String input = "SELECT current_utctime()";
        String output = "SELECT current_utctime()";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownCurrentUTCTimeStamp() throws Exception {
        String input = "SELECT current_utctimestamp()";
        String output = "SELECT current_utctimestamp()";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownDaysBetween() throws Exception {
        String input = "SELECT days_between(convert(PART_WEIGHT, date), convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT days_between(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'), to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownIsoWeek() throws Exception {
        String input = "SELECT isoweek(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT isoweek(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownLastDay() throws Exception {
        String input = "SELECT last_day(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT last_day(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownLocalToUtc() throws Exception {
        String input = "SELECT localtoutc(convert(PART_WEIGHT, timestamp), 'EST') FROM PARTS";
        String output = "SELECT localtoutc(to_timestamp(PARTS.PART_WEIGHT, 'YYYY-MM-DD HH24:MI:SS'), 'EST') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownNano100Between() throws Exception {
        String input = "SELECT nano100_between(convert(PART_WEIGHT, date), convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT nano100_between(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD'), to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownNextDay() throws Exception {
        String input = "SELECT next_day(convert(PART_WEIGHT, date)) FROM PARTS";
        String output = "SELECT next_day(to_date(PARTS.PART_WEIGHT, 'YYYY-MM-DD')) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownCosh() throws Exception {
        String input = "SELECT cosh(0.5) FROM PARTS";
        String output = "SELECT cosh(0.5) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, output);
    }

    @Test
    public void testPushDownBitset() throws Exception {
        String input = "SELECT bitset(convert(bin_col, varbinary), 1, 3) FROM binary_test";
        String output = "SELECT bitset(binary_test.BIN_COL, 1, 3) FROM binary_test";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testMaxBoolean() throws Exception {
        String input = "SELECT max(booleanvalue) FROM bqt1.smalla";
        String output = "SELECT cast(MAX(to_tinyint(SmallA.BooleanValue)) as boolean) FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testCountBoolean() throws Exception {
        String input = "SELECT count(booleanvalue) FROM bqt1.smalla";
        String output = "SELECT COUNT(SmallA.BooleanValue) FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testBooleanCastString() throws Exception {
        String input = "SELECT cast(booleanvalue as string) FROM bqt1.smalla";
        String output = "SELECT CASE WHEN SmallA.BooleanValue = true THEN 'true' WHEN SmallA.BooleanValue IS NOT NULL THEN 'false' END FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testBooleanExpression() throws Exception {
        String input = "SELECT (CASE WHEN BooleanValue THEN 'a' ELSE 'b' END) FROM BQT1.smalla";
        String output = "SELECT CASE WHEN SmallA.BooleanValue = true THEN 'a' ELSE 'b' END FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }

    @Test
    public void testObjectCast() throws Exception {
        String input = "SELECT cast(intkey as object) FROM BQT1.smalla";
        String output = "SELECT SmallA.IntKey FROM SmallA";
        this.helpTestVisitor(this.getTestBQTVDB(), input, output);
    }
}

