/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.mysql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.LocateFunctionModifier;
import org.teiid.translator.jdbc.mysql.BitFunctionModifier;
import org.teiid.util.Version;

@Translator(name="mysql", description="A translator for open source MySQL Database, used with any version lower than 5")
public class MySQLExecutionFactory
extends JDBCExecutionFactory {
    public static final Version FIVE_6 = Version.getVersion((String)"5.6");
    public static final Version FIVE_0 = Version.getVersion((String)"5.0");
    private static final String TINYINT = "tinyint(1)";

    public MySQLExecutionFactory() {
        this.setSupportsFullOuterJoins(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("bitand", new BitFunctionModifier("&", this.getLanguageFactory()));
        this.registerFunctionModifier("bitnot", new BitFunctionModifier("~", this.getLanguageFactory()));
        this.registerFunctionModifier("bitor", new BitFunctionModifier("|", this.getLanguageFactory()));
        this.registerFunctionModifier("bitxor", new BitFunctionModifier("^", this.getLanguageFactory()));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("lpad", new PadFunctionModifier());
        this.registerFunctionModifier("rpad", new PadFunctionModifier());
        this.registerFunctionModifier("week", new AliasModifier("WEEKOFYEAR"));
        this.registerFunctionModifier("st_asbinary", new AliasModifier("AsWKB"));
        this.registerFunctionModifier("st_astext", new AliasModifier("AsWKT"));
        this.registerFunctionModifier("st_geomfromwkb", new AliasModifier("GeomFromWKB"));
        this.registerFunctionModifier("st_geomfromtext", new AliasModifier("GeomFromText"));
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("signed", 2, 3, 4, 5, 6);
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("char", 0);
        convertModifier.addTypeMapping("date", 11);
        convertModifier.addTypeMapping("time", 12);
        convertModifier.addTypeMapping("datetime", 13);
        convertModifier.addConvert(0, 11, new ConvertModifier.FormatModifier("DATE"));
        convertModifier.addConvert(0, 12, new ConvertModifier.FormatModifier("TIME"));
        convertModifier.addConvert(0, 13, new ConvertModifier.FormatModifier("TIMESTAMP"));
        convertModifier.addConvert(11, 0, new ConvertModifier.FormatModifier("date_format", "%Y-%m-%d"));
        convertModifier.addConvert(12, 0, new ConvertModifier.FormatModifier("date_format", "%H:%i:%S"));
        convertModifier.addConvert(13, 0, new ConvertModifier.FormatModifier("date_format", "%Y-%m-%d %H:%i:%S.%f"));
        convertModifier.addTypeConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("(", function.getParameters().get(0), " + 0.0)");
            }
        }, 10, 7, 8, 9);
        convertModifier.addNumericBooleanConversions();
        convertModifier.setWideningNumericImplicit(true);
        this.registerFunctionModifier("convert", convertModifier);
        this.addPushDownFunction("mysql", "SUBSTRING_INDEX", "string", new String[]{"string", "string", "integer"});
    }

    @Override
    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.isVersion5OrGreater()) {
            this.registerFunctionModifier("char", new FunctionModifier(){

                @Override
                public List<?> translate(Function function) {
                    return Arrays.asList("char(", function.getParameters().get(0), " USING ASCII)");
                }
            });
            this.registerFunctionModifier("timestampadd", new FunctionModifier(){

                @Override
                public List<?> translate(Function function) {
                    Literal intervalType = (Literal)function.getParameters().get(0);
                    String interval = ((String)intervalType.getValue()).toUpperCase();
                    if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                        intervalType.setValue((Object)"MICROSECOND");
                        Expression[] args = new Expression[]{(Expression)function.getParameters().get(1), MySQLExecutionFactory.this.getLanguageFactory().createLiteral((Object)1000, TypeFacility.RUNTIME_TYPES.INTEGER)};
                        function.getParameters().set(1, MySQLExecutionFactory.this.getLanguageFactory().createFunction("/", args, TypeFacility.RUNTIME_TYPES.INTEGER));
                    }
                    return null;
                }
            });
            this.addPushDownFunction("mysql", "timestampdiff", "integer", new String[]{"string", "timestamp", "timestamp"});
            this.registerFunctionModifier("timestampdiff", new FunctionModifier(){

                @Override
                public List<?> translate(Function function) {
                    Literal intervalType = (Literal)function.getParameters().get(0);
                    String interval = ((String)intervalType.getValue()).toUpperCase();
                    if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                        intervalType.setValue((Object)"MICROSECOND");
                        return Arrays.asList(function, " * 1000");
                    }
                    return null;
                }
            });
            this.registerFunctionModifier("st_srid", new AliasModifier("SRID"));
        }
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE('" + this.formatDateValue(dateValue) + "')";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME('" + this.formatDateValue(timeValue) + "')";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts '" + this.formatDateValue(timestampValue) + "'}";
    }

    @Override
    public boolean useParensForSetQueries() {
        return true;
    }

    @Override
    public int getTimestampNanoPrecision() {
        if (this.isVersion5OrGreater()) {
            return 9;
        }
        return 0;
    }

    protected boolean isVersion5OrGreater() {
        try {
            return this.getVersion().compareTo(FIVE_0) >= 0;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean useParensForJoins() {
        return true;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("degrees");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("mod");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("radians");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("insert");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("dayname");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("convert");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("st_asbinary");
        supportedFunctions.add("st_astext");
        supportedFunctions.add("st_geomfromwkb");
        supportedFunctions.add("st_geomfromtext");
        if (this.isVersion5OrGreater()) {
            supportedFunctions.add("timestampadd");
            if (this.getVersion().compareTo(FIVE_6) >= 0) {
                supportedFunctions.add("st_intersects");
                supportedFunctions.add("st_contains");
                supportedFunctions.add("st_crosses");
                supportedFunctions.add("st_disjoint");
                supportedFunctions.add("st_distance");
                supportedFunctions.add("st_overlaps");
                supportedFunctions.add("st_touches");
                supportedFunctions.add("st_equals");
            }
            supportedFunctions.add("st_srid");
            supportedFunctions.add("rand");
        }
        return supportedFunctions;
    }

    @Override
    public boolean supportsAggregatesDistinct() {
        return this.isVersion5OrGreater();
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        if (this.isVersion5OrGreater()) {
            return "org.hibernate.dialect.MySQL5Dialect";
        }
        return "org.hibernate.dialect.MySQLDialect";
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new JDBCMetadataProcessor(){

            @Override
            protected String getRuntimeType(int type, String typeName, int precision) {
                if ("geometry".equalsIgnoreCase(typeName)) {
                    return "geometry";
                }
                return super.getRuntimeType(type, typeName, precision);
            }

            @Override
            protected Column addColumn(ResultSet columns, Table table, MetadataFactory metadataFactory, int rsColumns) throws SQLException {
                Column c = super.addColumn(columns, table, metadataFactory, rsColumns);
                if (c.getPrecision() == 0 && "bit".equalsIgnoreCase(c.getNativeType())) {
                    c.setNativeType(MySQLExecutionFactory.TINYINT);
                }
                return c;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void getTableStatistics(Connection conn, String catalog, String schema, String name, Table table) throws SQLException {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = conn.prepareStatement("SELECT cardinality FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema = ? AND table_name = ?");
                    if (catalog != null && schema == null) {
                        stmt.setString(1, catalog);
                    } else {
                        stmt.setString(1, schema);
                    }
                    stmt.setString(2, name);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        int cardinality = rs.getInt(1);
                        if (!rs.wasNull()) {
                            table.setCardinality(cardinality);
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }

            @Override
            protected boolean isUnsignedTypeName(String name) {
                if (!name.contains("UNSIGNED")) {
                    return false;
                }
                return super.isUnsignedTypeName(name);
            }
        };
    }

    @Override
    @Deprecated
    protected JDBCMetadataProcessor createMetadataProcessor() {
        return (JDBCMetadataProcessor)this.getMetadataProcessor();
    }

    @Override
    public Expression translateGeometrySelect(Expression expr) {
        return expr;
    }

    public GeometryType retrieveGeometryValue(ResultSet results, int paramIndex) throws SQLException {
        Blob val = results.getBlob(paramIndex);
        return this.toGeometryType(val);
    }

    @Override
    public GeometryType retrieveGeometryValue(CallableStatement results, int parameterIndex) throws SQLException {
        Blob val = results.getBlob(parameterIndex);
        return this.toGeometryType(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeometryType toGeometryType(final Blob val) throws SQLException {
        if (val == null) {
            return null;
        }
        long length = val.length() - 4L;
        InputStreamFactory streamFactory = new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                InputStream is;
                try {
                    is = val.getBinaryStream();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
                for (int i = 0; i < 4; ++i) {
                    is.read();
                }
                return is;
            }
        };
        InputStream is = val.getBinaryStream();
        int srid = 0;
        try {
            for (int i = 0; i < 4; ++i) {
                try {
                    int b = is.read();
                    srid += b << i * 8;
                    continue;
                }
                catch (IOException e) {
                    srid = 0;
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException i) {}
        }
        streamFactory.setLength(length);
        BlobImpl b = new BlobImpl(streamFactory);
        GeometryType geom = new GeometryType((Blob)b);
        geom.setSrid(srid);
        return geom;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        ColumnReference elem;
        if (obj instanceof ColumnReference && (elem = (ColumnReference)obj).getType() == TypeFacility.RUNTIME_TYPES.BOOLEAN && elem.getMetadataObject() != null && TINYINT.equalsIgnoreCase(elem.getMetadataObject().getNativeType())) {
            return Arrays.asList("case when ", elem, " is null then null when ", elem, " = -1 or ", elem, " > 0 then 1 else 0 end");
        }
        return super.translate(obj, context);
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        SetQuery sq;
        if (command instanceof SetQuery && !(sq = (SetQuery)command).isAll()) {
            ArrayList<Select> allQueries = new ArrayList<Select>();
            this.gatherSelects((QueryExpression)sq, allQueries);
            int size = ((Select)allQueries.get(0)).getDerivedColumns().size();
            block0: for (int i = 0; i < size; ++i) {
                boolean casted = false;
                boolean notCasted = false;
                for (Select select : allQueries) {
                    Function f;
                    Expression ex = ((DerivedColumn)select.getDerivedColumns().get(i)).getExpression();
                    if (ex.getType() != TypeFacility.RUNTIME_TYPES.STRING) continue block0;
                    if (ex instanceof Function && (f = (Function)ex).getName().equalsIgnoreCase("convert")) {
                        casted = true;
                        continue;
                    }
                    notCasted = true;
                }
                if (!casted || !notCasted) continue;
                for (Select select : allQueries) {
                    DerivedColumn dc = (DerivedColumn)select.getDerivedColumns().get(i);
                    if (!(dc.getExpression() instanceof Function) || !((Function)dc.getExpression()).getName().equalsIgnoreCase("CONVERT")) continue;
                    dc.setExpression((Expression)((Function)dc.getExpression()).getParameters().get(0));
                }
            }
        }
        return super.translateCommand(command, context);
    }

    private void gatherSelects(QueryExpression qe, List<Select> allQueries) {
        if (qe instanceof Select) {
            allQueries.add((Select)qe);
            return;
        }
        SetQuery sq = (SetQuery)qe;
        this.gatherSelects(sq.getLeftQuery(), allQueries);
        this.gatherSelects(sq.getRightQuery(), allQueries);
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsLikeRegex() {
        return this.isVersion5OrGreater();
    }

    @Override
    public String getLikeRegexString() {
        return "REGEXP";
    }

    public boolean supportsGroupByRollup() {
        return this.isVersion5OrGreater();
    }

    @Override
    public boolean useWithRollup() {
        return this.isVersion5OrGreater();
    }

    public boolean supportsOrderByWithExtendedGrouping() {
        return false;
    }

    @Override
    public boolean supportsInlineViews() {
        return this.isVersion5OrGreater();
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.isVersion5OrGreater();
    }

    @Override
    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        Object result = super.retrieveValue(results, columnIndex, expectedType);
        if (expectedType == TypeFacility.RUNTIME_TYPES.STRING && (result instanceof Blob || result instanceof byte[])) {
            return results.getString(columnIndex);
        }
        return result;
    }

    @Override
    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        Object result = super.retrieveValue(results, parameterIndex, expectedType);
        if (expectedType == TypeFacility.RUNTIME_TYPES.STRING && (result instanceof Blob || result instanceof byte[])) {
            return results.getString(parameterIndex);
        }
        return result;
    }

    private final class PadFunctionModifier
    extends FunctionModifier {
        private PadFunctionModifier() {
        }

        @Override
        public List<?> translate(Function function) {
            if (function.getParameters().size() == 2) {
                function.getParameters().add(MySQLExecutionFactory.this.getLanguageFactory().createLiteral((Object)" ", TypeFacility.RUNTIME_TYPES.STRING));
            }
            return null;
        }
    }
}

