/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.teiid;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.hql.spi.id.AbstractMultiTableBulkIdStrategyImpl;
import org.hibernate.hql.spi.id.IdTableSupport;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.hibernate.hql.spi.id.local.AfterUseAction;
import org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy;
import org.teiid.GeometryInputSource;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.SQLDialect;
import org.teiid.util.Version;

@Translator(name="teiid", description="A translator for Teiid 7.0 or later")
public class TeiidExecutionFactory
extends JDBCExecutionFactory {
    public static final Version SEVEN_0 = Version.getVersion((String)"7.0");
    public static final Version SEVEN_1 = Version.getVersion((String)"7.1");
    public static final Version SEVEN_2 = Version.getVersion((String)"7.2");
    public static final Version SEVEN_3 = Version.getVersion((String)"7.3");
    public static final Version SEVEN_4 = Version.getVersion((String)"7.4");
    public static final Version SEVEN_5 = Version.getVersion((String)"7.5");
    public static final Version SEVEN_6 = Version.getVersion((String)"7.6");
    public static final Version EIGHT_1 = Version.getVersion((String)"8.1");
    public static final Version EIGHT_3 = Version.getVersion((String)"8.3");
    public static final Version EIGHT_4 = Version.getVersion((String)"8.4");
    public static final Version EIGHT_5 = Version.getVersion((String)"8.5");
    public static final Version EIGHT_10 = Version.getVersion((String)"8.10");
    public static final Version NINE_0 = Version.getVersion((String)"9.0");
    public static final Version NINE_1 = Version.getVersion((String)"9.1");
    public static final Version NINE_2 = Version.getVersion((String)"9.2");
    public static final Version TEN_0 = Version.getVersion((String)"10.0");
    public static final Version ELEVEN_1 = Version.getVersion((String)"11.1");
    public static final Version ELEVEN_2 = Version.getVersion((String)"11.2");

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("FORMATBIGDECIMAL");
        supportedFunctions.add("FORMATBIGINTEGER");
        supportedFunctions.add("FORMATDOUBLE");
        supportedFunctions.add("FORMATFLOAT");
        supportedFunctions.add("FORMATINTEGER");
        supportedFunctions.add("FORMATLONG");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PARSEBIGDECIMAL");
        supportedFunctions.add("PARSEBIGINTEGER");
        supportedFunctions.add("PARSEDOUBLE");
        supportedFunctions.add("PARSEFLOAT");
        supportedFunctions.add("PARSEINTEGER");
        supportedFunctions.add("PARSELONG");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("RAND");
        supportedFunctions.add("ROUND");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("CONCAT2");
        supportedFunctions.add("||");
        supportedFunctions.add("INITCAP");
        supportedFunctions.add("INSERT");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RPAD");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("TRANSLATE");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("CURDATE");
        supportedFunctions.add("CURTIME");
        supportedFunctions.add("NOW");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("FORMATDATE");
        supportedFunctions.add("FORMATTIME");
        supportedFunctions.add("FORMATTIMESTAMP");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("PARSEDATE");
        supportedFunctions.add("PARSETIME");
        supportedFunctions.add("PARSETIMESTAMP");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("MODIFYTIMEZONE");
        supportedFunctions.add("DECODESTRING");
        supportedFunctions.add("DECODEINTEGER");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("USER");
        if (this.getVersion().compareTo(TEN_0) >= 0) {
            supportedFunctions.add("from_unixtime");
            supportedFunctions.add("unix_timestamp");
        }
        supportedFunctions.add("NULLIF");
        supportedFunctions.add("COALESCE");
        if (this.getVersion().compareTo(SEVEN_3) >= 0) {
            supportedFunctions.add("unescape");
        }
        if (this.getVersion().compareTo(SEVEN_4) >= 0) {
            supportedFunctions.add("uuid");
            supportedFunctions.add("array_get");
            supportedFunctions.add("array_length");
        }
        if (this.getVersion().compareTo(SEVEN_5) >= 0) {
            supportedFunctions.add("trim");
        }
        if (this.getVersion().compareTo(EIGHT_3) >= 0) {
            supportedFunctions.add("endswith");
        }
        if (this.getVersion().compareTo(EIGHT_10) >= 0) {
            supportedFunctions.add("st_asbinary");
            supportedFunctions.add("st_asgeojson");
            supportedFunctions.add("st_astext");
            supportedFunctions.add("st_contains");
            supportedFunctions.add("st_crosses");
            supportedFunctions.add("st_disjoint");
            supportedFunctions.add("st_distance");
            supportedFunctions.add("st_equals");
            supportedFunctions.add("st_geomfromwkb");
            supportedFunctions.add("st_geomfromtext");
            supportedFunctions.add("st_intersects");
            supportedFunctions.add("st_overlaps");
            supportedFunctions.add("st_touches");
            supportedFunctions.add("st_srid");
            supportedFunctions.add("st_setsrid");
        }
        if (this.getVersion().compareTo(NINE_0) >= 0) {
            supportedFunctions.add("st_touches");
            supportedFunctions.add("st_hasarc");
            supportedFunctions.add("st_simplify");
            supportedFunctions.add("st_force_2d");
            supportedFunctions.add("st_envelope");
            supportedFunctions.add("st_within");
            supportedFunctions.add("st_dwithin");
            supportedFunctions.add("st_extent");
            supportedFunctions.add("&&");
            supportedFunctions.add("st_geomfromewkt");
            supportedFunctions.add("st_geomfromewkb");
            supportedFunctions.add("st_asewkb");
            supportedFunctions.add("st_asewkt");
        }
        if (this.getVersion().compareTo(NINE_1) >= 0) {
            supportedFunctions.add("st_area");
            supportedFunctions.add("st_boundary");
            supportedFunctions.add("st_buffer");
            supportedFunctions.add("st_centroid");
            supportedFunctions.add("st_convexhull");
            supportedFunctions.add("st_coorddim");
            supportedFunctions.add("st_curvetoline");
            supportedFunctions.add("st_difference");
            supportedFunctions.add("st_dimension");
            supportedFunctions.add("st_endpoint");
            supportedFunctions.add("st_exteriorring");
            supportedFunctions.add("st_geometryn");
            supportedFunctions.add("st_geometrytype");
            supportedFunctions.add("st_interiorringn");
            supportedFunctions.add("st_intersection");
            supportedFunctions.add("st_isclosed");
            supportedFunctions.add("st_isempty");
            supportedFunctions.add("st_isring");
            supportedFunctions.add("st_issimple");
            supportedFunctions.add("st_isvalid");
            supportedFunctions.add("st_length");
            supportedFunctions.add("st_numgeometries");
            supportedFunctions.add("st_numinteriorrings");
            supportedFunctions.add("st_numpoints");
            supportedFunctions.add("st_orderingequals");
            supportedFunctions.add("st_perimeter");
            supportedFunctions.add("st_point");
            supportedFunctions.add("st_pointn");
            supportedFunctions.add("st_pointonsurface");
            supportedFunctions.add("st_polygon");
            supportedFunctions.add("st_relate");
            supportedFunctions.add("st_startpoint");
            supportedFunctions.add("st_symdifference");
            supportedFunctions.add("st_union");
            supportedFunctions.add("st_x");
            supportedFunctions.add("st_y");
            supportedFunctions.add("st_z");
        }
        if (this.getVersion().compareTo(NINE_2) >= 0) {
            supportedFunctions.add("st_makeenvelope");
            supportedFunctions.add("st_snaptogrid");
            supportedFunctions.add("st_simplifypreservetopology");
            supportedFunctions.add("md5");
            supportedFunctions.add("sha1");
            supportedFunctions.add("sha2_256");
            supportedFunctions.add("sha2_512");
        }
        if (this.getVersion().compareTo(ELEVEN_2) >= 0) {
            supportedFunctions.add("st_geogfromtext");
            supportedFunctions.add("st_geogfromwkb");
        }
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.getVersion().compareTo(SEVEN_1) >= 0;
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.UNKNOWN;
    }

    @Override
    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return this.getVersion().compareTo(SEVEN_2) >= 0;
    }

    public boolean supportsRecursiveCommonTableExpressions() {
        return this.getVersion().compareTo(EIGHT_10) >= 0;
    }

    public boolean supportsAdvancedOlapOperations() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsWindowFrameClause() {
        return false;
    }

    public boolean supportsWindowFunctionNtile() {
        return this.getVersion().compareTo(ELEVEN_1) >= 0;
    }

    public boolean supportsWindowFunctionPercentRank() {
        return this.getVersion().compareTo(ELEVEN_1) >= 0;
    }

    public boolean supportsWindowFunctionCumeDist() {
        return this.getVersion().compareTo(ELEVEN_1) >= 0;
    }

    public boolean supportsWindowFunctionNthValue() {
        return this.getVersion().compareTo(ELEVEN_1) >= 0;
    }

    public boolean supportsArrayAgg() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsLikeRegex() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsSimilarTo() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsWindowDistinctAggregates() {
        return this.getVersion().compareTo(SEVEN_6) >= 0;
    }

    public boolean supportsWindowOrderByWithAggregates() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        return true;
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return this.getVersion().compareTo(EIGHT_3) >= 0;
    }

    @Override
    public boolean supportsInsertWithQueryExpression() {
        return true;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    public boolean supportsStringAgg() {
        return this.getVersion().compareTo(EIGHT_4) >= 0;
    }

    @Override
    public SQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new SQLDialect(){

                @Override
                public String getTypeName(int code, long length, int precision, int scale) {
                    return JDBCSQLTypeInfo.getJavaClassName((int)code);
                }

                @Override
                public AbstractMultiTableBulkIdStrategyImpl getDefaultMultiTableBulkIdStrategy() {
                    return new LocalTemporaryTableBulkIdStrategy((IdTableSupport)new IdTableSupportStandardImpl(){

                        public String getCreateIdTableCommand() {
                            return "create local temporary table";
                        }

                        public String getDropIdTableCommand() {
                            return "drop table";
                        }

                        public String getCreateIdTableStatementOptions() {
                            return "";
                        }
                    }, AfterUseAction.DROP, TempTableDdlTransactionHandling.NONE);
                }
            };
        }
        return super.getDialect();
    }

    public boolean supportsGroupByRollup() {
        return this.getVersion().compareTo(EIGHT_5) >= 0;
    }

    @Override
    public boolean useScientificNotation() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return this.getVersion().compareTo(EIGHT_10) >= 0;
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new JDBCMetadataProcessor(){

            @Override
            protected String getRuntimeType(int type, String typeName, int precision) {
                if ("geometry".equalsIgnoreCase(typeName)) {
                    return "geometry";
                }
                if ("geography".equalsIgnoreCase(typeName)) {
                    return "geography";
                }
                if ("json".equalsIgnoreCase(typeName)) {
                    return "json";
                }
                return super.getRuntimeType(type, typeName, precision);
            }

            @Override
            protected String getGeographyMetadataTableName() {
                return "sys.geography_columns";
            }

            @Override
            protected String getGeometryMetadataTableName() {
                return "sys.geometry_columns";
            }

            @Override
            protected String getNativeComponentType(String typeName) {
                if (typeName.endsWith("[]")) {
                    return typeName.substring(0, typeName.length() - 1);
                }
                return super.getNativeComponentType(typeName);
            }
        };
    }

    public boolean supportsLateralJoin() {
        return true;
    }

    @Override
    public String getLateralKeyword() {
        if (this.getVersion().compareTo(EIGHT_1) < 0) {
            return "TABLE";
        }
        return super.getLateralKeyword();
    }

    public boolean supportsProcedureTable() {
        return true;
    }

    public boolean supportsArrayType() {
        return this.getVersion().compareTo(EIGHT_1) > 0;
    }

    public boolean supportsUpsert() {
        return this.getVersion().compareTo(EIGHT_3) > 0;
    }

    public boolean supportsIsDistinctCriteria() {
        return this.getVersion().compareTo(TEN_0) > 0;
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new SQLConversionVisitor(this){

            protected String getUpsertKeyword() {
                if (TeiidExecutionFactory.this.getVersion().compareTo(NINE_1) >= 0) {
                    return "UPSERT";
                }
                return "MERGE";
            }
        };
    }

    public boolean supportsAggregatesCountBig() {
        return this.getVersion().compareTo(ELEVEN_2) > 0;
    }

    public boolean supportsGeographyType() {
        return this.getVersion().compareTo(ELEVEN_2) > 0;
    }

    @Override
    public Expression translateGeometrySelect(Expression expr) {
        return new Function("st_asewkb", Arrays.asList(expr), TypeFacility.RUNTIME_TYPES.BLOB);
    }

    @Override
    public Expression translateGeographySelect(Expression expr) {
        return new Function("st_asewkb", Arrays.asList(new Function("CAST", Arrays.asList(expr, new Literal((Object)"geometry", TypeFacility.RUNTIME_TYPES.STRING)), TypeFacility.RUNTIME_TYPES.GEOMETRY)), TypeFacility.RUNTIME_TYPES.BLOB);
    }

    @Override
    public Object retrieveGeometryValue(ResultSet results, int paramIndex) throws SQLException {
        final Blob blob = results.getBlob(paramIndex);
        if (blob != null) {
            return new GeometryInputSource(){

                public InputStream getEwkb() throws Exception {
                    return blob.getBinaryStream();
                }
            };
        }
        return null;
    }
}

