/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Join;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.Select;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.LocateFunctionModifier;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.db2.SubstringFunctionModifier;

public class BaseDB2ExecutionFactory
extends JDBCExecutionFactory {
    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("char", new AliasModifier("chr"));
        this.registerFunctionModifier("dayofmonth", new AliasModifier("day"));
        this.registerFunctionModifier("ifnull", new AliasModifier("coalesce"));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("substring", new SubstringFunctionModifier());
        this.registerFunctionModifier("mod", new ModFunctionModifier("MOD", this.getLanguageFactory()));
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("real", 8);
        convertModifier.addTypeMapping("numeric(31,0)", 7);
        convertModifier.addTypeMapping("numeric(31,12)", 10);
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("blob", 15, 14);
        convertModifier.addTypeMapping("clob", 16, 17);
        convertModifier.addConvert(12, 13, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("timestamp('1970-01-01', ", function.getParameters().get(0), ")");
            }
        });
        convertModifier.addConvert(11, 13, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("timestamp(", function.getParameters().get(0), ", '00:00:00')");
            }
        });
        convertModifier.addConvert(0, 8, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(double(", function.getParameters().get(0), ") as real)");
            }
        });
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("varchar"), 0);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("smallint"), 3, 4);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("integer"), 5);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("bigint"), 6);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("double"), 9);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("date"), 11);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("time"), 12);
        convertModifier.addTypeConversion(new NullHandlingFormatModifier("timestamp"), 13);
        convertModifier.addNumericBooleanConversions();
        this.registerFunctionModifier("convert", convertModifier);
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return Arrays.asList("FETCH FIRST ", limit.getRowLimit(), " ROWS ONLY");
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        BaseDB2ExecutionFactory.convertCrossJoinToInner(obj, this.getLanguageFactory());
        return super.translate(obj, context);
    }

    public static void convertCrossJoinToInner(LanguageObject obj, LanguageFactory lf) {
        Join join;
        if (obj instanceof Join && (join = (Join)obj).getJoinType() == Join.JoinType.CROSS_JOIN) {
            Literal one = lf.createLiteral((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER);
            join.setCondition((Condition)lf.createCompareCriteria(Comparison.Operator.EQ, (Expression)one, (Expression)one));
            join.setJoinType(Join.JoinType.INNER_JOIN);
        }
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.HIGH;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsSubqueryInOn() {
        return false;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        Select select;
        if (command instanceof Select && ((select = (Select)command).getFrom() == null || select.getFrom().isEmpty())) {
            ArrayList<String> result = new ArrayList<String>();
            result.add("VALUES(");
            for (int i = 0; i < select.getDerivedColumns().size(); ++i) {
                DerivedColumn dc = (DerivedColumn)select.getDerivedColumns().get(i);
                if (i != 0) {
                    result.add(", ");
                }
                result.add((String)dc.getExpression());
            }
            result.add(")");
            return result;
        }
        return super.translateCommand(command, context);
    }

    private final class NullHandlingFormatModifier
    extends ConvertModifier.FormatModifier {
        private NullHandlingFormatModifier(String alias) {
            super(alias);
        }

        @Override
        public List<?> translate(Function function) {
            Expression arg = (Expression)function.getParameters().get(0);
            if (arg instanceof Literal && ((Literal)arg).getValue() == null) {
                ((Literal)function.getParameters().get(1)).setValue((Object)this.alias);
                return null;
            }
            return super.translate(function);
        }
    }
}

