/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Parameter;
import org.teiid.language.SearchedCase;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Procedure;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.TranslatedCommand;

public class SQLConversionVisitor
extends SQLStringVisitor
implements SQLStringVisitor.Substitutor {
    public static final String TEIID_NON_PREPARED = "teiid_rel:non-prepared";
    private static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#############################0.0#############################", DecimalFormatSymbols.getInstance(Locale.US));
    private static double SCIENTIFIC_LOW = Math.pow(10.0, -3.0);
    private static double SCIENTIFIC_HIGH = Math.pow(10.0, 7.0);
    private ExecutionContext context;
    private JDBCExecutionFactory executionFactory;
    private boolean prepared;
    private boolean usingBinding;
    private List preparedValues = new ArrayList();
    private Set<LanguageObject> recursionObjects = Collections.newSetFromMap(new IdentityHashMap());
    private Map<LanguageObject, Object> translations = new IdentityHashMap<LanguageObject, Object>();
    private boolean replaceWithBinding = false;
    private boolean addNullCast;
    private int startDerivedColumn = -1;

    public SQLConversionVisitor(JDBCExecutionFactory ef) {
        this.executionFactory = ef;
        this.prepared = this.executionFactory.usePreparedStatements();
    }

    public void append(LanguageObject obj) {
        if (this.shortNameOnly && obj instanceof ColumnReference) {
            super.append(obj);
            return;
        }
        boolean replacementMode = this.replaceWithBinding;
        if (obj instanceof Command || obj instanceof Function) {
            this.replaceWithBinding = false;
        }
        List<?> parts = null;
        if (!this.recursionObjects.contains(obj)) {
            Object trans = this.translations.get(obj);
            if (trans instanceof List) {
                parts = (List)trans;
            } else if (trans instanceof LanguageObject) {
                obj = (LanguageObject)trans;
            } else {
                parts = this.executionFactory.translate(obj, this.context);
                if (parts != null) {
                    this.translations.put(obj, parts);
                } else {
                    this.translations.put(obj, obj);
                }
            }
        }
        if (parts != null) {
            this.recursionObjects.add(obj);
            for (Object part : parts) {
                if (part instanceof LanguageObject) {
                    this.append((LanguageObject)part);
                    continue;
                }
                this.buffer.append(part);
            }
            this.recursionObjects.remove(obj);
        } else {
            super.append(obj);
        }
        this.replaceWithBinding = replacementMode;
    }

    protected boolean preserveNullTyping() {
        return this.executionFactory.preserveNullTyping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateSQLType(Class<?> type, Object obj, StringBuilder valuesbuffer) {
        if (obj == null) {
            valuesbuffer.append("NULL");
        } else if (Number.class.isAssignableFrom(type)) {
            boolean useFormatting = false;
            if (!this.executionFactory.useScientificNotation()) {
                if (Double.class.isAssignableFrom(type)) {
                    double value = Math.abs((Double)obj);
                    useFormatting = value <= SCIENTIFIC_LOW || value >= SCIENTIFIC_HIGH;
                } else if (Float.class.isAssignableFrom(type)) {
                    float value = Math.abs(((Float)obj).floatValue());
                    useFormatting = (double)value <= SCIENTIFIC_LOW || (double)value >= SCIENTIFIC_HIGH;
                } else if (BigDecimal.class.isAssignableFrom(type)) {
                    valuesbuffer.append(((BigDecimal)obj).toPlainString());
                    return;
                }
            }
            if (useFormatting) {
                DecimalFormat decimalFormat = DECIMAL_FORMAT;
                synchronized (decimalFormat) {
                    valuesbuffer.append(DECIMAL_FORMAT.format(obj));
                }
            } else {
                valuesbuffer.append(obj);
            }
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN)) {
            valuesbuffer.append(this.executionFactory.translateLiteralBoolean((Boolean)obj));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP)) {
            valuesbuffer.append(this.executionFactory.translateLiteralTimestamp((Timestamp)obj));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.TIME)) {
            if (!this.executionFactory.hasTimeType()) {
                valuesbuffer.append(this.executionFactory.translateLiteralTimestamp(new Timestamp(((Time)obj).getTime())));
            } else {
                valuesbuffer.append(this.executionFactory.translateLiteralTime((Time)obj));
            }
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.DATE)) {
            valuesbuffer.append(this.executionFactory.translateLiteralDate((Date)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.VARBINARY)) {
            valuesbuffer.append(this.executionFactory.translateLiteralBinaryType((BinaryType)obj));
        } else {
            String val = obj.toString();
            if (this.useUnicodePrefix() && this.isNonAscii(val)) {
                this.buffer.append("N");
            }
            valuesbuffer.append("'").append(this.escapeString(this.removeCharacters(val), "'")).append("'");
        }
    }

    protected boolean isNonAscii(String val) {
        return this.executionFactory.isNonAscii(val);
    }

    protected String removeCharacters(String value) {
        Pattern p = this.executionFactory.getRemovePushdownCharactersPattern();
        if (p == null) {
            return value;
        }
        return p.matcher(value).replaceAll("");
    }

    protected boolean useUnicodePrefix() {
        return this.executionFactory.useUnicodePrefix();
    }

    public void visit(Call obj) {
        String nativeQuery;
        this.usingBinding = true;
        Procedure p = obj.getMetadataObject();
        if (p != null && (nativeQuery = p.getProperty("teiid_rel:native-query", false)) != null) {
            boolean bl = this.prepared = Boolean.valueOf(p.getProperty(TEIID_NON_PREPARED, false)) == false;
            if (this.prepared) {
                this.preparedValues = new ArrayList();
            }
            SQLConversionVisitor.parseNativeQueryParts((String)nativeQuery, (List)obj.getArguments(), (StringBuilder)this.buffer, (SQLStringVisitor.Substitutor)this);
            return;
        }
        if (obj.isTableReference()) {
            this.usingBinding = false;
            super.visit(obj);
            return;
        }
        this.prepared = true;
        this.generateSqlForStoredProcedure(obj);
    }

    public void visit(Function obj) {
        Expression param;
        String nativeQuery;
        FunctionMethod f = obj.getMetadataObject();
        if (f != null && (nativeQuery = f.getProperty("teiid_rel:native-query", false)) != null) {
            ArrayList<Argument> args = new ArrayList<Argument>(obj.getParameters().size());
            for (Expression p : obj.getParameters()) {
                args.add(new Argument(Argument.Direction.IN, p, p.getType(), null));
            }
            SQLConversionVisitor.parseNativeQueryParts((String)nativeQuery, args, (StringBuilder)this.buffer, (SQLStringVisitor.Substitutor)this);
            return;
        }
        if (obj.getParameters().size() == 1 && (param = (Expression)obj.getParameters().get(0)) instanceof Literal) {
            Literal l = (Literal)param;
            this.addNullCast = l.getValue() == null;
        }
        super.visit(obj);
        this.addNullCast = false;
    }

    public void visit(AggregateFunction obj) {
        Expression param;
        if (obj.getParameters().size() == 1 && (param = (Expression)obj.getParameters().get(0)) instanceof Literal) {
            Literal l = (Literal)param;
            this.addNullCast = l.getValue() == null;
        }
        super.visit(obj);
        this.addNullCast = false;
    }

    public void visit(Parameter obj) {
        this.addBinding((LanguageObject)obj);
    }

    protected void addBinding(LanguageObject value) {
        this.prepared = true;
        this.buffer.append("?");
        this.preparedValues.add(value);
        this.usingBinding = true;
    }

    public void visit(Literal obj) {
        if (this.prepared && (this.replaceWithBinding && obj.isBindEligible() || TranslatedCommand.isBindEligible(obj))) {
            this.addBinding((LanguageObject)obj);
        } else {
            if (this.preserveNullTyping() && obj.getValue() == null && (this.addNullCast || this.startDerivedColumn == this.buffer.length())) {
                String type = "integer";
                if (obj.getType() != TypeFacility.RUNTIME_TYPES.NULL) {
                    type = TypeFacility.getDataTypeName((Class)obj.getType());
                }
                this.addNullCast = false;
                this.append((LanguageObject)ConvertModifier.createConvertFunction(LanguageFactory.INSTANCE, (Expression)obj, type));
                this.addNullCast = true;
                return;
            }
            this.translateSQLType(obj.getType(), obj.getValue(), this.buffer);
        }
    }

    public void visit(In obj) {
        this.replaceWithBinding = true;
        super.visit(obj);
    }

    public void visit(Like obj) {
        this.replaceWithBinding = true;
        super.visit(obj);
    }

    public void visit(Comparison obj) {
        this.replaceWithBinding = true;
        super.visit(obj);
    }

    public void visit(ExpressionValueSource obj) {
        this.replaceWithBinding = true;
        super.visit(obj);
    }

    public void visit(SetClause obj) {
        this.replaceWithBinding = true;
        super.visit(obj);
    }

    public void visit(DerivedColumn obj) {
        this.replaceWithBinding = false;
        this.startDerivedColumn = this.buffer.length();
        super.visit(obj);
        this.startDerivedColumn = -1;
    }

    public void visit(SearchedCase obj) {
        this.replaceWithBinding = false;
        super.visit(obj);
    }

    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    protected ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected String getSourceComment(Command command) {
        return this.executionFactory.getSourceComment(this.context, command);
    }

    protected void generateSqlForStoredProcedure(Call exec) {
        boolean needQuestionMark;
        this.buffer.append(this.getSourceComment((Command)exec));
        this.buffer.append("{");
        List params = exec.getArguments();
        boolean bl = needQuestionMark = exec.getReturnType() != null;
        if (needQuestionMark) {
            this.buffer.append("?= ");
        }
        this.buffer.append("call ");
        this.buffer.append(exec.getMetadataObject() != null ? this.getName((AbstractMetadataRecord)exec.getMetadataObject()) : exec.getProcedureName());
        this.buffer.append("(");
        int numberOfParameters = 0;
        for (Argument param : params) {
            if (param.getDirection() != Argument.Direction.IN && param.getDirection() != Argument.Direction.OUT && param.getDirection() != Argument.Direction.INOUT) continue;
            if (numberOfParameters > 0) {
                this.buffer.append(",");
            }
            ++numberOfParameters;
            if (param.getDirection() != Argument.Direction.IN || param.getExpression() instanceof Literal) {
                this.addBinding((LanguageObject)param);
                continue;
            }
            this.append((LanguageObject)param.getExpression());
        }
        this.buffer.append(")");
        this.buffer.append("}");
    }

    List getPreparedValues() {
        return this.preparedValues;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public boolean isUsingBinding() {
        return this.usingBinding;
    }

    protected boolean useAsInGroupAlias() {
        return this.executionFactory.useAsInGroupAlias();
    }

    protected boolean useParensForSetQueries() {
        return this.executionFactory.useParensForSetQueries();
    }

    protected String replaceElementName(String group, String element) {
        return this.executionFactory.replaceElementName(group, element);
    }

    protected void appendSetOperation(SetQuery.Operation operation) {
        this.buffer.append(this.executionFactory.getSetOperationString(operation));
    }

    protected boolean useParensForJoins() {
        return this.executionFactory.useParensForJoins();
    }

    protected boolean useSelectLimit() {
        return this.executionFactory.useSelectLimit();
    }

    protected String getLikeRegexString() {
        return this.executionFactory.getLikeRegexString();
    }

    protected void appendBaseName(NamedTable obj) {
        String nativeQuery;
        if (obj.getMetadataObject() != null && (nativeQuery = obj.getMetadataObject().getProperty("teiid_rel:native-query", false)) != null) {
            if (obj.getCorrelationName() == null) {
                throw new IllegalArgumentException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11020, new Object[]{obj.getName()}));
            }
            this.buffer.append("(").append(nativeQuery).append(")");
            if (obj.getCorrelationName() == null) {
                this.buffer.append(" ");
                if (this.useAsInGroupAlias()) {
                    this.buffer.append("AS").append(" ");
                }
            }
            return;
        }
        super.appendBaseName(obj);
    }

    public void substitute(Argument arg, StringBuilder builder, int index) {
        if (this.prepared && arg.getExpression() instanceof Literal) {
            this.buffer.append("?");
            this.preparedValues.add(arg);
        } else {
            this.visit(arg);
        }
    }

    public void visit(GroupBy obj) {
        if (obj.isRollup() && this.executionFactory.useWithRollup()) {
            obj.setRollup(false);
            super.visit(obj);
            obj.setRollup(true);
            this.buffer.append(" WITH ROLLUP");
            return;
        }
        super.visit(obj);
    }

    protected void appendLateralKeyword() {
        this.buffer.append(this.executionFactory.getLateralKeyword());
    }
}

