/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.hana;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Comparison;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.Predicate;
import org.teiid.metadata.MetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.LocateFunctionModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.TemplateFunctionModifier;
import org.teiid.translator.jdbc.hana.HanaMetadataProcessor;
import org.teiid.translator.jdbc.hana.HanaSpatialFunctionModifier;
import org.teiid.translator.jdbc.hana.Log10FunctionModifier;
import org.teiid.util.Version;

@Translator(name="hana", description="SAP HANA translator")
public class HanaExecutionFactory
extends JDBCExecutionFactory {
    private static final String TINYINT_TYPE = "tinyint";
    public static final Version SPS8 = Version.getVersion((String)"SPS8");
    private static final String TIME_FORMAT = "HH24:MI:SS";
    private static final String DATE_FORMAT = "YYYY-MM-DD";
    private static final String DATETIME_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    public static final String HANA = "hana";
    public static final String ADD_DAYS = "add_days";
    public static final String ADD_SECONDS = "add_seconds";
    public static final String ADD_WORKDAYS = "add_workdays";
    public static final String ADD_MONTHS = "add_months";
    public static final String ADD_YEARS = "add_years";
    public static final String CURRENT_UTCDATE = "current_utcdate";
    public static final String CURRENT_UTCTIME = "current_utctime";
    public static final String CURRENT_UTCTIMESTAMP = "current_utctimestamp";
    public static final String DAYS_BETWEEN = "days_between";
    public static final String EXTRACT = "extract";
    public static final String ISOWEEK = "isoweek";
    public static final String LAST_DAY = "last_day";
    public static final String LOCALTOUTC = "localtoutc";
    public static final String NANO100_BETWEEN = "nano100_between";
    public static final String NEXT_DAY = "next_day";
    public static final String SECONDS_BETWEEN = "seconds_between";
    public static final String WEEKDAY = "weekday";
    public static final String WORKDAYS_BETWEEN = "weekdays_between";
    public static final String COSH = "cosh";
    public static final String BITSET = "bitset";
    public static final String BITUNSET = "bitunset";
    public static final String HEXTOBIN = "hextobin";
    public static final String RAND = "rand";
    public static final String SINH = "sinh";
    public static final String TANH = "tanh";
    public static final String UMINUS = "uminus";

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("ceiling", new AliasModifier("ceil"));
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("char", new AliasModifier("to_nvarchar"));
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("log", new Log10FunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("ceiling", new AliasModifier("ceil"));
        this.registerFunctionModifier("log10", new Log10FunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("locate", new LocateFunctionModifier(this.getLanguageFactory(), "locate", true){

            @Override
            public void modify(Function function) {
                super.modify(function);
                List args = function.getParameters();
                if (args.size() > 2) {
                    ArrayList<Expression> substringArgs = new ArrayList<Expression>();
                    substringArgs.add((Expression)args.get(0));
                    substringArgs.add((Expression)args.get(2));
                    args.set(0, this.getLanguageFactory().createFunction("substring", substringArgs, null));
                    args.remove(2);
                }
            }
        });
        this.registerFunctionModifier("curdate", new AliasModifier("current_date"));
        this.registerFunctionModifier("curtime", new AliasModifier("current_time"));
        this.registerFunctionModifier("week", new TemplateFunctionModifier("cast(substring(isoweek(", 0, "), 7, 2) as integer)"));
        this.registerFunctionModifier("dayofweek", new TemplateFunctionModifier("(MOD((WEEKDAY(", 0, ")+1),7)+1)"));
        this.registerFunctionModifier("dayname", new TemplateFunctionModifier("initcap(lower(dayname(", 0, ")))"));
        this.registerFunctionModifier("quarter", new TemplateFunctionModifier("((month(", 0, ")+2)/3)"));
        this.registerFunctionModifier("now", new AliasModifier("current_timestamp"));
        this.registerFunctionModifier("st_asewkt", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_asbinary", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_asgeojson", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_astext", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_contains", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_crosses", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_distance", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_disjoint", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_equals", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_intersects", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_srid", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_geomfromtext", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_overlaps", new HanaSpatialFunctionModifier());
        this.registerFunctionModifier("st_touches", new HanaSpatialFunctionModifier());
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.addTypeMapping("boolean", 2);
        convertModifier.addTypeMapping(TINYINT_TYPE, 3);
        convertModifier.addTypeMapping("smallint", 4);
        convertModifier.addTypeMapping("integer", 5);
        convertModifier.addTypeMapping("bigint", 6, 7);
        convertModifier.addTypeMapping("decimal", 10);
        convertModifier.addTypeMapping("float", 8);
        convertModifier.addTypeMapping("date", 11);
        convertModifier.addTypeMapping("double", 9);
        convertModifier.addTypeMapping("time", 12);
        convertModifier.addTypeMapping("timestamp", 13);
        convertModifier.addTypeMapping("nvarchar", 0);
        convertModifier.addTypeMapping("nvarchar(1)", 1);
        convertModifier.addTypeMapping("varbinary", 19);
        convertModifier.addTypeMapping("blob", 15);
        convertModifier.addTypeMapping("nclob", 16);
        convertModifier.addTypeMapping("text", 17);
        convertModifier.addTypeMapping("st_geometry", 20);
        convertModifier.addConvert(0, 11, new ConvertModifier.FormatModifier("to_date", DATE_FORMAT));
        convertModifier.addConvert(0, 12, new ConvertModifier.FormatModifier("to_time", TIME_FORMAT));
        convertModifier.addConvert(0, 13, new ConvertModifier.FormatModifier("to_timestamp", DATETIME_FORMAT));
        convertModifier.setWideningNumericImplicit(true);
        convertModifier.addConvert(2, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Expression trueValue;
                Expression falseValue = trueValue = (Expression)function.getParameters().get(0);
                falseValue = new IsNull(falseValue, true);
                if (!(trueValue instanceof Predicate)) {
                    trueValue = new Comparison(trueValue, (Expression)new Literal((Object)Boolean.TRUE, TypeFacility.RUNTIME_TYPES.BOOLEAN), Comparison.Operator.EQ);
                }
                return Arrays.asList("CASE WHEN ", trueValue, " THEN 'true' WHEN ", falseValue, " THEN 'false' END");
            }
        });
        convertModifier.addSourceConversion(new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ((Literal)function.getParameters().get(1)).setValue((Object)HanaExecutionFactory.TINYINT_TYPE);
                return null;
            }
        }, 2);
        this.registerFunctionModifier("convert", convertModifier);
        this.addPushDownFunction(HANA, ADD_DAYS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(HANA, ADD_MONTHS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(HANA, ADD_SECONDS, "timestamp", new String[]{"timestamp", "integer"});
        this.addPushDownFunction(HANA, ADD_WORKDAYS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(HANA, ADD_YEARS, "date", new String[]{"date", "integer"});
        this.addPushDownFunction(HANA, CURRENT_UTCDATE, "date", new String[0]);
        this.addPushDownFunction(HANA, CURRENT_UTCTIME, "time", new String[0]);
        this.addPushDownFunction(HANA, CURRENT_UTCTIMESTAMP, "timestamp", new String[0]);
        this.addPushDownFunction(HANA, DAYS_BETWEEN, "integer", new String[]{"date", "date"});
        this.addPushDownFunction(HANA, ISOWEEK, "string", new String[]{"date"});
        this.addPushDownFunction(HANA, LAST_DAY, "date", new String[]{"date"});
        this.addPushDownFunction(HANA, LOCALTOUTC, "timestamp", new String[]{"timestamp", "string"});
        this.addPushDownFunction(HANA, NANO100_BETWEEN, "integer", new String[]{"date", "date"});
        this.addPushDownFunction(HANA, NEXT_DAY, "date", new String[]{"date"});
        this.addPushDownFunction(HANA, SECONDS_BETWEEN, "integer", new String[]{"date", "date"});
        this.addPushDownFunction(HANA, WEEKDAY, "integer", new String[]{"date"});
        this.addPushDownFunction(HANA, WORKDAYS_BETWEEN, "date", new String[]{"integer"});
        this.addPushDownFunction(HANA, COSH, "integer", new String[]{"float"});
        this.addPushDownFunction(HANA, BITSET, "string", new String[]{"varbinary", "integer", "integer"});
        this.addPushDownFunction(HANA, BITUNSET, "string", new String[]{"varbinary", "integer", "integer"});
        this.addPushDownFunction(HANA, COSH, "float", new String[]{"float"});
        this.addPushDownFunction(HANA, HEXTOBIN, "blob", new String[]{"string"});
        this.addPushDownFunction(HANA, RAND, "blob", new String[0]);
        this.addPushDownFunction(HANA, SINH, "float", new String[]{"float"});
        this.addPushDownFunction(HANA, TANH, "float", new String[]{"float"});
        this.addPushDownFunction(HANA, UMINUS, "integer", new String[]{"integer"});
    }

    @Override
    public String getHibernateDialectClassName() {
        return "org.hibernate.dialect.HANARowStoreDialect";
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("lcase");
        supportedFunctions.add("lpad");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("replace");
        supportedFunctions.add("left");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("substring");
        supportedFunctions.add("ucase");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("mod");
        supportedFunctions.add("power");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add(RAND);
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayname");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("quarter");
        supportedFunctions.add("second");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("nullif");
        supportedFunctions.add("convert");
        supportedFunctions.add("st_srid");
        supportedFunctions.add("st_asbinary");
        supportedFunctions.add("st_asewkt");
        supportedFunctions.add("st_astext");
        supportedFunctions.add("st_asgeojson");
        supportedFunctions.add("st_contains");
        supportedFunctions.add("st_crosses");
        supportedFunctions.add("st_disjoint");
        supportedFunctions.add("st_distance");
        supportedFunctions.add("st_equals");
        supportedFunctions.add("st_geomfromtext");
        supportedFunctions.add("st_intersects");
        supportedFunctions.add("st_overlaps");
        supportedFunctions.add("st_srid");
        supportedFunctions.add("st_touches");
        return supportedFunctions;
    }

    @Override
    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    @Override
    public boolean supportsInCriteria() {
        return true;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("LIMIT ", limit.getRowLimit(), " OFFSET ", limit.getRowOffset());
        }
        return null;
    }

    @Override
    public void getMetadata(MetadataFactory metadataFactory, Connection connection) throws TranslatorException {
        super.getMetadata(metadataFactory, connection);
    }

    @Override
    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new HanaMetadataProcessor();
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new SQLConversionVisitor(this){

            @Override
            protected void translateSQLType(Class<?> type, Object obj, StringBuilder valuesbuffer) {
                if (type == TypeFacility.RUNTIME_TYPES.VARBINARY) {
                    valuesbuffer.append("to_binary(");
                    super.translateSQLType(TypeFacility.RUNTIME_TYPES.STRING, obj, valuesbuffer);
                    valuesbuffer.append(")");
                } else {
                    super.translateSQLType(type, obj, valuesbuffer);
                }
            }
        };
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        AggregateFunction agg;
        if (obj instanceof AggregateFunction && (agg = (AggregateFunction)obj).getParameters().size() == 1 && (agg.getName().equalsIgnoreCase("MIN") || agg.getName().equalsIgnoreCase("MAX")) && TypeFacility.RUNTIME_TYPES.BOOLEAN.equals(((Expression)agg.getParameters().get(0)).getType())) {
            return Arrays.asList("cast(", agg.getName(), "(to_tinyint(", agg.getParameters().get(0), ")) as boolean)");
        }
        return super.translate(obj, context);
    }

    @Override
    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "true";
        }
        return "false";
    }
}

