/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jpa.JPAPlugin;

public class JPAMetadataProcessor
implements MetadataProcessor<EntityManager> {
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Foriegn Table Name", description="Applicable on Forign Key columns")
    public static final String KEY_ASSOSIATED_WITH_FOREIGN_TABLE = "{http://www.teiid.org/translator/jpa/2014}assosiated_with_table";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Entity Class", description="Java Entity Class that represents this table", required=true)
    public static final String ENTITYCLASS = "{http://www.teiid.org/translator/jpa/2014}entity_class";

    public void process(MetadataFactory mf, EntityManager entityManager) throws TranslatorException {
        Metamodel model = entityManager.getMetamodel();
        Set entities = model.getEntities();
        for (EntityType entity : entities) {
            this.addEntity(mf, model, entity);
        }
        for (EntityType entity : entities) {
            Table t = mf.getSchema().getTable(entity.getName());
            this.addForeignKeys(mf, model, (ManagedType<?>)entity, t);
        }
    }

    private Table addEntity(MetadataFactory mf, Metamodel model, EntityType<?> entity) throws TranslatorException {
        Table table = mf.getSchema().getTable(entity.getName());
        if (table == null) {
            table = mf.addTable(entity.getName());
            table.setSupportsUpdate(true);
            table.setProperty(ENTITYCLASS, entity.getJavaType().getCanonicalName());
            this.addPrimaryKey(mf, model, entity, table);
            this.addSingularAttributes(mf, model, (ManagedType<?>)entity, table);
        }
        return table;
    }

    private boolean columnExists(String name, Table table) {
        return table.getColumnByName(name) != null;
    }

    private Column addColumn(MetadataFactory mf, String name, String type, Table entityTable) throws TranslatorException {
        if (!this.columnExists(name, entityTable)) {
            Column c = mf.addColumn(name, type, (ColumnSet)entityTable);
            c.setUpdatable(true);
            return c;
        }
        return entityTable.getColumnByName(name);
    }

    private void addForiegnKey(MetadataFactory mf, String name, List<String> columnNames, String referenceTable, Table table) throws TranslatorException {
        ForeignKey fk = mf.addForiegnKey("FK_" + name, columnNames, referenceTable, table);
        for (String column : columnNames) {
            Column c = table.getColumnByName(column);
            c.setProperty(KEY_ASSOSIATED_WITH_FOREIGN_TABLE, mf.getName() + "." + referenceTable);
        }
        fk.setNameInSource(name);
    }

    private void addSingularAttributes(MetadataFactory mf, Metamodel model, ManagedType<?> entity, Table entityTable) throws TranslatorException {
        for (Attribute attr : entity.getAttributes()) {
            if (attr.isCollection()) continue;
            boolean simpleType = this.isSimpleType(attr.getJavaType());
            if (simpleType) {
                Column column = this.addColumn(mf, attr.getName(), TypeFacility.getDataTypeName((Class)this.getJavaDataType(attr.getJavaType())), entityTable);
                if (!((SingularAttribute)attr).isOptional()) continue;
                column.setDefaultValue(null);
                continue;
            }
            boolean classFound = false;
            for (EmbeddableType embeddable : model.getEmbeddables()) {
                if (!embeddable.getJavaType().equals(attr.getJavaType())) continue;
                this.addSingularAttributes(mf, model, (ManagedType<?>)embeddable, entityTable);
                classFound = true;
                break;
            }
            if (!classFound) {
                for (EntityType et : model.getEntities()) {
                    if (!et.getJavaType().equals(attr.getJavaType())) continue;
                    Table attributeTable = this.addEntity(mf, model, et);
                    KeyRecord pk = attributeTable.getPrimaryKey();
                    if (pk != null) {
                        ArrayList<String> keys = new ArrayList<String>();
                        for (Column column : pk.getColumns()) {
                            this.addColumn(mf, column.getName(), column.getDatatype().getRuntimeTypeName(), entityTable);
                            keys.add(column.getName());
                        }
                        if (!this.foreignKeyExists(keys, entityTable)) {
                            this.addForiegnKey(mf, attr.getName(), keys, attributeTable.getName(), entityTable);
                        }
                    } else {
                        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14001, new Object[]{attributeTable.getName()}));
                    }
                    classFound = true;
                    break;
                }
            }
            if (classFound) continue;
            throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14002, new Object[]{attr.getName()}));
        }
    }

    private boolean isSimpleType(Class type) {
        return type.isPrimitive() || type.equals(String.class) || type.equals(BigDecimal.class) || type.equals(Date.class) || type.equals(BigInteger.class) || TypeFacility.getRuntimeType((Class)type) != Object.class;
    }

    private void addForeignKeys(MetadataFactory mf, Metamodel model, ManagedType<?> entity, Table entityTable) throws TranslatorException {
        for (Attribute attr : entity.getAttributes()) {
            if (!attr.isCollection()) continue;
            PluralAttribute pa = (PluralAttribute)attr;
            Table forignTable = null;
            for (EntityType et : model.getEntities()) {
                if (!et.getJavaType().equals(pa.getElementType().getJavaType())) continue;
                forignTable = mf.getSchema().getTable(et.getName());
                break;
            }
            if (forignTable == null) continue;
            ArrayList<String> keys = new ArrayList<String>();
            KeyRecord pk = entityTable.getPrimaryKey();
            for (Column entityColumn : pk.getColumns()) {
                this.addColumn(mf, entityColumn.getName(), entityColumn.getDatatype().getRuntimeTypeName(), forignTable);
                keys.add(entityColumn.getName());
            }
            if (this.foreignKeyExists(keys, forignTable)) continue;
            this.addForiegnKey(mf, attr.getName(), keys, entityTable.getName(), forignTable);
        }
    }

    private boolean foreignKeyExists(List<String> keys, Table forignTable) {
        boolean fkExists = false;
        for (ForeignKey fk : forignTable.getForeignKeys()) {
            boolean allKeysFound = true;
            for (String key : keys) {
                boolean keyfound = false;
                for (Column col : fk.getColumns()) {
                    if (!col.getName().equals(key)) continue;
                    keyfound = true;
                    break;
                }
                if (keyfound) continue;
                allKeysFound = false;
                break;
            }
            if (!allKeysFound) continue;
            fkExists = true;
            break;
        }
        return fkExists;
    }

    private void addPrimaryKey(MetadataFactory mf, Metamodel model, EntityType<?> entity, Table entityTable) throws TranslatorException {
        if (entity.hasSingleIdAttribute()) {
            if (entity.getIdType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
                SingularAttribute pkattr = entity.getId(entity.getIdType().getJavaType());
                this.addColumn(mf, pkattr.getName(), TypeFacility.getDataTypeName((Class)this.getJavaDataType(pkattr.getJavaType())), entityTable);
                mf.addPrimaryKey("PK_" + entity.getName(), Arrays.asList(pkattr.getName()), entityTable);
            } else if (entity.getIdType().getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                SingularAttribute pkattr = entity.getId(entity.getIdType().getJavaType());
                for (EmbeddableType embeddable : model.getEmbeddables()) {
                    if (!embeddable.getJavaType().equals(pkattr.getJavaType())) continue;
                    this.addSingularAttributes(mf, model, (ManagedType<?>)embeddable, entityTable);
                    ArrayList<String> keys = new ArrayList<String>();
                    for (Attribute attr : embeddable.getAttributes()) {
                        if (this.isSimpleType(attr.getJavaType())) {
                            keys.add(attr.getName());
                            continue;
                        }
                        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14003, new Object[]{entityTable.getName()}));
                    }
                    mf.addPrimaryKey("PK_" + pkattr.getName(), keys, entityTable);
                    break;
                }
            }
        } else {
            ArrayList<String> keys = new ArrayList<String>();
            for (Object obj : entity.getIdClassAttributes()) {
                SingularAttribute attr = (SingularAttribute)obj;
                this.addColumn(mf, attr.getName(), TypeFacility.getDataTypeName((Class)this.getJavaDataType(attr.getJavaType())), entityTable);
                keys.add(attr.getName());
            }
            mf.addPrimaryKey("PK_" + entity.getName(), keys, entityTable);
        }
    }

    private Class getJavaDataType(Class type) {
        return TypeFacility.getRuntimeType((Class)type);
    }
}

