/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jpa.JPA2ExecutionFactory;
import org.teiid.translator.jpa.JPQLBaseExecution;
import org.teiid.translator.jpa.JPQLSelectVisitor;

public class JPQLQueryExecution
extends JPQLBaseExecution
implements ResultSetExecution {
    private QueryExpression command;
    private Iterator resultsIterator;
    private JPA2ExecutionFactory executionFactory;

    public JPQLQueryExecution(JPA2ExecutionFactory executionFactory, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager em) {
        super(executionContext, metadata, em);
        this.command = command;
        this.executionFactory = executionFactory;
    }

    public void execute() throws TranslatorException {
        String jpql = JPQLSelectVisitor.getJPQLString((Select)this.command, this.executionFactory, this.metadata);
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"JPA Source-Query:", (Object)jpql);
        Query query = this.enityManager.createQuery(jpql);
        List results = query.getResultList();
        this.resultsIterator = results.iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.resultsIterator != null && this.resultsIterator.hasNext()) {
            Object obj = this.resultsIterator.next();
            if (obj instanceof Object[]) {
                return Arrays.asList((Object[])obj);
            }
            return Arrays.asList(obj);
        }
        return null;
    }

    public void close() {
        this.resultsIterator = null;
    }

    public void cancel() throws TranslatorException {
    }
}

