/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jpa.JPAMetadataProcessor;
import org.teiid.translator.jpa.JPQLDirectQueryExecution;
import org.teiid.translator.jpa.JPQLQueryExecution;
import org.teiid.translator.jpa.JPQLUpdateExecution;

@Translator(name="jpa2", description="A translator for JPA2 based entities")
public class JPA2ExecutionFactory
extends ExecutionFactory<EntityManagerFactory, EntityManager> {
    private Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);

    public void start() throws TranslatorException {
        super.start();
        this.setSupportsInnerJoins(true);
        this.setSupportsOrderBy(true);
        this.setSupportsSelectDistinct(true);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
        this.setSupportsOuterJoins(true);
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("lower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("upper"));
        this.registerFunctionModifier("curdate", (FunctionModifier)new AliasModifier("current_date"));
        this.registerFunctionModifier("curtime", (FunctionModifier)new AliasModifier("current_time"));
    }

    public EntityManager getConnection(EntityManagerFactory factory, ExecutionContext executionContext) throws TranslatorException {
        if (factory == null) {
            return null;
        }
        return factory.createEntityManager();
    }

    public void closeConnection(EntityManager connection, EntityManagerFactory factory) {
        connection.close();
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager connection) throws TranslatorException {
        return new JPQLQueryExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            return new JPQLDirectQueryExecution(command.getArguments(), (Command)command, executionContext, metadata, connection, nativeQuery, false);
        }
        throw new TranslatorException("Missing native-query extension metadata.");
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager connection) throws TranslatorException {
        return new JPQLUpdateExecution(command, executionContext, metadata, connection);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager connection) throws TranslatorException {
        return new JPQLDirectQueryExecution(arguments.subList(1, arguments.size()), command, executionContext, metadata, connection, (String)arguments.get(0).getArgumentValue().getValue(), true);
    }

    public MetadataProcessor<EntityManager> getMetadataProcessor() {
        return new JPAMetadataProcessor();
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsAliasedTable() {
        return true;
    }

    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsInCriteriaSubquery() {
        return false;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsExistsCriteria() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsAggregatesDistinct() {
        return true;
    }

    public boolean supportsScalarSubqueries() {
        return true;
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsDependentJoins() {
        return true;
    }

    public boolean supportsSelfJoins() {
        return true;
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("concat");
        supportedFunctions.add("substring");
        supportedFunctions.add("trim");
        supportedFunctions.add("lcase");
        supportedFunctions.add("ucase");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("abs");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("mod");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("nullif");
        return supportedFunctions;
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/");
    }
}

