/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Function;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.TableReference;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jpa.JPA2ExecutionFactory;
import org.teiid.translator.jpa.JPAPlugin;

public class JPQLSelectVisitor
extends HierarchyVisitor {
    protected JPA2ExecutionFactory executionFactory;
    protected static final String UNDEFINED = "<undefined>";
    private LinkedList<JoinTable> joins = new LinkedList();
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected LinkedHashMap<String, NamedTable> implicitGroups = new LinkedHashMap();
    protected AtomicInteger aliasCounter = new AtomicInteger(0);
    protected RuntimeMetadata metadata;

    public JPQLSelectVisitor(JPA2ExecutionFactory executionFactory, RuntimeMetadata metadata) {
        super(false);
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public static String getJPQLString(Select obj, JPA2ExecutionFactory executionFactory, RuntimeMetadata metadata) throws TranslatorException {
        JPQLSelectVisitor visitor = new JPQLSelectVisitor(executionFactory, metadata);
        visitor.visitNode((LanguageObject)obj);
        if (!visitor.exceptions.isEmpty()) {
            throw visitor.exceptions.get(0);
        }
        return visitor.convertToQuery(obj);
    }

    private String convertToQuery(Select obj) {
        JPQLSelectStringVisitor visitor = new JPQLSelectStringVisitor(this);
        visitor.visitNode((LanguageObject)obj);
        return visitor.toString();
    }

    public void visit(Select obj) {
        this.visitNodes(obj.getDerivedColumns());
        this.visitNodes(obj.getFrom());
        this.visitNode((LanguageObject)obj.getWhere());
        this.visitNode((LanguageObject)obj.getGroupBy());
        this.visitNode((LanguageObject)obj.getHaving());
        this.visitNode((LanguageObject)obj.getOrderBy());
    }

    public void visit(ColumnReference obj) {
        String name;
        Column record = obj.getMetadataObject();
        if (record != null && (name = record.getProperty("{http://www.teiid.org/translator/jpa/2014}assosiated_with_table", false)) != null) {
            try {
                Table t = this.metadata.getTable(name);
                if (this.implicitGroups.get(name) == null) {
                    this.implicitGroups.put(name, new NamedTable(t.getName(), "J_" + this.aliasCounter.getAndIncrement(), t));
                }
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        }
    }

    private boolean alreadyInJoin(String tableName) {
        for (JoinTable joinTable : this.joins) {
            if ((joinTable.left == null || !joinTable.left.getMetadataObject().getFullName().equals(tableName)) && (joinTable.right == null || !joinTable.right.getMetadataObject().getFullName().equals(tableName))) continue;
            return true;
        }
        return false;
    }

    public void visit(NamedTable obj) {
        if (this.implicitGroups.isEmpty()) {
            this.joins.add(new JoinTable(obj, null, Join.JoinType.INNER_JOIN));
        } else {
            for (NamedTable table : this.implicitGroups.values()) {
                this.joins.add(new JoinTable(obj, table, Join.JoinType.INNER_JOIN));
            }
        }
    }

    public void visit(Join obj) {
        try {
            this.handleJoin(obj);
            for (NamedTable table : this.implicitGroups.values()) {
                NamedTable parent = this.findParent(table);
                if (parent != null) {
                    if (this.alreadyInJoin(table.getMetadataObject().getFullName())) continue;
                    this.joins.add(new JoinTable(parent, table, Join.JoinType.INNER_JOIN));
                    continue;
                }
                this.exceptions.add(new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14004, new Object[]{table.getName()})));
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private NamedTable findParent(NamedTable child) {
        for (JoinTable jt : this.joins) {
            if (jt.getParent() != null && this.isParentOf(jt.getParent(), child)) {
                return jt.getParent();
            }
            if (jt.getChild() == null || !this.isParentOf(jt.getChild(), child)) continue;
            return jt.getChild();
        }
        return null;
    }

    private JoinTable handleJoin(Join obj) throws TranslatorException {
        TableReference left = obj.getLeftItem();
        TableReference right = obj.getRightItem();
        if (left instanceof NamedTable && right instanceof NamedTable) {
            JoinTable join = this.handleJoin(obj.getJoinType(), left, right, true);
            this.joins.add(join);
            return join;
        }
        JoinTable leftJoin = null;
        if (left instanceof Join) {
            leftJoin = this.handleJoin((Join)left);
            if (right instanceof NamedTable) {
                JoinTable join = this.handleJoin(obj.getJoinType(), leftJoin, (NamedTable)right);
                this.joins.add(join);
                return join;
            }
        }
        JoinTable rightJoin = null;
        if (right instanceof Join) {
            rightJoin = this.handleJoin((Join)right);
            if (left instanceof NamedTable) {
                JoinTable join = this.handleJoin(obj.getJoinType(), (NamedTable)left, rightJoin);
                this.joins.add(join);
                return join;
            }
        }
        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14005, new Object[0]));
    }

    private JoinTable handleJoin(Join.JoinType joinType, JoinTable left, NamedTable right) throws TranslatorException {
        NamedTable parent;
        JoinTable withParent = this.handleJoin(joinType, (TableReference)left.getParent(), (TableReference)right, false);
        JoinTable withChild = this.handleJoin(joinType, (TableReference)left.getChild(), (TableReference)right, false);
        NamedTable namedTable = parent = withParent.getParent() != null ? withParent.getParent() : withChild.getParent();
        if (parent != null) {
            return this.handleJoin(joinType, (TableReference)parent, (TableReference)right, true);
        }
        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14006, new Object[0]));
    }

    private JoinTable handleJoin(Join.JoinType joinType, NamedTable left, JoinTable right) throws TranslatorException {
        NamedTable parent;
        JoinTable withParent = this.handleJoin(joinType, (TableReference)left, (TableReference)right.getParent(), false);
        JoinTable withChild = this.handleJoin(joinType, (TableReference)left, (TableReference)right.getChild(), false);
        NamedTable namedTable = parent = withParent.getParent() != null ? withParent.getParent() : withChild.getParent();
        if (parent != null) {
            return this.handleJoin(joinType, (TableReference)left, (TableReference)parent, true);
        }
        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14006, new Object[0]));
    }

    private JoinTable handleJoin(Join.JoinType joinType, TableReference left, TableReference right, boolean fixCorrelatedNames) {
        NamedTable leftTable = (NamedTable)left;
        NamedTable rightTable = (NamedTable)right;
        JoinTable joinTable = new JoinTable(leftTable, rightTable, joinType);
        if (fixCorrelatedNames) {
            NamedTable table = this.implicitGroups.get(leftTable.getMetadataObject().getFullName());
            if (table != null) {
                table.setCorrelationName(leftTable.getCorrelationName());
            }
            if ((table = this.implicitGroups.get(rightTable.getMetadataObject().getFullName())) != null) {
                table.setCorrelationName(rightTable.getCorrelationName());
            }
        }
        return joinTable;
    }

    private boolean isParentOf(NamedTable parent, NamedTable child) {
        for (ForeignKey fk : parent.getMetadataObject().getForeignKeys()) {
            if (!((Table)fk.getPrimaryKey().getParent()).equals((Object)child.getMetadataObject())) continue;
            return true;
        }
        return false;
    }

    static class JPQLSelectStringVisitor
    extends SQLStringVisitor {
        private JPQLSelectVisitor visitor;

        public JPQLSelectStringVisitor(JPQLSelectVisitor visitor) {
            this.visitor = visitor;
        }

        public void visit(Select obj) {
            this.buffer.append("SELECT").append(" ");
            if (obj.isDistinct()) {
                this.buffer.append("DISTINCT").append(" ");
            }
            this.append(obj.getDerivedColumns());
            if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
                this.buffer.append(" ").append("FROM").append(" ");
                this.append(obj.getFrom());
            }
            if (obj.getWhere() != null) {
                this.buffer.append(" ").append("WHERE").append(" ");
                this.append((LanguageObject)obj.getWhere());
            }
            if (obj.getGroupBy() != null) {
                this.buffer.append(" ");
                this.append((LanguageObject)obj.getGroupBy());
            }
            if (obj.getHaving() != null) {
                this.buffer.append(" ").append("HAVING").append(" ");
                this.append((LanguageObject)obj.getHaving());
            }
            if (obj.getOrderBy() != null) {
                this.buffer.append(" ");
                this.append((LanguageObject)obj.getOrderBy());
            }
        }

        public void visit(ColumnReference column) {
            Column record = column.getMetadataObject();
            if (record != null) {
                String name = record.getProperty("{http://www.teiid.org/translator/jpa/2014}assosiated_with_table", false);
                if (name == null) {
                    this.buffer.append(column.getTable().getCorrelationName()).append(".").append(column.getMetadataObject().getName());
                } else {
                    this.buffer.append(this.visitor.implicitGroups.get(name).getCorrelationName()).append(".").append(column.getMetadataObject().getName());
                }
            } else {
                this.buffer.append(column.getName());
            }
        }

        public void visit(Join obj) {
            this.addFromClause();
        }

        public void visit(Function func) {
            if (this.visitor.executionFactory.getFunctionModifiers().containsKey(func.getName())) {
                this.visitor.executionFactory.getFunctionModifiers().get(func.getName()).translate(func);
            }
            super.visit(func);
        }

        public void visit(NamedTable obj) {
            this.addFromClause();
        }

        private void addFromClause() {
            boolean first = true;
            for (JoinTable joinTable : this.visitor.joins) {
                if (!joinTable.isLeftParent() && joinTable.joinType == Join.JoinType.LEFT_OUTER_JOIN) {
                    joinTable.joinType = Join.JoinType.RIGHT_OUTER_JOIN;
                }
                if (first) {
                    this.buffer.append(joinTable.getParent().getName());
                    this.buffer.append(" ");
                    this.buffer.append("AS").append(" ");
                    this.buffer.append(joinTable.getParent().getCorrelationName());
                    first = false;
                }
                if (joinTable.getChild() == null) continue;
                this.buffer.append(" ");
                switch (joinTable.joinType) {
                    case CROSS_JOIN: {
                        this.buffer.append("CROSS");
                        break;
                    }
                    case FULL_OUTER_JOIN: {
                        this.buffer.append("FULL").append(" ").append("OUTER");
                        break;
                    }
                    case INNER_JOIN: {
                        this.buffer.append("INNER");
                        break;
                    }
                    case LEFT_OUTER_JOIN: {
                        this.buffer.append("LEFT").append(" ").append("OUTER");
                        break;
                    }
                    case RIGHT_OUTER_JOIN: {
                        this.buffer.append("RIGHT").append(" ").append("OUTER");
                        break;
                    }
                    default: {
                        this.buffer.append(JPQLSelectVisitor.UNDEFINED);
                    }
                }
                this.buffer.append(" ").append("JOIN").append(" ");
                this.buffer.append(joinTable.getParent().getCorrelationName()).append(".").append(joinTable.childAttributeName());
                this.buffer.append(" ");
                this.buffer.append("AS").append(" ");
                this.buffer.append(joinTable.getChild().getCorrelationName());
            }
        }
    }

    static class JoinTable {
        NamedTable parent;
        NamedTable child;
        NamedTable left;
        NamedTable right;
        String childAttributeName;
        String parentAttributeName;
        Join.JoinType joinType;

        JoinTable(NamedTable customer, NamedTable address, Join.JoinType type) {
            this.left = customer;
            this.right = address;
            this.joinType = type;
            if (address == null) {
                this.parent = customer;
                this.parentAttributeName = customer.getName();
            } else {
                for (ForeignKey fk : customer.getMetadataObject().getForeignKeys()) {
                    if (!((Table)fk.getReferenceKey().getParent()).equals((Object)address.getMetadataObject())) continue;
                    this.parent = customer;
                    this.child = address;
                    this.childAttributeName = fk.getSourceName();
                    this.parentAttributeName = customer.getName();
                }
                if (this.parent == null) {
                    for (ForeignKey fk : address.getMetadataObject().getForeignKeys()) {
                        if (!((Table)fk.getReferenceKey().getParent()).equals((Object)customer.getMetadataObject())) continue;
                        this.parent = address;
                        this.child = customer;
                        this.childAttributeName = fk.getSourceName();
                        this.parentAttributeName = customer.getName();
                    }
                }
            }
        }

        NamedTable getParent() {
            return this.parent;
        }

        NamedTable getChild() {
            return this.child;
        }

        NamedTable getLeft() {
            return this.left;
        }

        NamedTable getRight() {
            return this.right;
        }

        String childAttributeName() {
            return this.childAttributeName;
        }

        String parentAttributeName() {
            return this.parentAttributeName;
        }

        public boolean isLeftParent() {
            return this.left == this.parent;
        }
    }
}

