/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jpa.JPAPlugin;
import org.teiid.translator.jpa.JPQLBaseExecution;

public class JPQLDirectQueryExecution
extends JPQLBaseExecution
implements ProcedureExecution {
    private Iterator<?> resultsIterator;
    private List<Argument> arguments;
    private boolean returnsArray = true;
    private String query;

    public JPQLDirectQueryExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager em, String query, boolean returnsArray) {
        super(executionContext, metadata, em);
        this.arguments = arguments;
        this.returnsArray = returnsArray;
        this.query = query;
    }

    public void execute() throws TranslatorException {
        if (this.query.length() < 7) {
            throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14008, new Object[0]));
        }
        String firstToken = this.query.substring(0, 7);
        String jpql = this.query.substring(7);
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"JPA Source-Query:", (Object)jpql);
        if (firstToken.equalsIgnoreCase("search;")) {
            StringBuilder buffer = new StringBuilder();
            SQLStringVisitor.parseNativeQueryParts((String)jpql, this.arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

                public void substitute(Argument arg, StringBuilder builder, int index) {
                    Literal argumentValue = arg.getArgumentValue();
                    builder.append(argumentValue);
                }
            });
            jpql = buffer.toString();
            Query queryCommand = this.enityManager.createQuery(jpql);
            List results = queryCommand.getResultList();
            this.resultsIterator = results.iterator();
        } else if (firstToken.equalsIgnoreCase("create;")) {
            Object entity = this.arguments.get(0).getArgumentValue().getValue();
            this.enityManager.merge(entity);
            this.resultsIterator = Arrays.asList(1).iterator();
        } else if (firstToken.equalsIgnoreCase("update;") || firstToken.equalsIgnoreCase("delete;")) {
            Query queryCmd = this.enityManager.createQuery(jpql);
            this.resultsIterator = Arrays.asList(queryCmd.executeUpdate()).iterator();
        } else {
            throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14008, new Object[0]));
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.resultsIterator != null && this.resultsIterator.hasNext()) {
            Object obj = this.resultsIterator.next();
            if (obj instanceof Object[]) {
                if (this.returnsArray) {
                    return Arrays.asList(obj);
                }
                return Arrays.asList((Object[])obj);
            }
            if (this.returnsArray) {
                return Arrays.asList(new Object[]{new Object[]{obj}});
            }
            return Arrays.asList(obj);
        }
        this.resultsIterator = null;
        return null;
    }

    public void close() {
        this.resultsIterator = null;
    }

    public void cancel() throws TranslatorException {
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

